/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcPhpGenerator
extends SmcCodeGenerator {
    public SmcPhpGenerator(SmcOptions options) {
        super(options, TargetLanguage.PHP.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        List<SmcParameter> params;
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("<?php");
        this.mTarget.println("/*");
        this.mTarget.println(" ex: set ro:");
        this.mTarget.println(" DO NOT EDIT.");
        this.mTarget.println(" generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println("*/");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        this.mTarget.println("require_once 'StateMachine/statemap.php';");
        this.mTarget.println();
        for (String imp : fsm.getImports()) {
            this.mTarget.print("require_once '");
            this.mTarget.print(imp);
            this.mTarget.println("';");
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State extends State {");
        this.mTarget.println();
        this.mTarget.println("    public function Entry($fsm) {");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    public function Exit_($fsm) {");
        this.mTarget.println("    }");
        this.mTarget.println();
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print("    public function ");
            this.mTarget.print(trans.getName());
            this.mTarget.print("($fsm");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(") {");
            this.mTarget.println("        $this->Default_($fsm);");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    public function Default_($fsm) {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if ($fsm->getDebugFlag() == true) {");
            this.mTarget.println("            fwrite($fsm->getDebugStream(), \"TRANSITION   : Default\\n\");");
            this.mTarget.println("        }");
        }
        this.mTarget.println("        $state = $fsm->getState()->getName();");
        this.mTarget.println("        $transition = $fsm->getTransition();");
        this.mTarget.println("        $msg = \"\\n\\tState: $state\\n\\tTransition: $transition\";");
        this.mTarget.println("        throw new TransitionUndefinedException($msg);");
        this.mTarget.println("    }");
        this.mTarget.println("}");
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("_sm extends FSMContext {");
        this.mTarget.println();
        String phpState = this.phpStateName(startState);
        this.mTarget.println("    public function __construct($owner) {");
        this.mTarget.print("        parent::__construct(");
        this.mTarget.print(phpState);
        this.mTarget.println(");");
        this.mTarget.println("        $this->_owner = $owner;");
        this.mTarget.println("    }");
        this.mTarget.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print("    public function ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(") {");
            this.mTarget.print("        $this->_transition = \"");
            this.mTarget.print(transName);
            this.mTarget.println("\";");
            this.mTarget.print("        $this->getState()->");
            this.mTarget.print(transName);
            this.mTarget.print("($this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(", ");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("        $this->_transition = NULL;");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    public function getState() {");
        this.mTarget.println("        if ($this->_state == NULL) {");
        this.mTarget.println("            throw new StateUndefinedException();");
        this.mTarget.println("        }");
        this.mTarget.println("        return $this->_state;");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    public function enterStartState() {");
        this.mTarget.println("        $this->_state->Entry($this);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    public function getOwner() {");
        this.mTarget.println("        return $this->_owner;");
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("    public function getStates() {");
            this.mTarget.println("        return array(");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                this.mTarget.print("            ");
                this.mTarget.print(mapName);
                this.mTarget.println("::$Default_,");
                for (SmcState state : map.getStates()) {
                    this.mTarget.print("            ");
                    this.mTarget.print(mapName);
                    this.mTarget.print("::$");
                    this.mTarget.print(state.getClassName());
                    this.mTarget.println(",");
                }
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println("    public function getTransitions() {");
            this.mTarget.println("        return array(");
            for (SmcTransition trans : transitions) {
                this.mTarget.print("            '");
                this.mTarget.print(trans.getName());
                this.mTarget.println("',");
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" Local variables:");
        this.mTarget.println("  buffer-read-only: t");
        this.mTarget.println(" End:");
        this.mTarget.println("*/");
        this.mTarget.println("?>");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default extends ");
        this.mTarget.print(context);
        this.mTarget.println("State {");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.println("    public function getTransitions() {");
            this.mTarget.println("        return array(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
        }
        this.mTarget.println();
        this.mTarget.println("}");
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println(" {");
        for (SmcState state : states) {
            this.mTarget.print("    public static $");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.println(";");
        }
        this.mTarget.println("    public static $Default_;");
        this.mTarget.println("}");
        for (SmcState state : states) {
            this.mTarget.print(mapName);
            this.mTarget.print("::$");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = new ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("('");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("', ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(");");
        }
        this.mTarget.print(mapName);
        this.mTarget.print("::$Default_");
        this.mTarget.print(" = new ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default('");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default_', -1);");
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print(" extends ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default {");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    public function Entry($fsm) {");
            this.mTarget.println("        $ctxt = $fsm->getOwner();");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    public function Exit_($fsm) {");
            this.mTarget.println("        $ctxt = $fsm->getOwner();");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.println("    public function getTransitions() {");
            this.mTarget.println("        return array(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
        }
        this.mTarget.println();
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print("    public function ");
        this.mTarget.print(this.sanitizeKeyword(transName));
        this.mTarget.print("($fsm");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println(") {");
        if (transition.hasCtxtReference()) {
            this.mTarget.println("        $ctxt = $fsm->getOwner();");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if ($fsm->getDebugFlag() == true) {");
            this.mTarget.print("            fwrite($fsm->getDebugStream(), ");
            this.mTarget.print("\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("::\\$");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\");");
            this.mTarget.println("        }");
        }
        this.mIndent = "        ";
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.println("        }");
            }
            this.mTarget.println("        else {");
            this.mTarget.print("            ");
            this.mTarget.print("parent::");
            this.mTarget.print(transName);
            this.mTarget.print("($fsm");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("        }");
        } else if (this.mGuardCount > 1) {
            this.mTarget.println();
        }
        this.mTarget.println("    }");
    }

    @Override
    public void visit(SmcGuard guard) {
        String sep;
        Iterator<SmcParameter> pit;
        List<SmcParameter> parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && !endStateName.contains("::")) {
            endStateName = mapName + "::" + endStateName;
        }
        endStateName = this.phpStateName(endStateName);
        if (!stateName.contains("::")) {
            stateName = mapName + "::" + stateName;
        }
        stateName = this.phpStateName(stateName);
        if (pushStateName != null && pushStateName.length() > 0 && !pushStateName.contains("::")) {
            pushStateName = mapName + "::" + pushStateName;
        }
        pushStateName = this.phpStateName(pushStateName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "    ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("elseif (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent;
        } else {
            indent2 = this.mIndent + "    ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
        }
        if (actions.isEmpty() && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "$endState";
                this.mTarget.print(indent2);
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = $fsm->getState();");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                this.mTarget.print("BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println("->Exit_($fsm)\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->getState()->Exit_($fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                this.mTarget.print("AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println("->Exit_($fsm)\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if ($fsm->getDebugFlag()) {");
            this.mTarget.print(indent2);
            this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
            this.mTarget.print("ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print("->");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.print(");");
            this.mTarget.println("\\n\");");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (actions.isEmpty()) {
            List<SmcAction> entryActions = state.getEntryActions();
            List<SmcAction> exitActions = state.getExitActions();
            if (condition.length() > 0 || this.mGuardCount > 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
            } else if (this.mGuardCount == 1 && (entryActions == null || entryActions.isEmpty()) && (exitActions == null || exitActions.isEmpty()) && transType != SmcElement.TransType.TRANS_PUSH && transType != SmcElement.TransType.TRANS_POP && loopbackFlag && this.mDebugLevel == -1) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
                this.mTarget.print(indent2);
            }
        } else {
            String indent3;
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->clearState();");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("$exception = NULL;");
                this.mTarget.print(indent2);
                this.mTarget.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.print(indent2);
                this.mTarget.println("catch (Exception $exception) {}");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if ($fsm->getDebugFlag()) {");
            this.mTarget.print(indent2);
            this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
            this.mTarget.print("EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print("->");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.print(");");
            this.mTarget.println("\\n\");");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this.mTarget.print(indent2);
                this.mTarget.print("$fsm->setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("->Entry($fsm);\\n\");");
                    this.mTarget.print(indent2);
                    this.mTarget.println("}");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("$fsm->getState()->Entry($fsm);");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                    this.mTarget.print("AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("->Entry($fsm);\\n\");");
                    this.mTarget.print(indent2);
                    this.mTarget.println("}");
                }
            }
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                this.mTarget.print("BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("->Entry($fsm);\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->getState()->Entry($fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag() == true) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fwrite($fsm->getDebugStream(), \"");
                this.mTarget.print("AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("->Entry($fsm);\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (actions.size() > 0 && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println("if ($exception != NULL) {");
            this.mTarget.print(indent2);
            this.mTarget.println("    throw $exception;");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println(");");
            } else {
                this.mTarget.println(");");
            }
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("}");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("$fsm->emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("$ctxt->");
            }
            this.mTarget.print(name);
            this.mTarget.print("(");
            Iterator<String> it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(it.next());
                sep = ", ";
            }
            this.mTarget.println(");");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        String type = parameter.getType();
        if (type.equals("")) {
            this.mTarget.print(parameter.getName());
        } else {
            this.mTarget.print(type);
            this.mTarget.print(" ");
            this.mTarget.print(parameter.getName());
        }
    }

    private String phpStateName(String state) {
        int index = state.indexOf("::");
        String retval = state;
        if (index >= 0) {
            retval = state.substring(0, index) + "::$" + state.substring(index + 2);
        }
        return retval;
    }

    private String sanitizeKeyword(String transName) {
        String retval = transName;
        if (transName.equalsIgnoreCase("Default")) {
            retval = transName + "_";
        }
        return retval;
    }
}

