/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcLuaGenerator
extends SmcCodeGenerator {
    public SmcLuaGenerator(SmcOptions options) {
        super(options, TargetLanguage.LUA.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String mapName;
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("-- ex: set ro:");
        this.mTarget.println("-- DO NOT EDIT.");
        this.mTarget.println("-- generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("-- from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println();
        this.mTarget.println("local error = error");
        if (!this.mNoCatchFlag) {
            this.mTarget.println("local pcall = pcall");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("local tostring = tostring");
        }
        this.mTarget.println("local strformat = require 'string'.format");
        this.mTarget.println();
        this.mTarget.println("local statemap = require 'statemap'");
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String imp : fsm.getImports()) {
            this.mTarget.print("require '");
            this.mTarget.print(imp);
            this.mTarget.println("'");
        }
        this.mTarget.println();
        this.mTarget.println("local _ENV = nil");
        this.mTarget.println();
        this.mTarget.print("local ");
        this.mTarget.print(context);
        this.mTarget.println("State = statemap.State.class()");
        this.mTarget.println();
        this.mTarget.println("local function _empty ()");
        this.mTarget.println("end");
        this.mTarget.print(context);
        this.mTarget.println("State.Entry = _empty");
        this.mTarget.print(context);
        this.mTarget.println("State.Exit = _empty");
        this.mTarget.println();
        this.mTarget.println("local function _default (self, fsm)");
        this.mTarget.println("    self:Default(fsm)");
        this.mTarget.println("end");
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(context);
            this.mTarget.print("State.");
            this.mTarget.print(trans.getName());
            this.mTarget.println(" = _default");
        }
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(context);
        this.mTarget.println("State:Default (fsm)");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if fsm.debugFlag then");
            this.mTarget.println("        fsm.debugStream:write(\"TRANSITION   : Default\\n\")");
            this.mTarget.println("    end");
        }
        this.mTarget.println("    local msg = strformat(\"Undefined Transition\\nState: %s\\nTransition: %s\\n\",");
        this.mTarget.println("                          fsm:getState().name,");
        this.mTarget.println("                          fsm.transition)");
        this.mTarget.println("    error(msg)");
        this.mTarget.println("end");
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print("function ");
            this.mTarget.print(context);
            this.mTarget.println("State:getTransitions ()");
            this.mTarget.println("    return self._transitions");
            this.mTarget.println("end");
        }
        this.mTarget.println();
        for (SmcMap map : maps) {
            mapName = map.getName();
            this.mTarget.print("local ");
            this.mTarget.print(mapName);
            this.mTarget.println(" = {}");
        }
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("local ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" = statemap.FSMContext.class()");
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(":_init ()");
        int index = startState.indexOf("::");
        String luaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print("    self:setState(");
        this.mTarget.print(luaState);
        this.mTarget.println(")");
        this.mTarget.println("end");
        this.mTarget.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            List<SmcParameter> params = trans.getParameters();
            if (transName.equals("Default")) continue;
            this.mTarget.print("function ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(":");
            this.mTarget.print(transName);
            this.mTarget.print(" (");
            if (!params.isEmpty()) {
                this.mTarget.print("...");
            }
            this.mTarget.println(")");
            this.mTarget.print("    self.transition = '");
            this.mTarget.print(transName);
            this.mTarget.println("'");
            this.mTarget.print("    self:getState():");
            this.mTarget.print(transName);
            this.mTarget.print("(self");
            if (!params.isEmpty()) {
                this.mTarget.print(", ...");
            }
            this.mTarget.println(")");
            this.mTarget.println("    self.transition = nil");
            this.mTarget.println("end");
            this.mTarget.println();
        }
        this.mTarget.print("function ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(":enterStartState ()");
        this.mTarget.println("    self:getState():Entry(self)");
        this.mTarget.println("end");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(fsmClassName);
            this.mTarget.println("._States = {");
            for (SmcMap map : maps) {
                mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print("    ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    this.mTarget.println(",");
                }
            }
            this.mTarget.println("}");
            this.mTarget.print("function ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(":getStates ()");
            this.mTarget.println("    return self._States");
            this.mTarget.println("end");
            this.mTarget.println();
            this.mTarget.print(fsmClassName);
            this.mTarget.println("._transitions = {");
            for (SmcTransition trans : transitions) {
                this.mTarget.print("    '");
                this.mTarget.print(trans.getName());
                this.mTarget.println("',");
            }
            this.mTarget.println("}");
            this.mTarget.print("function ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(":getTransitions ()");
            this.mTarget.println("    return self._transitions");
            this.mTarget.println("end");
            this.mTarget.println();
        }
        this.mTarget.println("return ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println();
        this.mTarget.println("-- Local variables:");
        this.mTarget.println("--  buffer-read-only: t");
        this.mTarget.println("-- End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print(mapName);
        this.mTarget.print(".Default = ");
        this.mTarget.print(context);
        this.mTarget.print("State:new('");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default', -1)");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.println(".Default._transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print("    ");
                this.mTarget.print(transName);
                this.mTarget.print(" = ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("}");
        }
        for (SmcState state : states) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print(mapName);
        this.mTarget.print('.');
        this.mTarget.print(stateName);
        this.mTarget.print(" = ");
        this.mTarget.print(mapName);
        this.mTarget.print(".Default:new('");
        this.mTarget.print(mapName);
        this.mTarget.print('.');
        this.mTarget.print(stateName);
        this.mTarget.print("', ");
        this.mTarget.print(SmcMap.getNextStateId());
        this.mTarget.println(")");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print("function ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println(":Entry (fsm)");
            this.mTarget.println("    local ctxt = fsm.owner");
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("end");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print("function ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println(":Exit (fsm)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    local ctxt = fsm.owner");
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("end");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println("._transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print("    ");
                this.mTarget.print(transName);
                this.mTarget.print(" = ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("}");
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String instanceName = state.getInstanceName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        SmcGuard nullGuard = null;
        Iterator<SmcGuard> git = guards.iterator();
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(mapName);
        this.mTarget.print('.');
        this.mTarget.print(stateName);
        this.mTarget.print(':');
        this.mTarget.print(transName);
        this.mTarget.print(" (fsm");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            this.mTarget.print(param.getName());
        }
        this.mTarget.println(")");
        if (transition.hasCtxtReference()) {
            this.mTarget.println("    local ctxt = fsm.owner");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if fsm.debugFlag then");
            this.mTarget.print("        fsm.debugStream:write(");
            this.mTarget.print("\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\")");
            this.mTarget.println("    end");
        }
        String indent2 = this.mIndent;
        this.mIndent = this.mIndent + "    ";
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        this.mIndent = indent2;
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                indent2 = this.mIndent;
                this.mIndent = this.mIndent + "    ";
                nullGuard.accept(this);
                this.mIndent = indent2;
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount > 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    end");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print(mapName);
            this.mTarget.print(".Default:");
            if (!instanceName.equals("DefaultState")) {
                this.mTarget.print(transName);
                this.mTarget.print("(fsm");
                for (SmcParameter param : parameters) {
                    this.mTarget.print(", ");
                    this.mTarget.print(param.getName());
                }
            } else {
                this.mTarget.print("Default(fsm");
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        this.mTarget.println("end");
    }

    @Override
    public void visit(SmcGuard guard) {
        String trArgName;
        String sep;
        Iterator pit;
        Object parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "    ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("if ");
                this.mTarget.print(condition);
                this.mTarget.println(" then");
            } else if (condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("elseif ");
                this.mTarget.print(condition);
                this.mTarget.println(" then");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("else");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent;
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if ");
            this.mTarget.print(condition);
            this.mTarget.println(" then");
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print("local ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = fsm:getState()");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.debugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream:write(\"");
                this.mTarget.print("BEFORE EXIT     : ");
                if (packageName != null && packageName.length() > 0) {
                    this.mTarget.print(packageName);
                    this.mTarget.print(".");
                }
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("end");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("fsm:getState():Exit(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.debugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream:write(\"");
                this.mTarget.print("AFTER EXIT      : ");
                if (packageName != null && packageName.length() > 0) {
                    this.mTarget.print(packageName);
                    this.mTarget.print(".");
                }
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("end");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if fsm.debugFlag then");
            this.mTarget.print(indent2);
            this.mTarget.print("    fsm.debugStream:write(\"");
            this.mTarget.print("ENTER TRANSITION: ");
            if (packageName != null && packageName.length() > 0) {
                this.mTarget.print(packageName);
                this.mTarget.print(".");
            }
            this.mTarget.print(stateName);
            this.mTarget.print(":");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                trArgName = ((SmcParameter)pit.next()).getName();
                this.mTarget.print(sep);
                this.mTarget.print(trArgName);
                this.mTarget.print("=\" .. tostring(");
                this.mTarget.print(trArgName);
                this.mTarget.print(") .. \"");
                sep = ", ";
            }
            this.mTarget.print(")");
            this.mTarget.println("\\n\")");
            this.mTarget.print(indent2);
            this.mTarget.println("end");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("-- No actions.");
            }
        } else {
            String indent3;
            this.mTarget.print(indent2);
            this.mTarget.println("fsm:clearState()");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("local r, msg = pcall(");
                this.mTarget.print(indent2);
                this.mTarget.println("    function ()");
                indent3 = indent2 + "        ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("    end");
                this.mTarget.print(indent2);
                this.mTarget.println(")");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if not r then");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    fsm.debugStream:write(msg)");
                    this.mTarget.print(indent2);
                    this.mTarget.println("end");
                }
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if fsm.debugFlag then");
            this.mTarget.print(indent2);
            this.mTarget.print("    fsm.debugStream:write(\"");
            this.mTarget.print("EXIT TRANSITION : ");
            if (packageName != null && packageName.length() > 0) {
                this.mTarget.print(packageName);
                this.mTarget.print(".");
            }
            this.mTarget.print(stateName);
            this.mTarget.print(":");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                trArgName = ((SmcParameter)pit.next()).getName();
                this.mTarget.print(sep);
                this.mTarget.print(trArgName);
                this.mTarget.print("=\" .. tostring(");
                this.mTarget.print(trArgName);
                this.mTarget.print(") .. \"");
                sep = ", ";
            }
            this.mTarget.print(")");
            this.mTarget.println("\\n\")");
            this.mTarget.print(indent2);
            this.mTarget.println("end");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent2);
            this.mTarget.print("fsm:setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.print("fsm:setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(")");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if fsm.debugFlag then");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    fsm.debugStream:write(\"");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    if (packageName != null && packageName.length() > 0) {
                        this.mTarget.print(packageName);
                        this.mTarget.print(".");
                    }
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(":Entry(fsm)\\n\")");
                    this.mTarget.print(indent2);
                    this.mTarget.println("end");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("fsm:getState():Entry(fsm)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if fsm.debugFlag then");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    fsm.debugStream:write(\"");
                    this.mTarget.print("AFTER ENTRY     : ");
                    if (packageName != null && packageName.length() > 0) {
                        this.mTarget.print(packageName);
                        this.mTarget.print(".");
                    }
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(":Entry(fsm)\\n\")");
                    this.mTarget.print(indent2);
                    this.mTarget.println("end");
                }
            }
            this.mTarget.print(indent2);
            this.mTarget.print("fsm:pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent2);
            this.mTarget.println("fsm:popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.debugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream:write(\"");
                this.mTarget.print("BEFORE ENTRY    : ");
                if (packageName != null && packageName.length() > 0) {
                    this.mTarget.print(packageName);
                    this.mTarget.print(".");
                }
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(":Entry(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("end");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("fsm:getState():Entry(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.debugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream:write(\"");
                this.mTarget.print("AFTER ENTRY     : ");
                if (packageName != null && packageName.length() > 0) {
                    this.mTarget.print(packageName);
                    this.mTarget.print(".");
                }
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(":Entry(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("end");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("fsm:");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println(")");
            } else {
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.println(arguments.get(0));
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("fsm:emptyStateStack()");
            } else {
                this.mTarget.print("ctxt:");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }
}

