/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcGroovyGenerator
extends SmcCodeGenerator {
    public SmcGroovyGenerator(SmcOptions options) {
        super(options, TargetLanguage.GROOVY.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("// ex: set ro:");
        this.mTarget.println("// DO NOT EDIT.");
        this.mTarget.println("// generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("// from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println();
            this.mTarget.println(rawSource);
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.println();
            this.mTarget.print("package ");
            this.mTarget.println(packageName);
        }
        this.mTarget.println();
        for (String string : fsm.getImports()) {
            this.mTarget.print("import ");
            this.mTarget.println(string);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" extends statemap.FSMContext");
        if (this.mSerialFlag) {
            this.mTarget.print(" implements Serializable");
        }
        this.mTarget.println(" {");
        this.mTarget.println();
        this.mTarget.println("    def owner");
        this.mTarget.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print("    def ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" (owner) {");
        this.mTarget.print("        super(");
        this.mTarget.print(javaState);
        this.mTarget.println(")");
        this.mTarget.println();
        this.mTarget.println("        this.owner = owner");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    def ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" (owner, initState) {");
        this.mTarget.println("        super(initState)");
        this.mTarget.println();
        this.mTarget.println("        this.owner = owner");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    def enterStartState() {");
        this.mTarget.println("        state.Entry(this)");
        this.mTarget.println("    }");
        this.mTarget.println();
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition smcTransition : transitions) {
            if (smcTransition.getName().equals("Default")) continue;
            if (this.mSyncFlag) {
                this.mTarget.print("    synchronized void ");
            } else {
                this.mTarget.print("    def ");
            }
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print(" (");
            List<SmcParameter> params = smcTransition.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(") {");
            this.mTarget.print("        transition = '");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.println("'");
            this.mTarget.print("        state.");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(", ");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println(")");
            this.mTarget.println("        transition = ''");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (this.mReflectFlag) {
            boolean firstFlag = true;
            this.mTarget.println("    final states = [");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    if (firstFlag) {
                        firstFlag = false;
                    } else {
                        this.mTarget.println(",");
                    }
                    this.mTarget.print("        ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                }
            }
            this.mTarget.println();
            this.mTarget.println("    ]");
            this.mTarget.println();
            this.mTarget.println("    final transitions = [");
            firstFlag = true;
            for (SmcTransition trans : transitions) {
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    this.mTarget.println(",");
                }
                this.mTarget.print("        '");
                this.mTarget.print(trans.getName());
                this.mTarget.print("'");
            }
            this.mTarget.println();
            this.mTarget.println("    ]");
        }
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.print("private class ");
        this.mTarget.print(context);
        this.mTarget.println("State extends statemap.State {");
        this.mTarget.println();
        this.mTarget.println("    def Entry (context) {}");
        this.mTarget.println("    def Exit (context) {}");
        this.mTarget.println();
        for (SmcTransition smcTransition : transitions) {
            String transName = smcTransition.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print("    def ");
            this.mTarget.print(transName);
            this.mTarget.print(" (context");
            for (SmcParameter param : smcTransition.getParameters()) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(") {");
            this.mTarget.println("        Default(context)");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    def Default (context) {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if (context.debugFlag)");
            this.mTarget.println("            context.debugStream.println 'TRANSITION   : Default'");
            this.mTarget.println();
        }
        this.mTarget.println("        throw new statemap.TransitionUndefinedException(");
        this.mTarget.println("                'State: ' + context.state.name +");
        this.mTarget.println("                ', Transition: ' + context.transition)");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("}");
        this.mTarget.println();
        for (SmcMap smcMap : maps) {
            smcMap.accept(this);
        }
        this.mTarget.println();
        this.mTarget.println("// Local variables:");
        this.mTarget.println("//  buffer-read-only: t");
        this.mTarget.println("// End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.print("private class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default extends ");
        this.mTarget.print(context);
        this.mTarget.println("State {");
        this.mIndent = "    ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print("    def transitions = [");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.println(sep);
                this.mTarget.print("        ");
                this.mTarget.print(transName);
                this.mTarget.print(":");
                this.mTarget.print(transDefinition);
                sep = ",";
            }
            this.mTarget.println();
            this.mTarget.println("    ]");
            this.mTarget.println();
        }
        this.mTarget.println("}");
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println(" {");
        for (SmcState state : states) {
            this.mTarget.print("    static final ");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = new ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("(name:'");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("', id:");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(")");
        }
        this.mTarget.print("    static final Default = new ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(name:'");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default', id:-1)");
        this.mTarget.println("}");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print("private class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print(" extends ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default {");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    def Entry (context) {");
            this.mTarget.println("        def ctxt = context.owner");
            this.mTarget.println();
            String indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    def Exit (context) {");
            this.mTarget.println("        def ctxt = context.owner");
            this.mTarget.println();
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("    }");
        }
        this.mIndent = "    ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print("    final transitions = [");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.println(sep);
                this.mTarget.print("        ");
                this.mTarget.print(transName);
                this.mTarget.print(":");
                this.mTarget.print(transDefinition);
                sep = ",";
            }
            this.mTarget.println();
            this.mTarget.println("    ]");
            this.mTarget.println();
        }
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        SmcGuard nullGuard = null;
        Iterator<SmcGuard> git = guards.iterator();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("def ");
        this.mTarget.print(transName);
        this.mTarget.print("(context");
        for (SmcParameter parameter : parameters) {
            this.mTarget.print(", ");
            parameter.accept(this);
        }
        this.mTarget.println(") {");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.println("def ctxt = context.owner");
            this.mTarget.println();
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if (context.debugFlag)");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        context.debugStream.println(");
            this.mTarget.print("'LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("')");
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        super.");
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent4;
        String indent3;
        String sep;
        Iterator pit;
        Object parameters;
        String fqEndStateName;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
        }
        if (!hasActions) {
            fqEndStateName = endStateName;
        } else if (loopbackFlag) {
            fqEndStateName = "endState";
            this.mTarget.print(indent2);
            this.mTarget.print("def ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(" = context.state");
        } else {
            fqEndStateName = endStateName;
        }
        this.mTarget.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.debugFlag)");
                this.mTarget.print(indent2);
                this.mTarget.print("    context.debugStream.println('");
                this.mTarget.print("BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(context)')");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.state.Exit(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.debugFlag)");
                this.mTarget.print(indent2);
                this.mTarget.print("    context.debugStream.println('");
                this.mTarget.print("AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(context)')");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if (context.debugFlag)");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        context.debugStream.println(");
            this.mTarget.print("'ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("')");
            this.mTarget.println();
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("context.clearState()");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println('}');
                this.mTarget.print(indent2);
                this.mTarget.println("finally {");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this.mIndent;
            this.mIndent = indent3;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("if (context.debugFlag)");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    context.debugStream.println(");
            this.mTarget.print("'EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("')");
            this.mTarget.println();
            this.mIndent = indent4;
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("context.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(")");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.debugFlag)");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    context.debugStream.println('");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(context)')");
                    this.mTarget.println();
                }
                this.mTarget.print(indent3);
                this.mTarget.println("context.state.Entry(context)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.debugFlag)");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    context.debugStream.println('");
                    this.mTarget.print("AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(context)')");
                    this.mTarget.println();
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("context.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("context.popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (context.debugFlag)");
                this.mTarget.print(indent3);
                this.mTarget.print("    context.debugStream.println('");
                this.mTarget.print("BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(context)')");
                this.mTarget.println();
            }
            this.mTarget.print(indent3);
            this.mTarget.println("context.state.Entry(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (context.debugFlag)");
                this.mTarget.print(indent3);
                this.mTarget.print("    context.debugStream.println('");
                this.mTarget.print("AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(context)')");
                this.mTarget.println();
            }
        }
        if (hasActions && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println('}');
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(")");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.println(arguments.get(0));
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("context.emptyStateStack()");
            } else {
                this.mTarget.print("ctxt.");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        String type = parameter.getType();
        if (type.equals("")) {
            this.mTarget.print(parameter.getName());
        } else {
            this.mTarget.print(type);
            this.mTarget.print(" ");
            this.mTarget.print(parameter.getName());
        }
    }
}

