/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcVisitor;

public abstract class SmcCodeGenerator
extends SmcVisitor {
    public static final String DEFAULT_HEADER_SUFFIX = "h";
    public static final int NO_DEBUG_OUTPUT = -1;
    public static final int DEBUG_LEVEL_0 = 0;
    public static final int DEBUG_LEVEL_1 = 1;
    public static final int NO_GRAPH_LEVEL = -1;
    public static final int GRAPH_LEVEL_0 = 0;
    public static final int GRAPH_LEVEL_1 = 1;
    public static final int GRAPH_LEVEL_2 = 2;
    private static final String TARGET_PATH_FORMAT = "{0}{1}.{2}";
    private static final String BACKDIR = "..";
    private static String sSuffix;
    protected final String mAppName;
    protected final String mAppVersion;
    protected String mTargetFile;
    protected PrintStream mTarget;
    protected final String mSrcfileBase;
    protected final String mTargetfileBase;
    protected final String mSrcDirectory;
    protected final String mHeaderDirectory;
    protected final String mHeaderSuffix;
    protected final String mCastType;
    protected final int mGraphLevel;
    protected String mIndent;
    protected int mGuardCount;
    protected int mGuardIndex;
    protected final boolean mSerialFlag;
    protected final int mDebugLevel;
    protected final boolean mNoExceptionFlag;
    protected final boolean mNoCatchFlag;
    protected final boolean mNoStreamsFlag;
    protected final boolean mCRTPFlag;
    protected final int mStateStackSize;
    protected final boolean mReflectFlag;
    protected final boolean mSyncFlag;
    protected final boolean mGenericFlag;
    protected final boolean mJava7Flag;
    protected final String mAccessLevel;
    protected final boolean mUseProtocolFlag;

    protected SmcCodeGenerator(SmcOptions options, String suffix) {
        this.mAppName = options.applicationName();
        this.mAppVersion = options.applicationVersion();
        this.mSrcfileBase = options.srcfileBase();
        this.mTargetfileBase = options.targetfileBase();
        this.mSrcDirectory = options.targetDirectory();
        this.mHeaderDirectory = options.headerDirectory();
        this.mHeaderSuffix = options.headerSuffix();
        this.mCastType = options.castType();
        this.mGraphLevel = options.graphLevel();
        this.mSerialFlag = options.serialFlag();
        this.mDebugLevel = options.debugLevel();
        this.mNoExceptionFlag = options.noExceptionFlag();
        this.mNoCatchFlag = options.noCatchFlag();
        this.mNoStreamsFlag = options.noStreamsFlag();
        this.mCRTPFlag = options.crtpFlag();
        this.mStateStackSize = options.stateStackSize();
        this.mReflectFlag = options.reflectFlag();
        this.mSyncFlag = options.syncFlag();
        this.mGenericFlag = options.genericFlag();
        this.mJava7Flag = options.java7Flag();
        this.mAccessLevel = options.accessLevel();
        this.mUseProtocolFlag = options.useProtocolFlag();
        sSuffix = suffix;
        this.mTarget = null;
        this.mIndent = "";
        this.mGuardCount = 0;
        this.mGuardIndex = 0;
    }

    public String defaultSuffix() {
        return sSuffix;
    }

    public String targetFile() {
        return this.mTargetFile;
    }

    public PrintStream target() {
        return this.mTarget;
    }

    protected boolean isLoopback(SmcElement.TransType transType, String endState) {
        return (transType == SmcElement.TransType.TRANS_SET || transType == SmcElement.TransType.TRANS_PUSH) && endState.equals("nil");
    }

    protected boolean allNilEndStates(List<SmcGuard> guards) {
        boolean retcode = true;
        Iterator<SmcGuard> git = guards.iterator();
        while (git.hasNext() && retcode) {
            SmcGuard guard = git.next();
            retcode = guard.getTransType() == SmcElement.TransType.TRANS_SET && guard.getEndState().equals("nil");
        }
        return retcode;
    }

    public String setTargetFile(String targetPath, String basename, String suffix) {
        MessageFormat formatter = new MessageFormat(TARGET_PATH_FORMAT);
        Object[] args = new Object[]{targetPath, basename, suffix == null ? sSuffix : suffix};
        this.mTargetFile = formatter.format(args);
        return this.mTargetFile;
    }

    public void setTarget(PrintStream target) {
        this.mTarget = target;
    }

    public static String escape(String s) {
        String retval;
        if (s.indexOf(92) < 0 && s.indexOf(34) < 0) {
            retval = s;
        } else {
            StringBuilder buffer = new StringBuilder(s.length() * 2);
            int length = s.length();
            for (int index = 0; index < length; ++index) {
                char c = s.charAt(index);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            retval = buffer.toString();
        }
        return retval;
    }

    protected String scopeStateName(String stateName, String mapName) {
        return this.scopeStateName(stateName, mapName, ".");
    }

    protected String scopeStateName(String stateName, String mapName, String ifs) {
        int index = stateName.indexOf("::");
        String mName = mapName;
        String sName = stateName;
        if (index > 0) {
            mName = stateName.substring(0, index);
        }
        if (index >= 0) {
            sName = stateName.substring(index + 2);
        }
        return mName + ifs + sName;
    }

    protected String findPath(String srcDir, String headerDir) {
        File dir0 = new File(srcDir);
        File dir1 = new File(headerDir);
        String path0 = "";
        String path1 = "";
        try {
            int index;
            String ifs = Pattern.quote(File.separator);
            String[] abs0 = dir0.getCanonicalPath().split(ifs);
            String[] abs1 = dir1.getCanonicalPath().split(ifs);
            int minSize = abs0.length < abs1.length ? abs0.length : abs1.length;
            boolean flag = true;
            for (index = 0; index < minSize && flag; ++index) {
                flag = abs0[index].equals(abs1[index]);
            }
            if (!flag) {
                path0 = SmcCodeGenerator.backupPath(--index, abs0.length);
                path1 = SmcCodeGenerator.generatePath(index, abs1);
            } else if (abs1.length > abs0.length) {
                path0 = "";
                path1 = SmcCodeGenerator.generatePath(index, abs1);
            } else if (abs0.length > abs1.length) {
                path0 = SmcCodeGenerator.backupPath(index, abs0.length);
                path1 = "";
            }
        }
        catch (IOException ioex) {
            path0 = "ERROR calling java.io.File.getCanonicalPath: ";
            path1 = ioex.getMessage();
        }
        return path0 + path1;
    }

    private static String backupPath(int index, int length) {
        StringBuilder retval = new StringBuilder();
        String sep = "";
        for (int i = index; i < length; ++i) {
            retval.append(sep);
            retval.append(BACKDIR);
            sep = File.separator;
        }
        retval.append(File.separator);
        return retval.toString();
    }

    private static String generatePath(int index, String[] path) {
        StringBuilder retval = new StringBuilder();
        String sep = "";
        for (int i = index; i < path.length; ++i) {
            retval.append(sep);
            retval.append(path[i]);
            sep = File.separator;
        }
        retval.append(File.separatorChar);
        return retval.toString();
    }
}

