/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.sf.smc.SmcSyntaxChecker;
import net.sf.smc.generator.SmcCGenerator;
import net.sf.smc.generator.SmcCSharpGenerator;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcCppGenerator;
import net.sf.smc.generator.SmcGraphGenerator;
import net.sf.smc.generator.SmcGroovyGenerator;
import net.sf.smc.generator.SmcHeaderCGenerator;
import net.sf.smc.generator.SmcHeaderGenerator;
import net.sf.smc.generator.SmcHeaderObjCGenerator;
import net.sf.smc.generator.SmcJSGenerator;
import net.sf.smc.generator.SmcJava7Generator;
import net.sf.smc.generator.SmcJavaGenerator;
import net.sf.smc.generator.SmcLuaGenerator;
import net.sf.smc.generator.SmcObjCGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.generator.SmcPerlGenerator;
import net.sf.smc.generator.SmcPhpGenerator;
import net.sf.smc.generator.SmcPythonGenerator;
import net.sf.smc.generator.SmcRubyGenerator;
import net.sf.smc.generator.SmcScalaGenerator;
import net.sf.smc.generator.SmcTableGenerator;
import net.sf.smc.generator.SmcTclGenerator;
import net.sf.smc.generator.SmcVBGenerator;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcVisitor;
import net.sf.smc.model.TargetLanguage;
import net.sf.smc.parser.SmcMessage;
import net.sf.smc.parser.SmcParser;

public final class Smc {
    public static final String APP_NAME = "smc";
    public static final String VERSION = "v. 7.5.0";
    public static final String SM_SUFFIX = ".sm";
    public static final String ACCESS_FLAG = "-access";
    public static final String CAST_FLAG = "-cast";
    public static final String DIRECTORY_FLAG = "-d";
    public static final String DEBUG_FLAG = "-g";
    public static final String DEBUG_LEVEL0_FLAG = "-g0";
    public static final String DEBUG_LEVEL1_FLAG = "-g1";
    public static final String GENERIC_FLAG = "-generic";
    public static final String GENERIC7_FLAG = "-generic7";
    public static final String GLEVEL_FLAG = "-glevel";
    public static final String HEADER_FLAG = "-headerd";
    public static final String HEADER_SUFFIX_FLAG = "-hsuffix";
    public static final String HELP_FLAG = "-help";
    public static final String NO_CATCH_FLAG = "-nocatch";
    public static final String NO_EXCEPTIONS_FLAG = "-noex";
    public static final String NO_STREAMS_FLAG = "-nostreams";
    public static final String CRTP_FLAG = "-crtp";
    public static final String STACK_FLAG = "-static";
    public static final String REFLECT_FLAG = "-reflect";
    public static final String RETURN_FLAG = "-return";
    public static final String SERIAL_FLAG = "-serial";
    public static final String SILENT_FLAG = "-silent";
    public static final String SUFFIX_FLAG = "-suffix";
    public static final String SYNC_FLAG = "-sync";
    public static final String VERBOSE_FLAG = "-verbose";
    public static final String VERSION_FLAG = "-version";
    public static final String VVERBOSE_FLAG = "-vverbose";
    public static final String USE_PROTOCOL_FLAG = "-protocol";
    public static final String PACKAGE_LEVEL = "package";
    public static final String PACKAGE_ACCESS = "/* package */";
    static Language sTargetLanguage;
    private static String sSourceFileName;
    private static List<String> sSourceFileList;
    private static String sSuffix;
    private static String sHSuffix;
    private static String sOutputDirectory;
    private static String sHeaderDirectory;
    private static int sDebugLevel;
    private static boolean sNostreams;
    private static boolean sCRTP;
    private static boolean sSync;
    private static boolean sNoex;
    private static boolean sNocatch;
    private static int sStateStackSize;
    private static boolean sSerial;
    private static boolean sReflection;
    private static boolean sGeneric;
    private static boolean sJava7Flag;
    private static boolean sVerbose;
    private static boolean sFSMVerbose;
    private static int sGraphLevel;
    private static String sCastType;
    private static boolean sReturn;
    private static String sAccessLevel;
    private static boolean sProtocol;
    private static String sErrorMsg;
    private static String sVersion;
    private static final Language[] sLanguages;
    private static final Map<String, List<Language>> sOptionMap;
    private static final Map<Language, List<String>> sAccessMap;

    public static void main(String[] args) {
        int retcode = 0;
        sErrorMsg = "";
        sTargetLanguage = null;
        sVersion = VERSION;
        sDebugLevel = -1;
        sNostreams = false;
        sCRTP = false;
        sSync = false;
        sNoex = false;
        sNocatch = false;
        sStateStackSize = 0;
        sSerial = false;
        sCastType = "dynamic_cast";
        sGraphLevel = 0;
        sSourceFileList = new ArrayList<String>();
        sVerbose = false;
        sFSMVerbose = false;
        sReturn = false;
        sReflection = false;
        sOutputDirectory = null;
        sHeaderDirectory = null;
        sSuffix = null;
        sHSuffix = "h";
        sAccessLevel = null;
        sGeneric = false;
        sJava7Flag = false;
        sProtocol = false;
        if (!Smc.parseArgs(args)) {
            retcode = 1;
            System.err.println("smc: " + sErrorMsg);
        } else {
            long startTime = 0L;
            long totalStartTime = 0L;
            if (sVerbose) {
                totalStartTime = System.currentTimeMillis();
            }
            try {
                for (String sSourceFileName : sSourceFileList) {
                    if (sVerbose) {
                        System.out.print("[parsing started ");
                        System.out.print(sSourceFileName);
                        System.out.println("]");
                        startTime = System.currentTimeMillis();
                    }
                    SmcParser parser = new SmcParser(Smc.getFileName(sSourceFileName), (InputStream)new FileInputStream(sSourceFileName), sTargetLanguage.language(), sFSMVerbose);
                    SmcFSM fsm = parser.parse();
                    if (sVerbose) {
                        long finishTime = System.currentTimeMillis();
                        System.out.print("[parsing completed ");
                        System.out.print(finishTime - startTime);
                        System.out.println("ms]");
                    }
                    if (parser.getMessages().size() > 0) {
                        Smc.outputMessages(sSourceFileName, System.err, parser.getMessages());
                    }
                    if (fsm == null) {
                        retcode = 1;
                        continue;
                    }
                    SmcSyntaxChecker checker = new SmcSyntaxChecker(sSourceFileName, sTargetLanguage.language());
                    if (sVerbose) {
                        System.out.print("[checking ");
                        System.out.print(sSourceFileName);
                        System.out.println("]");
                    }
                    fsm.accept((SmcVisitor)checker);
                    if (checker.getMessages().size() > 0) {
                        Smc.outputMessages(sSourceFileName, System.err, checker.getMessages());
                    }
                    if (!checker.isValid()) {
                        retcode = 1;
                        continue;
                    }
                    Smc.generateCode(fsm);
                }
            }
            catch (FileNotFoundException filex) {
                System.err.print(sSourceFileName);
                System.err.print(": error - ");
                System.err.println(filex.getMessage());
            }
            catch (ParseException parsex) {
                System.err.print(sSourceFileName);
                System.err.print(":");
                System.err.print(parsex.getErrorOffset());
                System.err.print(": error - ");
                System.err.println(parsex.getMessage());
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                retcode = 1;
                System.err.println("SMC has experienced a fatal error. Please e-mail the following error output to rapp@acm.org. Thank you.\n");
                System.err.println("--------------------------------------------------------------------------------");
                System.err.println("SMC version: " + sVersion);
                System.err.println("JRE version: v. " + System.getProperty("java.version"));
                System.err.println("JRE vender: " + System.getProperty("java.vendor") + " (" + System.getProperty("java.vendor.url") + ")");
                System.err.println("JVM: " + System.getProperty("java.vm.name") + ", v. " + System.getProperty("java.vm.version"));
                System.err.println("JVM vender: " + System.getProperty("java.vm.vendor"));
                System.err.println("Exception:\n");
                e.printStackTrace(System.err);
                System.err.println("--------------------------------------------------------------------------------");
            }
            if (sVerbose) {
                long totalFinishTime = System.currentTimeMillis();
                System.out.print("[total ");
                System.out.print(totalFinishTime - totalStartTime);
                System.out.println("ms]");
            }
        }
        if (!sReturn) {
            System.exit(retcode);
        }
    }

    private Smc() {
    }

    public static final Language findTargetLanguage(String name) {
        String dash = "-";
        String lName = name.toLowerCase();
        if (!lName.startsWith("-")) {
            lName = "-" + lName;
        }
        return Smc.findLanguage(lName);
    }

    public static boolean supportsOption(String option, Language language) {
        List<Language> languages = sOptionMap.get(option);
        return languages != null && languages.contains(language);
    }

    public static boolean isValidDirectory(String path, boolean readable, boolean writable) {
        boolean retcode = false;
        try {
            File pathObj = new File(path);
            if (!pathObj.isDirectory()) {
                sErrorMsg = "\"" + path + "\" is not a directory";
            } else if (readable && !pathObj.canRead()) {
                sErrorMsg = "\"" + path + "\" is not readble";
            } else if (writable && !pathObj.canWrite()) {
                sErrorMsg = "\"" + path + "\" is not writable";
            } else {
                retcode = true;
            }
        }
        catch (SecurityException securex) {
            sErrorMsg = "unable to access \"" + path + "\"";
        }
        return retcode;
    }

    public static boolean isValidAccessLevel(String s, Language targetLanguage) {
        boolean retcode = sAccessMap.containsKey(targetLanguage);
        if (retcode) {
            retcode = sAccessMap.get(targetLanguage).contains(s);
        }
        return retcode;
    }

    public static boolean isValidCast(String castType) {
        return castType.equals("dynamic_cast") || castType.equals("static_cast") || castType.equals("reinterpret_cast");
    }

    public static boolean isValidGraphLevel(int glevel) {
        return glevel >= 0 && glevel <= 2;
    }

    public static String getFileName(String fullName) {
        File file = new File(fullName);
        String fileName = file.getName();
        return fileName.substring(0, fileName.toLowerCase().indexOf(SM_SUFFIX));
    }

    public static void outputMessages(String srcFileName, PrintStream stream, List<SmcMessage> messages) {
        for (SmcMessage message : messages) {
            stream.println(message);
        }
    }

    private static boolean parseArgs(String[] args) {
        int i;
        boolean retcode = true;
        boolean helpFlag = Smc.needHelp(args);
        if (!helpFlag) {
            try {
                sTargetLanguage = Smc.findTargetLanguage(args);
            }
            catch (IllegalArgumentException argex) {
                retcode = false;
                sErrorMsg = argex.getMessage();
            }
            if (retcode && sTargetLanguage == null) {
                retcode = false;
                sErrorMsg = "Target language was not specified.";
            }
        }
        int argsConsumed = 0;
        for (i = 0; i < args.length && !helpFlag && retcode && args[i].startsWith("-"); i += argsConsumed) {
            block142: {
                if (Smc.findLanguage(args[i]) != null) {
                    argsConsumed = 1;
                } else if (args[i].startsWith("-ac")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-access not followed by an access keyword";
                    } else if (!Smc.supportsOption(ACCESS_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + ACCESS_FLAG + ".";
                    } else if (!Smc.isValidAccessLevel(args[i + 1])) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support access level" + args[i + 1] + ".";
                    } else {
                        sAccessLevel = args[i + 1];
                        argsConsumed = 2;
                    }
                } else if (args[i].startsWith("-sy")) {
                    if (!Smc.supportsOption(SYNC_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + SYNC_FLAG + ".";
                    } else {
                        sSync = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-su")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-suffix not followed by a value";
                    } else if (!Smc.supportsOption(SUFFIX_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + SUFFIX_FLAG + ".";
                    } else {
                        sSuffix = args[i + 1];
                        argsConsumed = 2;
                    }
                } else if (args[i].startsWith("-hs")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-hsuffix not followed by a value";
                    } else if (!Smc.supportsOption(HEADER_SUFFIX_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + HEADER_SUFFIX_FLAG + ".";
                    } else {
                        sHSuffix = args[i + 1];
                        argsConsumed = 2;
                    }
                } else if (args[i].startsWith("-ca")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-cast not followed by a value";
                    } else if (!Smc.supportsOption(CAST_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + CAST_FLAG + ".";
                    } else if (!Smc.isValidCast(args[i + 1])) {
                        retcode = false;
                        sErrorMsg = "\"" + args[i + 1] + "\" is an invalid C++ cast type.";
                    } else {
                        sCastType = args[i + 1];
                        argsConsumed = 2;
                    }
                } else if (args[i].startsWith(CRTP_FLAG)) {
                    if (!Smc.supportsOption(CRTP_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + CRTP_FLAG + ".";
                    } else {
                        sCRTP = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].equals(DIRECTORY_FLAG)) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-d not followed by directory";
                    } else if (!Smc.supportsOption(DIRECTORY_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + DIRECTORY_FLAG + ".";
                    } else {
                        sOutputDirectory = args[i + 1];
                        argsConsumed = 2;
                        if (!sOutputDirectory.endsWith(File.separator)) {
                            sOutputDirectory = sOutputDirectory + File.separator;
                        }
                        retcode = Smc.isValidDirectory(sOutputDirectory, false, true);
                    }
                } else if (args[i].startsWith("-hea")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-headerd not followed by directory";
                    } else if (!Smc.supportsOption(HEADER_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + HEADER_FLAG + ".";
                    } else {
                        sHeaderDirectory = args[i + 1];
                        argsConsumed = 2;
                        if (!sHeaderDirectory.endsWith(File.separator)) {
                            sHeaderDirectory = sHeaderDirectory + File.separator;
                        }
                        retcode = Smc.isValidDirectory(sHeaderDirectory, false, true);
                    }
                } else if (args[i].startsWith("-gl")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-glevel not followed by integer";
                    } else if (!Smc.supportsOption(GLEVEL_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + GLEVEL_FLAG + ".";
                    } else {
                        try {
                            sGraphLevel = Integer.parseInt(args[i + 1]);
                            if (!Smc.isValidGraphLevel(sGraphLevel)) {
                                retcode = false;
                                sErrorMsg = "-glevel must be 0, 1 or 2";
                                break block142;
                            }
                            argsConsumed = 2;
                        }
                        catch (NumberFormatException numberex) {
                            retcode = false;
                            sErrorMsg = "-glevel not followed by valid integer";
                        }
                    }
                } else if (args[i].equals(DEBUG_FLAG)) {
                    if (!Smc.supportsOption(DEBUG_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + DEBUG_FLAG + ".";
                    } else {
                        sDebugLevel = 0;
                        argsConsumed = 1;
                    }
                } else if (args[i].equals(DEBUG_LEVEL0_FLAG)) {
                    if (!Smc.supportsOption(DEBUG_LEVEL0_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + DEBUG_LEVEL0_FLAG + ".";
                    } else {
                        sDebugLevel = 0;
                        argsConsumed = 1;
                    }
                } else if (args[i].equals(DEBUG_LEVEL1_FLAG)) {
                    if (!Smc.supportsOption(DEBUG_LEVEL1_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + DEBUG_LEVEL1_FLAG + ".";
                    } else {
                        sDebugLevel = 1;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-nos")) {
                    if (!Smc.supportsOption(NO_STREAMS_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + NO_STREAMS_FLAG + ".";
                    } else {
                        sNostreams = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-noe")) {
                    if (!Smc.supportsOption(NO_EXCEPTIONS_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + NO_EXCEPTIONS_FLAG + ".";
                    } else {
                        sNoex = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-noc")) {
                    if (!Smc.supportsOption(NO_CATCH_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + NO_CATCH_FLAG + ".";
                    } else {
                        sNocatch = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-stac")) {
                    if (!Smc.supportsOption(STACK_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + STACK_FLAG + ".";
                    } else if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        retcode = false;
                        sErrorMsg = "-static not followed by an integer value.";
                    } else {
                        try {
                            sStateStackSize = Integer.parseInt(args[i + 1]);
                            if (sStateStackSize <= 0) {
                                retcode = false;
                                sErrorMsg = "-static not followed by an integer value > 0.";
                                break block142;
                            }
                            argsConsumed = 2;
                        }
                        catch (NumberFormatException numberex) {
                            retcode = false;
                            sErrorMsg = "-static not followed by a valid integer.";
                        }
                    }
                } else if (args[i].startsWith("-proto")) {
                    if (!Smc.supportsOption(USE_PROTOCOL_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + USE_PROTOCOL_FLAG + ".";
                    } else {
                        sProtocol = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-ret")) {
                    if (!Smc.supportsOption(RETURN_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + RETURN_FLAG + ".";
                    } else {
                        sReturn = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-ref")) {
                    if (!Smc.supportsOption(REFLECT_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + REFLECT_FLAG + ".";
                    } else {
                        sReflection = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].equals(GENERIC_FLAG)) {
                    if (!Smc.supportsOption(GENERIC_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + GENERIC_FLAG + ".";
                    } else if (sGeneric) {
                        retcode = false;
                        sErrorMsg = "-generic already set.";
                    } else {
                        sGeneric = true;
                        sJava7Flag = false;
                        argsConsumed = 1;
                    }
                } else if (args[i].equals(GENERIC7_FLAG)) {
                    if (!Smc.supportsOption(GENERIC7_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + GENERIC7_FLAG + ".";
                    } else if (sGeneric) {
                        retcode = false;
                        sErrorMsg = "-generic already set.";
                    } else {
                        sGeneric = true;
                        sJava7Flag = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-se")) {
                    if (!Smc.supportsOption(SERIAL_FLAG)) {
                        retcode = false;
                        sErrorMsg = sTargetLanguage.name() + " does not support " + SERIAL_FLAG + ".";
                    } else {
                        sSerial = true;
                        argsConsumed = 1;
                    }
                } else if (args[i].startsWith("-verb")) {
                    sVerbose = true;
                    argsConsumed = 1;
                } else if (args[i].startsWith("-vverb")) {
                    sFSMVerbose = true;
                    argsConsumed = 1;
                } else {
                    retcode = false;
                    sErrorMsg = "Unknown option (" + args[i] + ")";
                }
            }
            argsConsumed = 0;
        }
        if (!helpFlag && retcode) {
            if (i == args.length) {
                retcode = false;
                sErrorMsg = "Missing source file";
            } else {
                while (i < args.length && retcode) {
                    if (!args[i].toLowerCase().endsWith(SM_SUFFIX)) {
                        retcode = false;
                        sErrorMsg = "Source file name must end in \".sm\" (" + args[i] + ")";
                    } else {
                        File sourceFile = new File(args[i]);
                        if (!sourceFile.exists()) {
                            retcode = false;
                            sErrorMsg = "No such file named \"" + args[i] + "\"";
                        } else if (!sourceFile.canRead()) {
                            retcode = false;
                            sErrorMsg = "Source file \"" + args[i] + "\" is not readable";
                        } else {
                            String fileName = args[i];
                            if (File.separatorChar != '/') {
                                String fileSeparator = Matcher.quoteReplacement(File.separator);
                                fileName = fileName.replace("/", fileSeparator);
                            }
                            sSourceFileList.add(fileName);
                        }
                    }
                    ++i;
                }
            }
        }
        return retcode;
    }

    private static boolean needHelp(String[] args) {
        boolean retval = false;
        for (int i = 0; i < args.length && !retval; ++i) {
            if (args[i].startsWith("-hel")) {
                retval = true;
                Smc.usage(System.out);
                continue;
            }
            if (!args[i].startsWith("-vers")) continue;
            retval = true;
            System.out.println("smc " + sVersion);
        }
        return retval;
    }

    private static Language findTargetLanguage(String[] args) {
        Language retval = null;
        for (int i = 0; i < args.length; ++i) {
            Language lang = Smc.findLanguage(args[i]);
            if (lang == null) continue;
            if (retval != null && retval != lang) {
                throw new IllegalArgumentException("Only one target language may be specified");
            }
            retval = lang;
        }
        return retval;
    }

    private static Language findLanguage(String option) {
        Language retval = null;
        for (int index = 1; index < sLanguages.length && retval == null; ++index) {
            if (!option.equals(sLanguages[index].optionFlag())) continue;
            retval = sLanguages[index];
        }
        return retval;
    }

    private static boolean supportsOption(String option) {
        List<Language> languages = sOptionMap.get(option);
        return languages != null && languages.contains(sTargetLanguage);
    }

    private static boolean isValidAccessLevel(String s) {
        boolean retcode = sAccessMap.containsKey(sTargetLanguage);
        if (retcode) {
            List<String> levels = sAccessMap.get(sTargetLanguage);
            retcode = levels.contains(s);
        }
        return retcode;
    }

    private static void usage(PrintStream stream) {
        stream.print("usage: ");
        stream.print(APP_NAME);
        stream.print(" [-access level]");
        stream.print(" [-suffix suffix]");
        stream.print(" [-g | -g0 | -g1]");
        stream.print(" [-nostreams]");
        stream.print(" [-crtp]");
        stream.print(" [-version]");
        stream.print(" [-verbose]");
        stream.print(" [-vverbose]");
        stream.print(" [-help]");
        stream.print(" [-sync]");
        stream.print(" [-noex]");
        stream.print(" [-nocatch]");
        stream.print(" [-stack max-stack-depth]");
        stream.print(" [-protocol]");
        stream.print(" [-serial]");
        stream.print(" [-return]");
        stream.print(" [-reflect]");
        stream.print(" [-generic]");
        stream.print(" [-generic7]");
        stream.print(" [-cast cast_type]");
        stream.print(" [-d directory]");
        stream.print(" [-headerd directory]");
        stream.print(" [-hsuffix suffix]");
        stream.print(" [-glevel int]");
        stream.print(" {-c | -c++ | -csharp | -graph | -groovy | -java | ");
        stream.print("-java7 | -js -lua | -objc | -perl | -php | -python | ");
        stream.print("-ruby | -scala | -table |-tcl | -vb}");
        stream.println(" statemap_file");
        stream.println("    where:");
        stream.println("\t-access   Use this access keyword for the generated classes");
        stream.println("\t          (use with -java, -java7 only)");
        stream.println("\t-suffix   Add this suffix to output file");
        stream.println("\t-g, -g0   Add level 0 debugging output to generated code");
        stream.println("\t          (output for entering, exiting states and transitions)");
        stream.println("\t-g1       Add level 1 debugging output to generated code");
        stream.println("\t          (level 0 output plus state Entry and Exit actions)");
        stream.println("\t-nostreams Do not use C++ iostreams");
        stream.print("\t          ");
        stream.println("(use with -c++ only)");
        stream.println("\t-crtp     Generate state machine using CRTP");
        stream.print("\t          ");
        stream.println("(use with -c++ only)");
        stream.print("\t-version  Print smc version ");
        stream.println("information to standard out and exit");
        stream.print("\t-verbose  ");
        stream.println("Output compiler messages (SMC is silent by default).");
        stream.print("\t-vverbose  ");
        stream.println("Output more compiler messages.");
        stream.print("\t-help     Print this message to ");
        stream.println("standard out and exit");
        stream.println("\t-sync     Synchronize access to transition methods");
        stream.print("\t          ");
        stream.println("(use with -csharp, -java, -java7, -groovy, -scala and -vb only)");
        stream.println("\t-noex     Do not generate C++ exception throws ");
        stream.print("\t          ");
        stream.println("(use with -c++ only)");
        stream.print("\t-nocatch  Do not generate try/catch/rethrow ");
        stream.println("code (not recommended)");
        stream.println("\t-stack    Specifies a fixed-size state stack");
        stream.print("\t          ");
        stream.println("using no dynamic memory allocation.");
        stream.print("\t          ");
        stream.println("(use with -c++ only)");
        stream.println("\t-protocol FSM context extends a @protocol and referenced via protocol");
        stream.print("\t          ");
        stream.println("(use with -objc only)");
        stream.println("\t-serial   Generate serialization code");
        stream.print("\t-return   ");
        stream.println("Smc.main() returns, not exits");
        stream.print("\t          ");
        stream.println("(use this option with ANT)");
        stream.println("\t-reflect  Generate reflection code");
        stream.print("\t          ");
        stream.print("(use with -csharp, -groovy, -java, -java7, -js, -lua,");
        stream.print(" -perl, -php, -python, -ruby, -scala, ");
        stream.println("-tcl and -vb only)");
        stream.println("\t-generic  Use generic collections");
        stream.print("\t          ");
        stream.println("(use with -csharp, -java or -vb and -reflect only)");
        stream.println("\t-generic7  Use Java 7 generic collections");
        stream.print("\t          ");
        stream.println("(use with -java  and -reflect only)");
        stream.println("\t-cast     Use this C++ cast type ");
        stream.print("\t          ");
        stream.println("(use with -c++ only)");
        stream.println("\t-d        Place generated files in directory");
        stream.print("\t-headerd  Place generated header files in ");
        stream.println("directory");
        stream.print("\t          ");
        stream.println("(use with -c, -c++, -objc only)");
        stream.println("\t-hsuffix  Add this suffix to output header file");
        stream.print("\t          ");
        stream.println("(use with -c, -c++, -objc only)");
        stream.print("\t-glevel   Detail level from 0 (least) to 2 ");
        stream.println("(greatest)");
        stream.print("\t          ");
        stream.println("(use with -graph only)");
        stream.println("\t-c        Generate C code");
        stream.println("\t-c++      Generate C++ code");
        stream.println("\t-csharp   Generate C# code");
        stream.println("\t-graph    Generate GraphViz DOT file");
        stream.println("\t-groovy   Generate Groovy code");
        stream.println("\t-java     Generate Java code");
        stream.println("\t-java7    Generate Java code as a transition table");
        stream.println("\t-js       Generate JavaScript code");
        stream.println("\t-lua      Generate Lua code");
        stream.println("\t-objc     Generate Objective-C code");
        stream.println("\t-perl     Generate Perl code");
        stream.println("\t-php      Generate PHP code");
        stream.println("\t-python   Generate Python code");
        stream.println("\t-ruby     Generate Ruby code");
        stream.println("\t-scala    Generate Scala code");
        stream.println("\t-table    Generate HTML table code");
        stream.println("\t-tcl      Generate [incr Tcl] code");
        stream.println("\t-vb       Generate VB.Net code");
        stream.println();
        stream.println("    Note: statemap_file must end in \".sm\"");
        stream.print("    Note: must select one of -c, -c++, -csharp, ");
        stream.print("-graph, -groovy, -java, -java7, -lua, -objc, -perl, ");
        stream.println("-php, -python, -ruby, -scala, -table, -tcl or -vb.");
    }

    private static void generateCode(SmcFSM fsm) throws IOException, ParseException {
        int endIndex = sSourceFileName.lastIndexOf(File.separatorChar);
        String targetFileBase = fsm.getTargetFileName();
        String headerFileName = "";
        FileOutputStream headerFileStream = null;
        SmcCodeGenerator headerGenerator = null;
        System.setProperty("line.separator", "\n");
        String targetFilePath = sOutputDirectory != null ? sOutputDirectory : (endIndex >= 0 ? sSourceFileName.substring(0, endIndex + 1) : "");
        String headerPath = sHeaderDirectory != null ? sHeaderDirectory : targetFilePath;
        if (sAccessLevel == null) {
            sAccessLevel = "public";
        } else if (sAccessLevel.equals(PACKAGE_LEVEL)) {
            sAccessLevel = PACKAGE_ACCESS;
        }
        sJava7Flag = sTargetLanguage.language() == TargetLanguage.JAVA7;
        SmcOptions options = new SmcOptions(APP_NAME, VERSION, fsm.getSourceFileName(), targetFileBase, targetFilePath, headerPath, sHSuffix, sCastType, sGraphLevel, sSerial, sDebugLevel, sNoex, sNocatch, sNostreams, sCRTP, sStateStackSize, sReflection, sSync, sGeneric, sJava7Flag, sAccessLevel, sProtocol);
        if (sTargetLanguage.hasHeaderFile()) {
            headerGenerator = sTargetLanguage.headerGenerator(options);
            headerFileName = headerGenerator.setTargetFile(headerPath, targetFileBase, sHSuffix);
            headerFileStream = new FileOutputStream(headerFileName);
            PrintStream headerStream = new PrintStream(headerFileStream);
            headerGenerator.setTarget(headerStream);
        }
        SmcCodeGenerator generator = sTargetLanguage.generator(options);
        String srcFileName = generator.setTargetFile(targetFilePath, targetFileBase, sSuffix);
        FileOutputStream sourceFileStream = new FileOutputStream(srcFileName);
        PrintStream sourceStream = new PrintStream(sourceFileStream);
        generator.setTarget(sourceStream);
        if (headerGenerator != null && headerFileStream != null) {
            fsm.accept((SmcVisitor)headerGenerator);
            headerFileStream.flush();
            headerFileStream.close();
            if (sVerbose) {
                System.out.print("[wrote ");
                System.out.print(headerFileName);
                System.out.println("]");
            }
        }
        fsm.accept((SmcVisitor)generator);
        sourceFileStream.flush();
        sourceFileStream.close();
        if (sVerbose) {
            System.out.print("[wrote ");
            System.out.print(srcFileName);
            System.out.println("]");
        }
    }

    static {
        sLanguages = new Language[19];
        Smc.sLanguages[TargetLanguage.LANG_NOT_SET.ordinal()] = new Language(TargetLanguage.LANG_NOT_SET, "", null, null, null);
        Smc.sLanguages[TargetLanguage.C.ordinal()] = new Language(TargetLanguage.C, "-c", "C", SmcCGenerator.class, SmcHeaderCGenerator.class);
        Smc.sLanguages[TargetLanguage.C_PLUS_PLUS.ordinal()] = new Language(TargetLanguage.C_PLUS_PLUS, "-c++", "C++", SmcCppGenerator.class, SmcHeaderGenerator.class);
        Smc.sLanguages[TargetLanguage.C_SHARP.ordinal()] = new Language(TargetLanguage.C_SHARP, "-csharp", "C#", SmcCSharpGenerator.class, null);
        Smc.sLanguages[TargetLanguage.JAVA.ordinal()] = new Language(TargetLanguage.JAVA, "-java", "Java", SmcJavaGenerator.class, null);
        Smc.sLanguages[TargetLanguage.JAVA7.ordinal()] = new Language(TargetLanguage.JAVA7, "-java7", "Java7", SmcJava7Generator.class, null);
        Smc.sLanguages[TargetLanguage.GRAPH.ordinal()] = new Language(TargetLanguage.GRAPH, "-graph", "-graph", SmcGraphGenerator.class, null);
        Smc.sLanguages[TargetLanguage.GROOVY.ordinal()] = new Language(TargetLanguage.GROOVY, "-groovy", "Groovy", SmcGroovyGenerator.class, null);
        Smc.sLanguages[TargetLanguage.LUA.ordinal()] = new Language(TargetLanguage.LUA, "-lua", "Lua", SmcLuaGenerator.class, null);
        Smc.sLanguages[TargetLanguage.OBJECTIVE_C.ordinal()] = new Language(TargetLanguage.OBJECTIVE_C, "-objc", "Objective-C", SmcObjCGenerator.class, SmcHeaderObjCGenerator.class);
        Smc.sLanguages[TargetLanguage.PERL.ordinal()] = new Language(TargetLanguage.PERL, "-perl", "Perl", SmcPerlGenerator.class, null);
        Smc.sLanguages[TargetLanguage.PHP.ordinal()] = new Language(TargetLanguage.PERL, "-php", "PHP", SmcPhpGenerator.class, null);
        Smc.sLanguages[TargetLanguage.PYTHON.ordinal()] = new Language(TargetLanguage.PYTHON, "-python", "Python", SmcPythonGenerator.class, null);
        Smc.sLanguages[TargetLanguage.RUBY.ordinal()] = new Language(TargetLanguage.RUBY, "-ruby", "Ruby", SmcRubyGenerator.class, null);
        Smc.sLanguages[TargetLanguage.SCALA.ordinal()] = new Language(TargetLanguage.SCALA, "-scala", "Scala", SmcScalaGenerator.class, null);
        Smc.sLanguages[TargetLanguage.TABLE.ordinal()] = new Language(TargetLanguage.TABLE, "-table", "-table", SmcTableGenerator.class, null);
        Smc.sLanguages[TargetLanguage.TCL.ordinal()] = new Language(TargetLanguage.TCL, "-tcl", "[incr Tcl]", SmcTclGenerator.class, null);
        Smc.sLanguages[TargetLanguage.VB.ordinal()] = new Language(TargetLanguage.VB, "-vb", "VB.net", SmcVBGenerator.class, null);
        Smc.sLanguages[TargetLanguage.JS.ordinal()] = new Language(TargetLanguage.JS, "-js", "JavaScript", SmcJSGenerator.class, null);
        ArrayList<Language> languages = new ArrayList<Language>();
        sOptionMap = new HashMap<String, List<Language>>();
        for (TargetLanguage target : EnumSet.allOf(TargetLanguage.class)) {
            languages.add(sLanguages[target.ordinal()]);
        }
        sOptionMap.put(DIRECTORY_FLAG, languages);
        sOptionMap.put(DEBUG_FLAG, languages);
        sOptionMap.put(DEBUG_LEVEL0_FLAG, languages);
        sOptionMap.put(DEBUG_LEVEL1_FLAG, languages);
        sOptionMap.put(HELP_FLAG, languages);
        sOptionMap.put(NO_CATCH_FLAG, languages);
        sOptionMap.put(RETURN_FLAG, languages);
        sOptionMap.put(SUFFIX_FLAG, languages);
        sOptionMap.put(VERBOSE_FLAG, languages);
        sOptionMap.put(VERSION_FLAG, languages);
        sOptionMap.put(VVERBOSE_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_PLUS_PLUS.ordinal()]);
        sOptionMap.put(CAST_FLAG, languages);
        sOptionMap.put(NO_EXCEPTIONS_FLAG, languages);
        sOptionMap.put(NO_STREAMS_FLAG, languages);
        sOptionMap.put(CRTP_FLAG, languages);
        sOptionMap.put(STACK_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        sOptionMap.put(ACCESS_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_PLUS_PLUS.ordinal()]);
        languages.add(sLanguages[TargetLanguage.C.ordinal()]);
        languages.add(sLanguages[TargetLanguage.OBJECTIVE_C.ordinal()]);
        sOptionMap.put(HEADER_FLAG, languages);
        sOptionMap.put(HEADER_SUFFIX_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_SHARP.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        languages.add(sLanguages[TargetLanguage.VB.ordinal()]);
        languages.add(sLanguages[TargetLanguage.GROOVY.ordinal()]);
        languages.add(sLanguages[TargetLanguage.SCALA.ordinal()]);
        sOptionMap.put(SYNC_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_SHARP.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JS.ordinal()]);
        languages.add(sLanguages[TargetLanguage.VB.ordinal()]);
        languages.add(sLanguages[TargetLanguage.TCL.ordinal()]);
        languages.add(sLanguages[TargetLanguage.LUA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.PERL.ordinal()]);
        languages.add(sLanguages[TargetLanguage.PHP.ordinal()]);
        languages.add(sLanguages[TargetLanguage.PYTHON.ordinal()]);
        languages.add(sLanguages[TargetLanguage.RUBY.ordinal()]);
        languages.add(sLanguages[TargetLanguage.GROOVY.ordinal()]);
        languages.add(sLanguages[TargetLanguage.SCALA.ordinal()]);
        sOptionMap.put(REFLECT_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_SHARP.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        languages.add(sLanguages[TargetLanguage.VB.ordinal()]);
        languages.add(sLanguages[TargetLanguage.TCL.ordinal()]);
        languages.add(sLanguages[TargetLanguage.C_PLUS_PLUS.ordinal()]);
        languages.add(sLanguages[TargetLanguage.GROOVY.ordinal()]);
        languages.add(sLanguages[TargetLanguage.SCALA.ordinal()]);
        sOptionMap.put(SERIAL_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.GRAPH.ordinal()]);
        sOptionMap.put(GLEVEL_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.C_SHARP.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        languages.add(sLanguages[TargetLanguage.VB.ordinal()]);
        sOptionMap.put(GENERIC_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.JAVA.ordinal()]);
        languages.add(sLanguages[TargetLanguage.JAVA7.ordinal()]);
        sOptionMap.put(GENERIC7_FLAG, languages);
        languages = new ArrayList();
        languages.add(sLanguages[TargetLanguage.OBJECTIVE_C.ordinal()]);
        sOptionMap.put(USE_PROTOCOL_FLAG, languages);
        sAccessMap = new HashMap<Language, List<String>>();
        ArrayList<String> accessLevels = new ArrayList<String>();
        accessLevels.add("public");
        accessLevels.add("protected");
        accessLevels.add(PACKAGE_LEVEL);
        accessLevels.add("private");
        sAccessMap.put(sLanguages[TargetLanguage.JAVA.ordinal()], accessLevels);
        sAccessMap.put(sLanguages[TargetLanguage.JAVA7.ordinal()], accessLevels);
    }

    public static final class Language {
        private final TargetLanguage mLanguage;
        private final String mOptionFlag;
        private final String mName;
        private final Constructor mGenerator;
        private final Constructor mHeaderGenerator;

        public Language(TargetLanguage language, String optionFlag, String name, Class generator, Class headerGenerator) {
            Constructor sourceCtor = null;
            Constructor headerCtor = null;
            this.mLanguage = language;
            this.mOptionFlag = optionFlag;
            this.mName = name;
            if (generator != null) {
                try {
                    sourceCtor = generator.getDeclaredConstructor(SmcOptions.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (headerGenerator != null) {
                try {
                    headerCtor = headerGenerator.getDeclaredConstructor(SmcOptions.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            this.mGenerator = sourceCtor;
            this.mHeaderGenerator = headerCtor;
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = o == this;
            if (!retcode && o instanceof Language) {
                retcode = this.mLanguage == ((Language)o).mLanguage;
            }
            return retcode;
        }

        public int hashCode() {
            return this.mLanguage.ordinal();
        }

        public String toString() {
            return this.mName;
        }

        public TargetLanguage language() {
            return this.mLanguage;
        }

        public String optionFlag() {
            return this.mOptionFlag;
        }

        public String name() {
            return this.mName;
        }

        public SmcCodeGenerator generator(SmcOptions options) {
            SmcCodeGenerator retval = null;
            try {
                retval = (SmcCodeGenerator)this.mGenerator.newInstance(options);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException jex) {
                System.err.print(options.srcfileBase());
                System.err.print(".sm: failed to create ");
                System.err.print(this.mLanguage);
                System.err.println(" generator:");
                jex.printStackTrace(System.err);
            }
            return retval;
        }

        public boolean hasHeaderFile() {
            return this.mHeaderGenerator != null;
        }

        public SmcCodeGenerator headerGenerator(SmcOptions options) {
            SmcCodeGenerator retval = null;
            try {
                retval = (SmcCodeGenerator)this.mHeaderGenerator.newInstance(options);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
            return retval;
        }
    }
}

