/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import statemap.AbstractFSMContext;
import statemap.State;

public abstract class FSMContext
extends AbstractFSMContext
implements Serializable {
    private static final long serialVersionUID = 459520L;
    protected transient String mName;
    protected transient State mState;
    protected transient State mPreviousState;
    protected transient List<State> mStateStack;

    protected FSMContext(State initState) {
        this.mState = initState;
        this.mPreviousState = null;
        this.mStateStack = null;
    }

    @Override
    protected String previousStateName() {
        return this.mPreviousState == null ? "" : this.mPreviousState.getName();
    }

    public abstract void enterStartState();

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
    }

    public boolean isInTransition() {
        return this.mState == null;
    }

    public State getPreviousState() {
        return this.mPreviousState;
    }

    public void setState(State state) {
        if (this.getDebugFlag()) {
            this.getDebugStream().println("ENTER STATE     : " + state.getName());
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = state;
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void clearState() {
        this.mPreviousState = this.mState;
        this.mState = null;
    }

    public void pushState(State state) {
        if (this.mState == null) {
            throw new NullPointerException();
        }
        if (this.getDebugFlag()) {
            this.getDebugStream().println("PUSH TO STATE   : " + state.getName());
        }
        if (this.mStateStack == null) {
            this.mStateStack = new ArrayList<State>();
        }
        this.mPreviousState = this.mState;
        this.mStateStack.add(0, this.mState);
        this.mState = state;
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void popState() {
        if (this.mStateStack == null || this.mStateStack.isEmpty()) {
            if (this.getDebugFlag()) {
                this.getDebugStream().println("POPPING ON EMPTY STATE STACK.");
            }
            throw new EmptyStackException();
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = this.mStateStack.get(0);
        if (this.getDebugFlag()) {
            this.getDebugStream().println("POP TO STATE    : " + this.mState.getName());
        }
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void emptyStateStack() {
        if (this.mStateStack != null) {
            this.mStateStack.clear();
            this.mStateStack = null;
        }
    }
}

