/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcPythonGenerator
extends SmcCodeGenerator {
    public SmcPythonGenerator(SmcOptions options) {
        super(options, TargetLanguage.PYTHON.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("# ex: set ro:");
        this.mTarget.println("# DO NOT EDIT.");
        this.mTarget.println("# generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("# from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        this.mTarget.println("import statemap");
        this.mTarget.println();
        for (String imp : fsm.getImports()) {
            this.mTarget.print("import ");
            this.mTarget.println(imp);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State(statemap.State):");
        this.mTarget.println();
        this.mTarget.println("    def Entry(self, fsm):");
        this.mTarget.println("        pass");
        this.mTarget.println();
        this.mTarget.println("    def Exit(self, fsm):");
        this.mTarget.println("        pass");
        this.mTarget.println();
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            List<SmcParameter> params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print("    def ");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(self, fsm");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println("):");
            this.mTarget.println("        self.Default(fsm)");
            this.mTarget.println();
        }
        this.mTarget.println("    def Default(self, fsm):");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if fsm.getDebugFlag() == True:");
            this.mTarget.println("            fsm.getDebugStream().write('TRANSITION   : Default\\n')");
        }
        this.mTarget.println("        msg = \"\\n\\tState: %s\\n\\tTransition: %s\" % (");
        this.mTarget.println("            fsm.getState().getName(), fsm.getTransition())");
        this.mTarget.println("        raise statemap.TransitionUndefinedException(msg)");
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.println("    def getTransitions (self):");
            this.mTarget.println("        return self._transitions");
        }
        for (SmcMap map : maps) {
            map.accept(this);
        }
        int index = startState.indexOf("::");
        String pythonState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("_sm(statemap.FSMContext):");
        this.mTarget.println();
        this.mTarget.println("    def __init__(self, owner):");
        this.mTarget.print("        statemap.FSMContext.__init__(self, ");
        this.mTarget.print(pythonState);
        this.mTarget.println(")");
        this.mTarget.println("        self._owner = owner");
        this.mTarget.println();
        this.mTarget.println("    def __getattr__(self, attrib):");
        this.mTarget.println("        def trans_sm(*arglist):");
        this.mTarget.println("            self._transition = attrib");
        this.mTarget.println("            getattr(self.getState(), attrib)(self, *arglist)");
        this.mTarget.println("            self._transition = None");
        this.mTarget.println("        return trans_sm");
        this.mTarget.println();
        this.mTarget.println("    def enterStartState(self):");
        this.mTarget.println("        self._state.Entry(self)");
        this.mTarget.println();
        this.mTarget.println("    def getOwner(self):");
        this.mTarget.println("        return self._owner");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("    _States = (");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print("        ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    this.mTarget.println(",");
                }
            }
            this.mTarget.println("    )");
            this.mTarget.println("    def getStates(self):");
            this.mTarget.println("        return self._States");
            this.mTarget.println();
            this.mTarget.println("    _transitions = (");
            for (SmcTransition trans : transitions) {
                this.mTarget.print("        '");
                this.mTarget.print(trans.getName());
                this.mTarget.println("',");
            }
            this.mTarget.println("    )");
            this.mTarget.println("    def getTransitions(self):");
            this.mTarget.println("        return self._transitions");
            this.mTarget.println();
        }
        this.mTarget.println("# Local variables:");
        this.mTarget.println("#  buffer-read-only: t");
        this.mTarget.println("# End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        boolean needPass = true;
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(");
        this.mTarget.print(context);
        this.mTarget.println("State):");
        for (SmcTransition transition : definedDefaultTransitions) {
            needPass = false;
            transition.accept(this);
        }
        if (needPass && !this.mReflectFlag) {
            this.mTarget.println("    pass");
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.println("    _transitions = dict(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print("        ");
                this.mTarget.print(transName);
                this.mTarget.print(" = ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("    )");
        }
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println("(object):");
        this.mTarget.println();
        for (SmcState state : states) {
            this.mTarget.print("    ");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("('");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("', ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(")");
        }
        this.mTarget.print("    Default = ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default('");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default', -1)");
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        boolean needPass = true;
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print("(");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default):");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            needPass = false;
            this.mTarget.println();
            this.mTarget.println("    def Entry(self, fsm):");
            this.mTarget.println("        ctxt = fsm.getOwner()");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            needPass = false;
            this.mTarget.println();
            this.mTarget.println("    def Exit(self, fsm):");
            this.mTarget.println("        ctxt = fsm.getOwner()");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
        }
        for (SmcTransition transition : state.getTransitions()) {
            needPass = false;
            transition.accept(this);
        }
        if (needPass && !this.mReflectFlag) {
            this.mTarget.println("    pass");
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.println("    _transitions = dict(");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print("        ");
                this.mTarget.print(transName);
                this.mTarget.print(" = ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("    )");
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String instanceName = state.getInstanceName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print("    def ");
        this.mTarget.print(transName);
        this.mTarget.print("(self, fsm");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println("):");
        if (transition.hasCtxtReference()) {
            this.mTarget.println("        ctxt = fsm.getOwner()");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if fsm.getDebugFlag() == True:");
            this.mTarget.print("            fsm.getDebugStream().write(\"");
            this.mTarget.print("LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\")");
            this.mTarget.println();
        }
        this.mIndent = "        ";
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            this.mTarget.println("        else:");
            this.mTarget.print("            ");
            if (!instanceName.equals("DefaultState")) {
                this.mTarget.print(mapName);
                this.mTarget.print("_Default.");
            } else {
                this.mTarget.print(context);
                this.mTarget.print("State.");
            }
            this.mTarget.print(transName);
            this.mTarget.print("(self, fsm");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.print("        ");
        } else if (this.mGuardCount > 1) {
            this.mTarget.println();
        }
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        Object parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "    ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("if ");
                this.mTarget.print(condition);
                this.mTarget.println(" :");
            } else if (condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("elif ");
                this.mTarget.print(condition);
                this.mTarget.println(" :");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("else:");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent;
        } else {
            indent2 = this.mIndent + "    ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("if ");
            this.mTarget.print(condition);
            this.mTarget.println(" :");
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (!actions.isEmpty()) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = fsm.getState()");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.getDebugFlag() == True:");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.getDebugStream().write(");
                this.mTarget.print("\"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.getState().Exit(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.getDebugFlag() == True:");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.getDebugStream().write(");
                this.mTarget.print("\"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if fsm.getDebugFlag() == True:");
            this.mTarget.print(indent2);
            this.mTarget.print("    fsm.getDebugStream().write(\"");
            this.mTarget.print("ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\\n\")");
            this.mTarget.println();
        }
        if (actions.isEmpty()) {
            if (!condition.isEmpty() || this.mGuardCount > 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
                this.mTarget.print(indent2);
                this.mTarget.println("pass");
            } else if (this.mGuardCount == 1 && transType != SmcElement.TransType.TRANS_PUSH && transType != SmcElement.TransType.TRANS_POP && loopbackFlag && this.mDebugLevel == -1) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
                this.mTarget.print(indent2);
                this.mTarget.println("pass");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.clearState()");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try:");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("finally:");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent3);
            this.mTarget.println("if fsm.getDebugFlag() == True:");
            this.mTarget.print(indent3);
            this.mTarget.print("    fsm.getDebugStream().write(\"");
            this.mTarget.print("EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\\n\")");
            this.mTarget.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this.mTarget.print(indent3);
                this.mTarget.print("fsm.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(")");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if fsm.getDebugFlag() == True:");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    fsm.getDebugStream().write(\"");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\\n\")");
                    this.mTarget.println();
                }
                this.mTarget.print(indent3);
                this.mTarget.println("fsm.getState().Entry(fsm)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if fsm.getDebugFlag() == True:");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    fsm.getDebugStream().write(");
                    this.mTarget.print("\"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\\n\")");
                    this.mTarget.println();
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if fsm.getDebugFlag() == True:");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.getDebugStream().write(");
                this.mTarget.print("\"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\\n\")");
                this.mTarget.println();
            }
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.getState().Entry(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if fsm.getDebugFlag() == True:");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.getDebugStream().write(");
                this.mTarget.print("\"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\\n\")");
                this.mTarget.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("fsm.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println(")");
            } else {
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.println(arguments.get(0));
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("fsm.emptyStateStack()");
            } else {
                this.mTarget.print("ctxt.");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getName());
    }
}

