/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcJavaGenerator
extends SmcCodeGenerator {
    public SmcJavaGenerator(SmcOptions options) {
        super(options, TargetLanguage.JAVA.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String separator;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        List<SmcTransition> transitions = fsm.getTransitions();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.print("package ");
            this.mTarget.print(packageName);
            this.mTarget.println(";");
            this.mTarget.println();
        }
        for (String string : fsm.getImports()) {
            this.mTarget.print("import ");
            this.mTarget.print(string);
            this.mTarget.println(";");
        }
        if (this.mReflectFlag) {
            this.mTarget.println("import java.util.HashMap;");
            this.mTarget.println("import java.util.Map;");
            this.mTarget.println("import java.util.Set;");
            this.mTarget.println("import java.util.TreeSet;");
        }
        this.mTarget.println();
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("");
        this.mTarget.println("    extends statemap.FSMContext");
        if (this.mSerialFlag) {
            this.mTarget.println("    implements java.io.Serializable");
        }
        this.mTarget.println("{");
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.println("// Member methods.");
        this.mTarget.println("//");
        this.mTarget.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(");
        this.mTarget.print(context);
        this.mTarget.println(" owner)");
        this.mTarget.println("    {");
        this.mTarget.print("        this (owner, ");
        this.mTarget.print(javaState);
        this.mTarget.println(");");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(");
        this.mTarget.print(context);
        this.mTarget.print(" owner, ");
        this.mTarget.print(context);
        this.mTarget.println("State initState)");
        this.mTarget.println("    {");
        this.mTarget.println("        super (initState);");
        this.mTarget.println();
        this.mTarget.println("        mOwner = owner;");
        if (this.mReflectFlag) {
            this.reflectionSets(transitions);
        }
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    @Override");
        this.mTarget.print("    public ");
        if (this.mSyncFlag) {
            this.mTarget.print("synchronized ");
        }
        this.mTarget.println("void enterStartState()");
        this.mTarget.println("    {");
        this.mTarget.println("        getState().entry(this);");
        this.mTarget.println("    }");
        this.mTarget.println();
        for (SmcTransition smcTransition : transitions) {
            if (smcTransition.getName().equals("Default")) continue;
            this.mTarget.print("    public ");
            if (this.mSyncFlag) {
                this.mTarget.print("synchronized ");
            }
            this.mTarget.print("void ");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(");
            List<SmcParameter> params = smcTransition.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(")");
            this.mTarget.println("    {");
            this.mTarget.print("        mTransition = \"");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.println("\";");
            this.mTarget.print("        getState().");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(", ");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("        mTransition = \"\";");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (this.mSerialFlag) {
            this.mTarget.print("    public ");
            this.mTarget.print(context);
            this.mTarget.println("State valueOf(int stateId)");
            this.mTarget.println("        throws ArrayIndexOutOfBoundsException");
            this.mTarget.println("    {");
            this.mTarget.println("        return (sStates[stateId]);");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.print("    public ");
        this.mTarget.print(context);
        this.mTarget.println("State getState()");
        this.mTarget.println("        throws statemap.StateUndefinedException");
        this.mTarget.println("    {");
        this.mTarget.println("        if (mState == null)");
        this.mTarget.println("        {");
        this.mTarget.println("            throw(");
        this.mTarget.println("                new statemap.StateUndefinedException());");
        this.mTarget.println("        }");
        this.mTarget.println();
        this.mTarget.print("        return ((");
        this.mTarget.print(context);
        this.mTarget.println("State) mState);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    protected ");
        this.mTarget.print(context);
        this.mTarget.println(" getOwner()");
        this.mTarget.println("    {");
        this.mTarget.println("        return (mOwner);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    public void setOwner(");
        this.mTarget.print(context);
        this.mTarget.println(" owner)");
        this.mTarget.println("    {");
        this.mTarget.println("        if (owner == null)");
        this.mTarget.println("        {");
        this.mTarget.println("            throw (");
        this.mTarget.println("                new NullPointerException(");
        this.mTarget.println("                    \"null owner\"));");
        this.mTarget.println("        }");
        this.mTarget.println("        else");
        this.mTarget.println("        {");
        this.mTarget.println("            mOwner = owner;");
        this.mTarget.println("        }");
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print("    public static ");
            this.mTarget.print(context);
            this.mTarget.println("State[] getStates()");
            this.mTarget.println("    {");
            this.mTarget.println("        return (sStates);");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.print("    public Set");
            if (this.mGenericFlag) {
                this.mTarget.print("<String>");
            }
            this.mTarget.println(" getTransitions()");
            this.mTarget.println("    {");
            this.mTarget.println("        return (mTransitions);");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (this.mSerialFlag) {
            this.mTarget.print("    private void writeObject(");
            this.mTarget.println("java.io.ObjectOutputStream ostream)");
            this.mTarget.println("        throws java.io.IOException");
            this.mTarget.println("    {");
            this.mTarget.println("        int size =");
            this.mTarget.print("            ");
            this.mTarget.println("(mStateStack == null ? 0 : mStateStack.size());");
            this.mTarget.println("        int i;");
            this.mTarget.println();
            this.mTarget.println("        ostream.writeInt(size);");
            this.mTarget.println();
            this.mTarget.println("        for (i = 0; i < size; ++i)");
            this.mTarget.println("        {");
            this.mTarget.println("            ostream.writeInt(");
            this.mTarget.print("                ((");
            this.mTarget.print(context);
            this.mTarget.println("State) mStateStack.get(i)).getId());");
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.println("        ostream.writeInt(mState.getId());");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.print("    private void readObject(");
            this.mTarget.println("java.io.ObjectInputStream istream)");
            this.mTarget.println("        throws java.io.IOException");
            this.mTarget.println("    {");
            this.mTarget.println("        int size;");
            this.mTarget.println();
            this.mTarget.println("        size = istream.readInt();");
            this.mTarget.println();
            this.mTarget.println("        if (size == 0)");
            this.mTarget.println("        {");
            this.mTarget.println("            mStateStack = null;");
            this.mTarget.println("        }");
            this.mTarget.println("        else");
            this.mTarget.println("        {");
            this.mTarget.println("            int i;");
            this.mTarget.println();
            this.mTarget.println("            mStateStack =");
            this.mTarget.print("                new java.util.ArrayList");
            if (this.mJava7Flag) {
                this.mTarget.print("<>");
            } else {
                this.mTarget.print("<statemap.State>");
            }
            this.mTarget.println("();");
            this.mTarget.println();
            this.mTarget.println("            for (i = 0; i < size; ++i)");
            this.mTarget.println("            {");
            this.mTarget.print("                mStateStack.add(i, sStates[");
            this.mTarget.println("istream.readInt()]);");
            this.mTarget.println("            }");
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.println("        mState = sStates[istream.readInt()];");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.println("// Member data.");
        this.mTarget.println("//");
        this.mTarget.println();
        this.mTarget.print("    private transient ");
        this.mTarget.print(context);
        this.mTarget.println(" mOwner;");
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print("    private final Set");
            if (this.mGenericFlag) {
                this.mTarget.print("<String>");
            }
            this.mTarget.println(" mTransitions;");
        }
        if (this.mSerialFlag || this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.println("    // Statics.");
            this.mTarget.println("    //");
            this.mTarget.println();
            this.mTarget.print("    private static transient ");
            this.mTarget.print(context);
            this.mTarget.println("State[] sStates =");
            this.mTarget.println("    {");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print(separator);
                    this.mTarget.print("        ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    separator = ",\n";
                }
            }
            this.mTarget.println();
            this.mTarget.println("    };");
        }
        this.mTarget.println();
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Constants.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("    private static final long serialVersionUID = 1L;");
        this.mTarget.println();
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.println("// Inner classes.");
        this.mTarget.println("//");
        this.mTarget.println();
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" static abstract class ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.println("        extends statemap.State");
        this.mTarget.println("    {");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print("        public abstract Map");
            if (this.mGenericFlag) {
                this.mTarget.print("<String, Integer>");
            }
            this.mTarget.println(" getTransitions();");
            this.mTarget.println();
        }
        this.mTarget.print("        protected ");
        this.mTarget.print(context);
        this.mTarget.println("State(String name, int id)");
        this.mTarget.println("        {");
        this.mTarget.println("            super (name, id);");
        this.mTarget.println("        }");
        this.mTarget.println();
        this.mTarget.print("        protected void entry(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context) {}");
        this.mTarget.print("        protected void exit(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context) {}");
        this.mTarget.println();
        for (SmcTransition smcTransition : transitions) {
            String transName = smcTransition.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print("        protected void ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" context");
            for (SmcParameter param : smcTransition.getParameters()) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.println("        {");
            this.mTarget.println("            Default(context);");
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print("        protected void Default(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context)");
        this.mTarget.println("        {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("            context.debugOutput(\"TRANSITION   : Default\");");
            this.mTarget.println();
        }
        this.mTarget.println("            throw (");
        this.mTarget.println("                new statemap.TransitionUndefinedException(");
        this.mTarget.println("                    \"State: \" +");
        this.mTarget.println("                    context.getState().getName() +");
        this.mTarget.println("                    \", Transition: \" +");
        this.mTarget.println("                    context.getTransition()));");
        this.mTarget.println("        }");
        this.mTarget.println();
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member data.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("        //-------------------------------------------------------");
        this.mTarget.println("    // Constants.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("        private static final long serialVersionUID = 1L;");
        this.mTarget.println("    }");
        for (SmcMap smcMap : maps) {
            smcMap.accept(this);
        }
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print("    /* package */ static abstract class ");
        this.mTarget.println(mapName);
        this.mTarget.println("    {");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member data.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("        //-------------------------------------------------------");
        this.mTarget.println("        // Constants.");
        this.mTarget.println("        //");
        this.mTarget.println();
        for (SmcState state : states) {
            this.mTarget.print("        public static final ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print(' ');
            this.mTarget.print(state.getInstanceName());
            this.mTarget.println(" =");
            this.mTarget.print("            new ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("(\"");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("\", ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(");");
        }
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    protected static class ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.print("        extends ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.println("    {");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("        @Override");
            this.mTarget.print("        public Map");
            if (this.mGenericFlag) {
                this.mTarget.print("<String, Integer>");
            }
            this.mTarget.println(" getTransitions()");
            this.mTarget.println("        {");
            this.mTarget.println("            return (sTransitions);");
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print("        protected ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default(String name, int id)");
        this.mTarget.println("        {");
        this.mTarget.println("            super (name, id);");
        this.mTarget.println("        }");
        this.mIndent = "        ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept(this);
        }
        this.mTarget.println();
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Member data.");
        this.mTarget.println("    //");
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.println("        //---------------------------------------------------");
            this.mTarget.println("        // Statics.");
            this.mTarget.println("        //");
            this.mTarget.println();
            this.mTarget.print("        private static Map");
            if (this.mGenericFlag) {
                this.mTarget.print("<String, Integer>");
            }
            this.mTarget.println(" sTransitions;");
            this.mTarget.println();
            this.mTarget.println("        static");
            this.mTarget.println("        {");
            this.mTarget.print("            ");
            this.mTarget.print("sTransitions = new HashMap");
            if (this.mGenericFlag) {
                if (this.mJava7Flag) {
                    this.mTarget.print("<>");
                } else {
                    this.mTarget.print("<String, Integer>");
                }
            }
            this.mTarget.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = definedDefaultTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_DEFAULT" : "statemap.State.TRANSITION_UNDEFINED";
                this.mTarget.print("            ");
                this.mTarget.print("sTransitions.put(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(");");
            }
            this.mTarget.println("        }");
        }
        this.mTarget.println();
        this.mTarget.println("        //---------------------------------------------------");
        this.mTarget.println("        // Constants.");
        this.mTarget.println("        //");
        this.mTarget.println();
        this.mTarget.println("        private static final long serialVersionUID = 1L;");
        this.mTarget.println("    }");
        for (SmcState state : states) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print("    private static final class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.println(stateName);
        this.mTarget.print("        extends ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.println("    {");
        this.mTarget.println("    //-------------------------------------------------------");
        this.mTarget.println("    // Member methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("        @Override");
            this.mTarget.print("        public Map");
            if (this.mGenericFlag) {
                this.mTarget.print("<String, Integer>");
            }
            this.mTarget.println(" getTransitions()");
            this.mTarget.println("        {");
            this.mTarget.print("            ");
            this.mTarget.println("return (sTransitions);");
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print("        private ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.println("(String name, int id)");
        this.mTarget.println("        {");
        this.mTarget.println("            super (name, id);");
        this.mTarget.println("        }");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("        @Override");
            this.mTarget.print("        protected void entry(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" context)");
            this.mTarget.println("            {");
            this.mTarget.print("                ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.getOwner();");
            this.mTarget.println();
            String indent2 = this.mIndent;
            this.mIndent = "            ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("        }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("        @Override");
            this.mTarget.print("        protected void exit(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" context)");
            this.mTarget.println("            {");
            this.mTarget.print("            ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.getOwner();");
            this.mTarget.println();
            this.mIndent = "            ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("        }");
        }
        this.mIndent = "        ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        this.mTarget.println();
        this.mTarget.println("    //-------------------------------------------------------");
        this.mTarget.println("    // Member data.");
        this.mTarget.println("    //");
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.println("        //---------------------------------------------------");
            this.mTarget.println("        // Statics.");
            this.mTarget.println("        //");
            this.mTarget.println();
            this.mTarget.print("        private static Map");
            if (this.mGenericFlag) {
                this.mTarget.print("<String, Integer>");
            }
            this.mTarget.println(" sTransitions;");
            this.mTarget.println();
            this.mTarget.println("        static");
            this.mTarget.println("        {");
            this.mTarget.print("            ");
            this.mTarget.print("sTransitions = new HashMap");
            if (this.mGenericFlag) {
                if (this.mJava7Flag) {
                    this.mTarget.print("<>");
                } else {
                    this.mTarget.print("<String, Integer>");
                }
            }
            this.mTarget.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = stateTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_LOCALLY" : (defaultTransitions.contains(transition) ? "statemap.State.TRANSITION_DEFINED_DEFAULT" : "statemap.State.TRANSITION_UNDEFINED");
                this.mTarget.print("            ");
                this.mTarget.print("sTransitions.put(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(");");
            }
            this.mTarget.println("        }");
        }
        this.mTarget.println();
        this.mTarget.println("        //---------------------------------------------------");
        this.mTarget.println("        // Constants.");
        this.mTarget.println("        //");
        this.mTarget.println();
        this.mTarget.println("        private static final long serialVersionUID = 1L;");
        this.mTarget.println("    }");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        SmcGuard nullGuard = null;
        Iterator<SmcGuard> git = guards.iterator();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@Override");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("protected void ");
        this.mTarget.print(transName);
        this.mTarget.print("(");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" context");
        for (SmcParameter parameter : parameters) {
            this.mTarget.print(", ");
            parameter.accept(this);
        }
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.getOwner();");
        }
        this.mTarget.println();
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    context.debugOutput(\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("\");");
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        super.");
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        String indent4;
        Object parameters;
        String fqEndStateName;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
        }
        if (!hasActions || !loopbackFlag) {
            fqEndStateName = endStateName;
        } else {
            fqEndStateName = "endState";
            this.mTarget.print(indent2);
            this.mTarget.print(context);
            this.mTarget.print("State ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(" = context.getState();");
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.print("context.debugOutput(\"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".exit(context)\");");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("(context.getState()).exit(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.print("context.debugOutput(\"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".exit(context)\");");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this.mIndent;
            if (!this.mNoCatchFlag) {
                this.mIndent = indent2;
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("context.debugOutput(\"ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\");");
            this.mTarget.println();
            this.mIndent = indent4;
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("context.clearState();");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try");
                this.mTarget.print(indent2);
                this.mTarget.println('{');
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println('}');
                this.mTarget.print(indent2);
                this.mTarget.println("finally");
                this.mTarget.print(indent2);
                this.mTarget.println('{');
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this.mIndent;
            this.mIndent = indent3;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("context.debugOutput(\"EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\");");
            this.mTarget.println();
            this.mIndent = indent4;
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("context.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (!loopbackFlag) {
                this.mTarget.print(indent3);
                this.mTarget.println("(context.getState()).entry(context);");
            }
            this.mTarget.print(indent3);
            this.mTarget.print("context.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("context.popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.print("context.debugOutput(\"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".entry(context)\");");
                this.mTarget.println();
            }
            this.mTarget.print(indent3);
            this.mTarget.println("(context.getState()).entry(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.print("context.debugOutput(\"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".entry(context)\");");
            }
        }
        if (hasActions && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println('}');
            this.mTarget.println();
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("context.emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("ctxt.");
            }
            this.mTarget.print(name);
            this.mTarget.print("(");
            Iterator<String> it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(it.next());
                sep = ", ";
            }
            this.mTarget.println(");");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(' ');
        this.mTarget.print(parameter.getName());
    }

    private void reflectionSets(List<SmcTransition> transitions) {
        this.mTarget.print("        mTransitions = new TreeSet");
        if (this.mGenericFlag) {
            if (this.mJava7Flag) {
                this.mTarget.print("<>");
            } else {
                this.mTarget.print("<String>");
            }
        }
        this.mTarget.println("();");
        this.mTarget.println();
        for (SmcTransition trans : transitions) {
            this.mTarget.print("        mTransitions.add(\"");
            this.mTarget.print(trans.getName());
            this.mTarget.println("\");");
        }
    }
}

