/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcGraphGenerator
extends SmcCodeGenerator {
    private final String mIndentAction;
    private SmcState mState;

    public SmcGraphGenerator(SmcOptions options) {
        super(options, TargetLanguage.GRAPH.suffix());
        this.mIndentAction = "&nbsp;&nbsp;&nbsp;";
    }

    @Override
    public void visit(SmcFSM fsm) {
        this.mTarget.print("digraph \"");
        this.mTarget.print(this.mSrcfileBase.replace('.', '_'));
        this.mTarget.println("\" {");
        this.mTarget.println();
        this.mTarget.println("    node");
        this.mTarget.println("        [shape=Mrecord width=1.5];");
        this.mTarget.println();
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this.mTarget.print("    subgraph cluster_");
            this.mTarget.print(mapName);
            this.mTarget.println(" {");
            this.mTarget.println();
            this.mTarget.print("        label=\"");
            this.mTarget.print(mapName);
            this.mTarget.println("\";");
            this.mTarget.println();
            map.accept(this);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("}");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(SmcMap map) {
        Object transName;
        String pushStateName;
        String mapName = map.getName();
        SmcState defaultState = map.getDefaultState();
        String startStateName = map.getFSM().getStartState();
        HashMap<String, String> pushEntryMap = new HashMap<String, String>();
        HashMap<String, String> popTransMap = new HashMap<String, String>();
        HashMap<String, String> pushStateMap = new HashMap<String, String>();
        boolean needEnd = false;
        String startMapName = startStateName.substring(0, startStateName.indexOf(":"));
        this.mTarget.println("        //");
        this.mTarget.println("        // States (Nodes)");
        this.mTarget.println("        //");
        this.mTarget.println();
        for (SmcState state : map.getStates()) {
            state.accept(this);
        }
        for (SmcState state : map.getStates()) {
            for (SmcTransition transition : state.getTransitions()) {
                for (SmcGuard smcGuard : transition.getGuards()) {
                    String popArgs;
                    String string = smcGuard.getEndState();
                    SmcElement.TransType transType = smcGuard.getTransType();
                    if (transType == SmcElement.TransType.TRANS_PUSH) {
                        void var16_25;
                        int index;
                        pushStateName = smcGuard.getPushState();
                        if (string.equals("nil")) {
                            String string2 = state.getInstanceName();
                        }
                        String pushMapName = (index = pushStateName.indexOf("::")) >= 0 ? pushStateName.substring(0, index) : mapName;
                        pushStateMap.put(mapName + "::" + (String)var16_25 + "::" + pushMapName, pushMapName);
                        continue;
                    }
                    if (transType != SmcElement.TransType.TRANS_POP) continue;
                    String popKey = string;
                    String popVal = string;
                    if (this.mGraphLevel == 2 && (popArgs = smcGuard.getPopArgs()) != null && popArgs.length() > 0) {
                        popKey = popKey + ", ";
                        popVal = popVal + ", ";
                        popKey = popKey + SmcGraphGenerator.doEscape(SmcGraphGenerator.normalize(popArgs));
                        popVal = popVal + SmcGraphGenerator.doEscape(popArgs).replaceAll("\\n", "\\\\\\l");
                    }
                    popTransMap.put(popKey, popVal);
                    needEnd = true;
                }
            }
            if (defaultState == null) continue;
            for (SmcTransition transition : defaultState.getTransitions()) {
                transName = transition.getName();
                if (!state.callDefault((String)transName)) continue;
                for (SmcGuard smcGuard : transition.getGuards()) {
                    String popArgs;
                    if (state.findGuard((String)transName, smcGuard.getCondition()) != null) continue;
                    String endStateName = smcGuard.getEndState();
                    SmcElement.TransType transType = smcGuard.getTransType();
                    if (transType == SmcElement.TransType.TRANS_PUSH) {
                        int index;
                        String pushStateName2 = smcGuard.getPushState();
                        if (endStateName.equals("nil")) {
                            endStateName = state.getInstanceName();
                        }
                        String pushMapName = (index = pushStateName2.indexOf("::")) >= 0 ? pushStateName2.substring(0, index) : mapName;
                        pushStateMap.put(mapName + "::" + endStateName + "::" + pushMapName, pushMapName);
                        continue;
                    }
                    if (transType != SmcElement.TransType.TRANS_POP) continue;
                    String popKey = endStateName;
                    String popVal = endStateName;
                    if (this.mGraphLevel == 2 && (popArgs = smcGuard.getPopArgs()) != null && popArgs.length() > 0) {
                        popKey = popKey + ", ";
                        popVal = popVal + ", ";
                        popKey = popKey + SmcGraphGenerator.doEscape(SmcGraphGenerator.normalize(popArgs));
                        popVal = popVal + SmcGraphGenerator.doEscape(popArgs).replaceAll("\\n", "\\\\\\l");
                    }
                    popTransMap.put(popKey, popVal);
                    needEnd = true;
                }
            }
        }
        for (String pname : popTransMap.keySet()) {
            this.mTarget.print("        \"");
            this.mTarget.print(mapName);
            this.mTarget.print("::pop(");
            this.mTarget.print(pname);
            this.mTarget.println(")\"");
            this.mTarget.println("            [label=\"\" width=1]");
            this.mTarget.println();
        }
        if (needEnd) {
            this.mTarget.print("        \"");
            this.mTarget.print(mapName);
            this.mTarget.println("::%end\"");
            this.mTarget.println("            [label=\"\" shape=doublecircle style=filled fillcolor=black width=0.15];");
            this.mTarget.println();
        }
        for (String pname : pushStateMap.keySet()) {
            this.mTarget.print("        \"");
            this.mTarget.print(pname);
            this.mTarget.println("\"");
            this.mTarget.print("            [label=\"{");
            this.mTarget.print((String)pushStateMap.get(pname));
            this.mTarget.println("|O-O\\r}\"]");
            this.mTarget.println();
        }
        if (startMapName.equals(mapName)) {
            this.mTarget.println("        \"%start\"");
            this.mTarget.println("            [label=\"\" shape=circle style=filled fillcolor=black width=0.25];");
            this.mTarget.println();
        }
        for (SmcMap map2 : map.getFSM().getMaps()) {
            for (SmcState state : map2.getAllStates()) {
                for (SmcTransition smcTransition : state.getTransitions()) {
                    for (SmcGuard guard : smcTransition.getGuards()) {
                        if (guard.getTransType() != SmcElement.TransType.TRANS_PUSH || (pushStateName = guard.getPushState()).indexOf(mapName) != 0) continue;
                        pushEntryMap.put(pushStateName, "");
                    }
                }
            }
        }
        for (String pname : pushEntryMap.keySet()) {
            this.mTarget.print("        \"push(");
            this.mTarget.print(pname);
            this.mTarget.println(")\"");
            this.mTarget.println("            [label=\"\" shape=plaintext];");
            this.mTarget.println();
        }
        this.mTarget.println("        //");
        this.mTarget.println("        // Transitions (Edges)");
        this.mTarget.println("        //");
        Iterator<SmcElement> iterator = map.getStates().iterator();
        while (iterator.hasNext()) {
            SmcState state;
            this.mState = state = (SmcState)iterator.next();
            for (SmcTransition transition : state.getTransitions()) {
                transition.accept(this);
            }
            if (defaultState == null) continue;
            for (SmcTransition transition : defaultState.getTransitions()) {
                transName = transition.getName();
                if (!state.callDefault((String)transName)) continue;
                for (SmcGuard smcGuard : transition.getGuards()) {
                    if (state.findGuard((String)transName, smcGuard.getCondition()) != null) continue;
                    smcGuard.accept(this);
                }
            }
        }
        for (String pname : popTransMap.keySet()) {
            this.mTarget.println();
            this.mTarget.print("        \"");
            this.mTarget.print(mapName);
            this.mTarget.print("::pop(");
            this.mTarget.print(pname);
            this.mTarget.print(")\" -> \"");
            this.mTarget.print(mapName);
            this.mTarget.println("::%end\"");
            this.mTarget.print("            [label=\"pop(");
            this.mTarget.print((String)popTransMap.get(pname));
            this.mTarget.println(");\\l\"];");
        }
        for (String pname : pushStateMap.keySet()) {
            this.mTarget.println();
            this.mTarget.print("        \"");
            this.mTarget.print(pname);
            this.mTarget.print("\" -> \"");
            this.mTarget.print(pname.substring(0, pname.lastIndexOf("::")));
            this.mTarget.println("\"");
            this.mTarget.println("            [label=\"pop/\"]");
        }
        if (startMapName.equals(mapName)) {
            this.mTarget.println();
            this.mTarget.print("        \"%start\" -> \"");
            this.mTarget.print(startStateName);
            this.mTarget.println("\"");
        }
        for (String pname : pushEntryMap.keySet()) {
            this.mTarget.println();
            this.mTarget.print("        \"push(");
            this.mTarget.print(pname);
            this.mTarget.print(")\" -> \"");
            this.mTarget.print(pname);
            this.mTarget.println("\"");
            this.mTarget.println("            [arrowtail=odot];");
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        SmcState defaultState = map.getDefaultState();
        String mapName = map.getName();
        String instanceName = state.getInstanceName();
        this.mTarget.print("        \"");
        this.mTarget.print(mapName);
        this.mTarget.print("::");
        this.mTarget.print(instanceName);
        this.mTarget.println("\"");
        this.mTarget.print("            [label=\"{");
        this.mTarget.print(instanceName);
        if (this.mGraphLevel >= 1) {
            Object tmp;
            String sep;
            Iterator<SmcParameter> pit;
            List<SmcParameter> parameters;
            String pushStateName;
            String condition;
            boolean empty = true;
            List<SmcAction> actions = state.getEntryActions();
            if (actions == null && defaultState != null) {
                actions = defaultState.getEntryActions();
            }
            if (actions != null) {
                if (empty) {
                    this.mTarget.print("|");
                    empty = false;
                }
                this.mTarget.print("Entry/\\l");
                for (SmcAction action : actions) {
                    this.mTarget.print(this.mIndentAction);
                    action.accept(this);
                }
            }
            if ((actions = state.getExitActions()) == null && defaultState != null) {
                actions = defaultState.getExitActions();
            }
            if (actions != null) {
                if (empty) {
                    this.mTarget.print("|");
                }
                this.mTarget.print("Exit/\\l");
                for (SmcAction action : actions) {
                    this.mTarget.print(this.mIndentAction);
                    action.accept(this);
                }
            }
            empty = true;
            for (SmcTransition transition : state.getTransitions()) {
                for (SmcGuard guard : transition.getGuards()) {
                    String endStateName = guard.getEndState();
                    SmcElement.TransType transType = guard.getTransType();
                    if (!this.isLoopback(transType, endStateName) || transType == SmcElement.TransType.TRANS_PUSH) continue;
                    String transName = transition.getName();
                    condition = guard.getCondition();
                    pushStateName = guard.getPushState();
                    actions = guard.getActions();
                    if (empty) {
                        this.mTarget.print("|");
                        empty = false;
                    }
                    this.mTarget.print(transName);
                    if (this.mGraphLevel == 2) {
                        parameters = transition.getParameters();
                        this.mTarget.print("(");
                        pit = parameters.iterator();
                        sep = "";
                        while (pit.hasNext()) {
                            this.mTarget.print(sep);
                            pit.next().accept(this);
                            sep = ", ";
                        }
                        this.mTarget.print(")");
                    }
                    if (condition != null && condition.length() > 0) {
                        tmp = SmcGraphGenerator.doEscape(condition);
                        tmp = ((String)tmp).replaceAll("\\n", "\\\\\\l");
                        tmp = ((String)tmp).replaceAll(">", "\\\\>");
                        tmp = ((String)tmp).replaceAll("<", "\\\\<");
                        tmp = ((String)tmp).replaceAll("\\|", "\\\\|");
                        this.mTarget.print("\\l\\[");
                        this.mTarget.print((String)tmp);
                        this.mTarget.print("\\]");
                    }
                    this.mTarget.print("/\\l");
                    if (actions != null) {
                        for (SmcAction action : actions) {
                            this.mTarget.print(this.mIndentAction);
                            action.accept(this);
                        }
                    }
                    if (transType != SmcElement.TransType.TRANS_PUSH) continue;
                    this.mTarget.print(this.mIndentAction);
                    this.mTarget.print("push(");
                    this.mTarget.print(pushStateName);
                    this.mTarget.print(")\\l");
                }
            }
            if (defaultState != null) {
                for (SmcTransition transition : defaultState.getTransitions()) {
                    String transName = transition.getName();
                    if (!state.callDefault(transName)) continue;
                    for (SmcGuard guard : transition.getGuards()) {
                        if (state.findGuard(transName, guard.getCondition()) != null) continue;
                        String endStateName = guard.getEndState();
                        SmcElement.TransType transType = guard.getTransType();
                        if (!this.isLoopback(transType, endStateName) || transType == SmcElement.TransType.TRANS_PUSH) continue;
                        transName = transition.getName();
                        condition = guard.getCondition();
                        pushStateName = guard.getPushState();
                        actions = guard.getActions();
                        if (empty) {
                            this.mTarget.print("|");
                            empty = false;
                        }
                        this.mTarget.print(transName);
                        if (this.mGraphLevel == 2) {
                            parameters = transition.getParameters();
                            this.mTarget.print("(");
                            pit = parameters.iterator();
                            sep = "";
                            while (pit.hasNext()) {
                                this.mTarget.print(sep);
                                pit.next().accept(this);
                                sep = ", ";
                            }
                            this.mTarget.print(")");
                        }
                        if (condition != null && condition.length() > 0) {
                            tmp = SmcGraphGenerator.doEscape(condition);
                            tmp = ((String)tmp).replaceAll("\\n", "\\\\\\l");
                            tmp = ((String)tmp).replaceAll(">", "\\\\>");
                            tmp = ((String)tmp).replaceAll("<", "\\\\<");
                            tmp = ((String)tmp).replaceAll("\\|", "\\\\|");
                            this.mTarget.print("\\l\\[");
                            this.mTarget.print((String)tmp);
                            this.mTarget.print("\\]");
                        }
                        this.mTarget.print("/\\l");
                        if (actions != null) {
                            for (SmcAction action : actions) {
                                this.mTarget.print(this.mIndentAction);
                                action.accept(this);
                            }
                        }
                        if (transType != SmcElement.TransType.TRANS_PUSH) continue;
                        this.mTarget.print(this.mIndentAction);
                        this.mTarget.print("push(");
                        this.mTarget.print(pushStateName);
                        this.mTarget.print(")\\l");
                    }
                }
            }
        }
        this.mTarget.println("}\"];");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcTransition transition) {
        for (SmcGuard guard : transition.getGuards()) {
            guard.accept(this);
        }
    }

    @Override
    public void visit(SmcGuard guard) {
        SmcTransition transition = guard.getTransition();
        SmcMap map = this.mState.getMap();
        String mapName = map.getName();
        String stateName = this.mState.getInstanceName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (this.isLoopback(transType, endStateName) && transType != SmcElement.TransType.TRANS_PUSH) {
            return;
        }
        this.mTarget.println();
        this.mTarget.print("        \"");
        this.mTarget.print(mapName);
        this.mTarget.print("::");
        this.mTarget.print(stateName);
        this.mTarget.print("\" -> ");
        if (transType != SmcElement.TransType.TRANS_POP) {
            if (endStateName.equals("nil")) {
                endStateName = stateName;
            }
            if (!endStateName.contains("::")) {
                endStateName = mapName + "::" + endStateName;
            }
            this.mTarget.print("\"");
            this.mTarget.print(endStateName);
            if (transType == SmcElement.TransType.TRANS_PUSH) {
                int index = pushStateName.indexOf("::");
                this.mTarget.print("::");
                if (index < 0) {
                    this.mTarget.print(mapName);
                } else {
                    this.mTarget.print(pushStateName.substring(0, pushStateName.indexOf("::")));
                }
            }
            this.mTarget.println("\"");
        } else {
            String popArgs = guard.getPopArgs();
            this.mTarget.print("\"");
            this.mTarget.print(mapName);
            this.mTarget.print("::pop(");
            this.mTarget.print(endStateName);
            if (this.mGraphLevel == 2 && popArgs != null && popArgs.length() > 0) {
                this.mTarget.print(", ");
                this.mTarget.print(SmcGraphGenerator.doEscape(SmcGraphGenerator.normalize(popArgs)));
            }
            this.mTarget.println(")\"");
        }
        this.mTarget.print("            [label=\"");
        this.mTarget.print(transName);
        if (this.mGraphLevel == 2) {
            List<SmcParameter> parameters = transition.getParameters();
            this.mTarget.print("(");
            Iterator<SmcParameter> pit = parameters.iterator();
            String sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.print(")");
        }
        if (this.mGraphLevel > 0 && condition != null && condition.length() > 0) {
            this.mTarget.print("\\l\\[");
            this.mTarget.print(SmcGraphGenerator.doEscape(condition).replaceAll("\\n", "\\\\\\l"));
            this.mTarget.print("\\]");
        }
        this.mTarget.print("/\\l");
        if (this.mGraphLevel > 0 && actions != null) {
            for (SmcAction action : actions) {
                action.accept(this);
            }
        }
        if (transType == SmcElement.TransType.TRANS_PUSH) {
            this.mTarget.print("push(");
            this.mTarget.print(pushStateName);
            this.mTarget.print(")\\l");
        }
        this.mTarget.println("\"];");
    }

    @Override
    public void visit(SmcAction action) {
        if (this.mGraphLevel >= 1) {
            this.mTarget.print(action.getName());
            if (this.mGraphLevel == 2) {
                List<String> arguments = action.getArguments();
                if (action.isProperty()) {
                    this.mTarget.print(" = ");
                    String arg = arguments.get(0).trim();
                    arg = arg.replaceAll("\\\\", "\\\\\\\\");
                    this.mTarget.print(arg.replaceAll("\"", "\\\\\""));
                } else {
                    this.mTarget.print("(");
                    Iterator<String> it = arguments.iterator();
                    String sep = "";
                    while (it.hasNext()) {
                        String arg = it.next().trim();
                        this.mTarget.print(sep);
                        arg = arg.replaceAll("\\\\", "\\\\\\\\");
                        this.mTarget.print(arg.replaceAll("\"", "\\\\\""));
                        sep = ", ";
                    }
                    this.mTarget.print(")");
                }
            }
            this.mTarget.print(";\\l");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getName());
        if (!parameter.getType().equals("")) {
            this.mTarget.print(": ");
            this.mTarget.print(parameter.getType());
        }
    }

    private static String doEscape(String s) {
        String retval;
        if (s.indexOf(92) < 0 && s.indexOf(34) < 0) {
            retval = s;
        } else {
            StringBuilder buffer = new StringBuilder(s.length() * 2);
            int length = s.length();
            for (int index = 0; index < length; ++index) {
                char c = s.charAt(index);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            retval = buffer.toString();
        }
        return retval;
    }

    private static String normalize(String s) {
        int length = s.length();
        boolean space = false;
        StringBuilder buffer = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            char c = s.charAt(index);
            if (space) {
                if (c == ' ' || c == '\t' || c == '\n') continue;
                buffer.append(c);
                space = false;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                buffer.append(' ');
                space = true;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString().trim();
    }
}

