/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcCSharpGenerator
extends SmcCodeGenerator {
    public SmcCSharpGenerator(SmcOptions options) {
        super(options, TargetLanguage.C_SHARP.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String separator;
        String transName;
        String indent2;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        String accessLevel = fsm.getAccessLevel();
        List<SmcMap> maps = fsm.getMaps();
        this.outputHeader();
        if (accessLevel == null || accessLevel.length() == 0) {
            accessLevel = "public";
        }
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        this.mTarget.println("using System;");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("using System.Diagnostics;");
        }
        if (this.mSerialFlag) {
            this.mTarget.println("using System.Runtime.Serialization;");
            this.mTarget.println("using System.Security;");
            this.mTarget.println("using System.Security.Permissions;");
        }
        if (this.mReflectFlag) {
            if (this.mGenericFlag) {
                this.mTarget.println("using System.Collections.Generic;");
            } else {
                this.mTarget.println("using System.Collections;");
            }
        }
        this.mTarget.println();
        for (String string : fsm.getImports()) {
            this.mTarget.print("using ");
            this.mTarget.print(string);
            this.mTarget.println(";");
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.print("namespace ");
            this.mTarget.println(packageName);
            this.mTarget.println("{");
            this.mIndent = "    ";
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("[Serializable]");
        }
        this.addGeneratedCodeAttribute("");
        this.mTarget.print(this.mIndent);
        this.mTarget.print(accessLevel);
        this.mTarget.print(" sealed class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    statemap.FSMContext");
        if (!this.mSerialFlag) {
            this.mTarget.println();
        } else {
            this.mTarget.println(',');
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ISerializable");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Properties.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public ");
        this.mTarget.print(context);
        this.mTarget.println("State State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        get");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            lock (this)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            indent2 = this.mIndent + "                ";
        } else {
            indent2 = this.mIndent + "            ";
        }
        this.mTarget.print(indent2);
        this.mTarget.println("if (state_ == null)");
        this.mTarget.print(indent2);
        this.mTarget.println("{");
        this.mTarget.print(indent2);
        this.mTarget.println("    throw(");
        this.mTarget.print(indent2);
        this.mTarget.println("        new statemap.StateUndefinedException());");
        this.mTarget.print(indent2);
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.print(indent2);
        this.mTarget.print("return ((");
        this.mTarget.print(context);
        this.mTarget.println("State) state_);");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        set");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            lock (this)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            indent2 = this.mIndent + "                ";
        } else {
            indent2 = this.mIndent + "            ";
        }
        this.mTarget.print(indent2);
        this.mTarget.println("SetState(value);");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public ");
        this.mTarget.print(context);
        this.mTarget.println(" Owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        get");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            return (_owner);");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        set");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            lock (this)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            indent2 = this.mIndent + "                ";
        } else {
            indent2 = this.mIndent + "            ";
        }
        this.mTarget.print(indent2);
        this.mTarget.println("_owner = value;");
        if (this.mSyncFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public ");
            this.mTarget.print(context);
            this.mTarget.println("State[] States");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            return (_States);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Member methods.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//");
        this.mTarget.println();
        int index = startState.indexOf("::");
        String csState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(");
        this.mTarget.print(context);
        this.mTarget.println(" owner) :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        base (");
        this.mTarget.print(csState);
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.println("        _owner = owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public override void EnterStartState()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        State.Entry(this);");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        return;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("(SerializationInfo info, ");
            this.mTarget.println("StreamingContext context) :");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        base ()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        int stackSize;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        int stateId;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        stackSize = ");
            this.mTarget.println("info.GetInt32(\"stackSize\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if (stackSize > 0)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            int index;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            String name;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            for (index = (stackSize - 1); ");
            this.mTarget.println("index >= 0; --index)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.println("name = \"stackIndex\" + index;");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.println("stateId = info.GetInt32(name);");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.println("PushState(_States[stateId]);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        stateId = info.GetInt32(\"state\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        PushState(_States[stateId]);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition smcTransition : transitions) {
            transName = smcTransition.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public void ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            List<SmcParameter> params = smcTransition.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            if (this.mSyncFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        lock (this)");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        {");
                indent2 = this.mIndent + "            ";
            } else {
                indent2 = this.mIndent + "        ";
            }
            this.mTarget.print(indent2);
            this.mTarget.print("transition_ = \"");
            this.mTarget.print(transName);
            this.mTarget.println("\";");
            this.mTarget.print(indent2);
            this.mTarget.print("State.");
            this.mTarget.print(transName);
            this.mTarget.print("(this");
            for (SmcParameter smcParameter : params) {
                this.mTarget.print(", ");
                this.passParameter(smcParameter);
            }
            this.mTarget.println(");");
            this.mTarget.print(indent2);
            this.mTarget.println("transition_ = \"\";");
            if (this.mSyncFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        }");
                this.mTarget.println();
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public ");
            this.mTarget.print(context);
            this.mTarget.println("State valueOf(int stateId)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return(_States[stateId]);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    [SecurityPermissionAttribute(");
            this.mTarget.print("SecurityAction.Demand, ");
            this.mTarget.println("SerializationFormatter=true)]");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public void GetObjectData(");
            this.mTarget.println("SerializationInfo info,");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                              ");
            this.mTarget.println("StreamingContext context)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        int stackSize = 0;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if (stateStack_ != null)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            stackSize = stateStack_.Count;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.println("info.AddValue(\"stackSize\", stackSize);");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if (stackSize > 0)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            int index = 0;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            String name;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            foreach (");
            this.mTarget.print(context);
            this.mTarget.println("State state in stateStack_)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.println("name = \"stackIndex\" + index;");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                info.AddValue(");
            this.mTarget.println("name, state.Id);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                ++index;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        info.AddValue(\"state\", state_.Id);");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Member data.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    [NonSerialized]");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    private ");
        this.mTarget.print(context);
        this.mTarget.println(" _owner;");
        this.mTarget.println();
        if (this.mSerialFlag || this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    // Map state IDs to state objects.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    // Used to deserialize an FSM.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    [NonSerialized]");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    private static ");
            this.mTarget.print(context);
            this.mTarget.println("State[] _States =");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    {");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.println(separator);
                    this.mTarget.print(this.mIndent);
                    this.mTarget.print("        ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    separator = ",";
                }
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    };");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Inner classes.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("//");
        this.mTarget.println();
        this.addGeneratedCodeAttribute("    ");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public abstract class ");
        this.mTarget.print(context);
        this.mTarget.println("State :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        statemap.State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    // Properties.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print("public abstract IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("<string, int>");
            }
            this.mTarget.println(" Transitions");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            get;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    // Member methods.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        internal ");
        this.mTarget.print(context);
        this.mTarget.println("State(string name, int id) :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            base (name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {}");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        protected internal virtual void Entry(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {}");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        protected internal virtual void Exit(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {}");
        this.mTarget.println();
        for (SmcTransition smcTransition : transitions) {
            transName = smcTransition.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        protected internal virtual void ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" context");
            for (SmcParameter smcParameter : smcTransition.getParameters()) {
                this.mTarget.print(", ");
                smcParameter.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Default(context);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        protected internal virtual void Default(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" context)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("#if TRACE");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Trace.WriteLine(");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                \"TRANSITION : Default\"");
            this.mTarget.println(");");
            this.mTarget.println("#endif");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            throw (");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("                ");
        this.mTarget.println("new statemap.TransitionUndefinedException(");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                    \"State: \" +");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                    context.State.Name +");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                    \", Transition: \" +");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                    context.GetTransition()));");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        for (SmcMap smcMap : maps) {
            smcMap.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.println("}");
        }
        this.outputFooter();
    }

    private void addGeneratedCodeAttribute(String indent) {
        this.mTarget.print(this.mIndent);
        this.mTarget.print(indent);
        this.mTarget.println("[System.CodeDom.Compiler.GeneratedCode(\"" + this.mAppName + "\",\" " + this.mAppVersion + "\")]");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.addGeneratedCodeAttribute("    ");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    internal abstract class ");
        this.mTarget.println(mapName);
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    // Member methods.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    // Member data.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        //-------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        // Statics.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        //");
        for (SmcState state : states) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        [NonSerialized]");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        internal static readonly ");
            this.mTarget.print(mapName);
            this.mTarget.print("_Default.");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print(' ');
            this.mTarget.print(state.getInstanceName());
            this.mTarget.println(" =");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            new ");
            this.mTarget.print(mapName);
            this.mTarget.print("_Default.");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(state.getClassName());
            this.mTarget.print("(\"");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(state.getClassName());
            this.mTarget.print("\", ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(");");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        [NonSerialized]");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        private static readonly ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default Default =");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("            new ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(\"");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default\", -1);");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        this.addGeneratedCodeAttribute("    ");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    internal class ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    // Properties.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print("public override IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("<string, int>");
            }
            this.mTarget.println(" Transitions");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                return (_transitions);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    // Member methods.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        internal ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default(string name, int id) :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            base (name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {}");
        String indent2 = this.mIndent;
        this.mIndent = this.mIndent + "        ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept(this);
        }
        this.mIndent = indent2;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    // Inner classes.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    //");
        for (SmcState state : states) {
            state.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    // Member data.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    //");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //-------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        // Statics.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print("private static IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("<string, int>");
            }
            this.mTarget.println(" _transitions;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        static ");
            this.mTarget.print(mapName);
            this.mTarget.println("_Default()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print("_transitions = new ");
            if (this.mGenericFlag) {
                this.mTarget.print("Dictionary<string, int>");
            } else {
                this.mTarget.print("Hashtable");
            }
            this.mTarget.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                transName = transName + "(";
                List<SmcParameter> parameters = transition.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    SmcParameter singleParam = parameters.get(i);
                    transName = transName + singleParam.getType() + " " + singleParam.getName();
                    if (i >= parameters.size() - 1) continue;
                    transName = transName + ", ";
                }
                transName = transName + ")";
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print("            ");
                this.mTarget.print("_transitions.Add(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(");");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.addGeneratedCodeAttribute("        ");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        internal class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.println(" :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("            ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        {");
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //-------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        // Properties.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print("public override IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("<string, int>");
            }
            this.mTarget.println(" Transitions");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                    return (_transitions);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        //-------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        // Member methods.");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        //");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("            internal ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.println("(string name, int id) :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                base (name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            {}");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print("protected internal override void Entry(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" context)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.Owner;");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "                ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                return;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print("protected internal override void Exit(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" context)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.Owner;");
            this.mTarget.println();
            this.mIndent = this.mIndent + "                ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                return;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        indent2 = this.mIndent;
        this.mIndent = this.mIndent + "            ";
        for (SmcTransition trans : state.getTransitions()) {
            trans.accept(this);
        }
        this.mIndent = indent2;
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //-------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        // Member data.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        //");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            //---------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            // Statics.");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            //");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print("new private static IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("<string, int>");
            }
            this.mTarget.println(" _transitions;");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            static ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.println("()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.print("_transitions = new ");
            if (this.mGenericFlag) {
                this.mTarget.print("Dictionary<string, int>");
            } else {
                this.mTarget.print("Hashtable");
            }
            this.mTarget.println("();");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                transName = transName + "(";
                List<SmcParameter> parameters = transition.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    SmcParameter singleParam = parameters.get(i);
                    transName = transName + singleParam.getType() + " " + singleParam.getName();
                    if (i >= parameters.size() - 1) continue;
                    transName = transName + ", ";
                }
                transName = transName + ")";
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print("                ");
                this.mTarget.print("_transitions.Add(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(");");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        }");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        SmcGuard nullGuard = null;
        Iterator<SmcGuard> git = guards.iterator();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("protected internal override void ");
        this.mTarget.print(transName);
        this.mTarget.print("(");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" context");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (transition.hasCtxtReference()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println(" ctxt = context.Owner;");
            this.mTarget.println();
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println();
            this.mTarget.println("#if TRACE");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    Trace.WriteLine(");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        \"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("\");");
            this.mTarget.println("#endif");
            this.mTarget.println();
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        base.");
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.passParameter(param);
            }
            this.mTarget.println(");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    return;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        SmcParameter param;
        Iterator iterator;
        Object parameters;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
        }
        if (!hasActions && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (hasActions) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print(context);
                this.mTarget.print("State ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = context.State;");
            } else {
                fqEndStateName = endStateName;
            }
        }
        this.mTarget.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#if TRACE");
                this.mTarget.print(indent2);
                this.mTarget.println("Trace.WriteLine(");
                this.mTarget.print(indent2);
                this.mTarget.print("    \"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(context)\");");
                this.mTarget.println("#endif");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.State.Exit(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#if TRACE");
                this.mTarget.print(indent2);
                this.mTarget.println("Trace.WriteLine(");
                this.mTarget.print(indent2);
                this.mTarget.print("    \"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(context)\");");
                this.mTarget.println("#endif");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.println("#if TRACE");
            this.mTarget.print(indent2);
            this.mTarget.println("Trace.WriteLine(");
            this.mTarget.print(indent2);
            this.mTarget.print("    \"ENTER TRANSITION: ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            iterator = parameters.iterator();
            while (iterator.hasNext()) {
                param = (SmcParameter)iterator.next();
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.print(")");
            this.mTarget.println("\");");
            this.mTarget.println("#endif");
            this.mTarget.println();
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("context.ClearState();");
            if (!this.mNoCatchFlag) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println("try");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.print(indent2);
                this.mTarget.println("finally");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.println("#if TRACE");
            this.mTarget.print(indent3);
            this.mTarget.println("Trace.WriteLine(");
            this.mTarget.print(indent3);
            this.mTarget.print("    \"EXIT TRANSITION : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            iterator = parameters.iterator();
            while (iterator.hasNext()) {
                param = (SmcParameter)iterator.next();
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.print(")");
            this.mTarget.println("\");");
            this.mTarget.println("#endif");
            this.mTarget.println();
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("context.State = ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(";");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!(loopbackFlag && !hasActions || fqEndStateName.equals("nil"))) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.State = ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(";");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println("#if TRACE");
                    this.mTarget.print(indent3);
                    this.mTarget.println("Trace.WriteLine(");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    \"BEFORE ENTRY    : ");
                    this.mTarget.print(mapName);
                    this.mTarget.print('.');
                    this.mTarget.print(stateName);
                    this.mTarget.println(".Exit(context)\");");
                    this.mTarget.println("#endif");
                    this.mTarget.println();
                }
                this.mTarget.print(indent3);
                this.mTarget.println("context.State.Entry(context);");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println("#if TRACE");
                    this.mTarget.print(indent3);
                    this.mTarget.println("Trace.WriteLine(");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    \"AFTER ENTRY     : ");
                    this.mTarget.print(mapName);
                    this.mTarget.print('.');
                    this.mTarget.print(stateName);
                    this.mTarget.println(".Exit(context)\");");
                    this.mTarget.println("#endif");
                    this.mTarget.println();
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("context.PushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("context.PopState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#if TRACE");
                this.mTarget.print(indent3);
                this.mTarget.println("Trace.WriteLine(");
                this.mTarget.print(indent3);
                this.mTarget.print("    \"BEFORE ENTRY    : ");
                this.mTarget.print(mapName);
                this.mTarget.print('.');
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Exit(context)\");");
                this.mTarget.println("#endif");
                this.mTarget.println();
            }
            this.mTarget.print(indent3);
            this.mTarget.println("context.State.Entry(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#if TRACE");
                this.mTarget.print(indent3);
                this.mTarget.println("Trace.WriteLine(");
                this.mTarget.print(indent3);
                this.mTarget.print("    \"AFTER ENTRY     : ");
                this.mTarget.print(mapName);
                this.mTarget.print('.');
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Exit(context)\");");
                this.mTarget.println("#endif");
                this.mTarget.println();
            }
        }
        if (hasActions && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println("}");
            this.mTarget.println();
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("context.EmptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("ctxt.");
            }
            this.mTarget.print(name);
            if (action.isProperty()) {
                String arg = arguments.get(0);
                this.mTarget.print(" = ");
                this.mTarget.print(arg);
                this.mTarget.println(";");
            } else {
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(");");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(" ");
        this.mTarget.print(parameter.getName());
    }

    private void outputHeader() {
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
    }

    private void outputFooter() {
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    private void passParameter(SmcParameter param) {
        String paramType = param.getType().trim();
        if (paramType.startsWith("ref ")) {
            this.mTarget.print("ref ");
        } else if (paramType.startsWith("out ")) {
            this.mTarget.print("out ");
        }
        this.mTarget.print(param.getName());
    }
}

