/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcCGenerator
extends SmcCodeGenerator {
    private String mContext;

    public SmcCGenerator(SmcOptions options) {
        super(options, TargetLanguage.C.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        List<SmcParameter> params;
        String packageName = fsm.getPackage();
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startStateName = fsm.getStartState();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            fsmClassName = packageName + "_" + fsmClassName;
            startStateName = packageName + "_" + startStateName;
        }
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String include : fsm.getIncludes()) {
            this.mTarget.print("#include ");
            this.mTarget.println(include);
        }
        this.mTarget.print("#include \"");
        if (!this.mSrcDirectory.equals(this.mHeaderDirectory)) {
            this.mTarget.print(this.findPath(this.mSrcDirectory, this.mHeaderDirectory));
        } else {
            this.mTarget.print(this.mSrcDirectory);
        }
        this.mTarget.print(this.mTargetfileBase);
        this.mTarget.format(".%s\"%n", this.mHeaderSuffix);
        List<SmcTransition> transList = fsm.getTransitions();
        this.mTarget.println();
        this.mTarget.println("#define getOwner(fsm) (fsm)->_owner");
        for (SmcTransition trans : transList) {
            if (trans.isDefaultTransition()) continue;
            this.mTarget.println();
            this.mTarget.print("static void ");
            this.mTarget.print(context);
            this.mTarget.print("State_");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" *const fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.println("{");
            this.mTarget.println("    getState(fsm)->Default(fsm);");
            this.mTarget.println("}");
        }
        this.mTarget.println();
        this.mTarget.print("static void ");
        this.mTarget.print(context);
        this.mTarget.print("State_Default(struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" *const fsm)");
        this.mTarget.println("{");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if (getDebugFlag(fsm) != 0) {");
            this.mTarget.print("        TRACE(");
            this.mTarget.print("\"TRANSITION   : %s.%s\\n\", ");
            this.mTarget.println("getName(getState(fsm)), getTransition(fsm));");
            this.mTarget.println("    }");
        }
        this.mTarget.println("    State_Default(fsm);");
        this.mTarget.println("}");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            SmcState defaultState = map.getDefaultState();
            if (packageName != null && packageName.length() > 0) {
                mapName = packageName + "_" + mapName;
            }
            this.mTarget.println();
            for (SmcState state : map.getStates()) {
                for (SmcTransition trans : transList) {
                    if (trans.isDefaultTransition() || state.hasTransition(trans) || defaultState.hasTransition(trans)) continue;
                    this.mTarget.print("#define ");
                    this.mTarget.print(mapName);
                    this.mTarget.print("_");
                    this.mTarget.print(state.getInstanceName());
                    this.mTarget.print("_");
                    this.mTarget.print(trans.getName());
                    this.mTarget.print(" ");
                    this.mTarget.print(context);
                    this.mTarget.print("State_");
                    this.mTarget.println(trans.getName());
                }
                if (state.hasDefaultTransition()) continue;
                this.mTarget.print("#define ");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getInstanceName());
                this.mTarget.print("_Default ");
                this.mTarget.print(context);
                this.mTarget.println("State_Default");
            }
            for (SmcTransition trans : transList) {
                if (trans.isDefaultTransition() || defaultState.hasTransition(trans)) continue;
                this.mTarget.print("#define ");
                this.mTarget.print(mapName);
                this.mTarget.print("_DefaultState_");
                this.mTarget.print(trans.getName());
                this.mTarget.print(" ");
                this.mTarget.print(context);
                this.mTarget.print("State_");
                this.mTarget.println(trans.getName());
            }
            map.accept(this);
        }
        String targetfileCaps = this.mTargetfileBase.replace('\\', '_');
        targetfileCaps = targetfileCaps.replace('/', '_');
        targetfileCaps = targetfileCaps.toUpperCase();
        this.mTarget.println();
        this.mTarget.print("#ifdef NO_");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_MACRO");
        int index = startStateName.indexOf("::");
        String cState = index >= 0 ? startStateName.substring(0, index) + "_" + startStateName.substring(index + 2) : startStateName;
        this.mTarget.print("void ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("_Init");
        this.mTarget.print("(struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" *const fsm, struct ");
        this.mTarget.print(context);
        this.mTarget.println(" *const owner)");
        this.mTarget.println("{");
        this.mTarget.print("    FSM_INIT(fsm, &");
        this.mTarget.print(cState);
        this.mTarget.println(");");
        this.mTarget.println("    fsm->_owner = owner;");
        this.mTarget.println("}");
        if (fsm.hasEntryActions()) {
            this.mTarget.println();
            this.mTarget.print("void ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_EnterStartState(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm)");
            this.mTarget.println("{");
            this.mTarget.println("    ENTRY_STATE(fsm, getState(fsm));");
            this.mTarget.println("}");
        }
        for (SmcTransition trans : transList) {
            if (trans.isDefaultTransition()) continue;
            this.mTarget.println();
            this.mTarget.print("void ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" *const fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getType());
                this.mTarget.print(" ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(")");
            this.mTarget.println("{");
            this.mTarget.print("    const struct ");
            this.mTarget.print(context);
            this.mTarget.println("State* state = getState(fsm);");
            this.mTarget.println();
            this.mTarget.println("    assert(state != NULL);");
            this.mTarget.print("    setTransition(fsm, \"");
            this.mTarget.print(trans.getName());
            this.mTarget.println("\");");
            this.mTarget.print("    state->");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(fsm");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("    setTransition(fsm, NULL);");
            this.mTarget.println("}");
        }
        this.mTarget.println("#endif");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        String stateName;
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            mapName = packageName + "_" + mapName;
        }
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition trans : defaultState.getTransitions()) {
                String transName = trans.getName();
                this.mTarget.println();
                trans.accept(this);
                for (SmcState state : map.getStates()) {
                    stateName = state.getInstanceName();
                    if (state.hasTransition(trans)) continue;
                    this.mTarget.print("#define ");
                    this.mTarget.print(mapName);
                    this.mTarget.print("_");
                    this.mTarget.print(stateName);
                    this.mTarget.print("_");
                    this.mTarget.print(transName);
                    this.mTarget.print(" ");
                    this.mTarget.print(mapName);
                    this.mTarget.print("_DefaultState_");
                    this.mTarget.println(transName);
                }
            }
        }
        for (SmcState state : map.getStates()) {
            List<SmcAction> actions;
            stateName = state.getInstanceName();
            state.accept(this);
            this.mTarget.println();
            this.mTarget.print("const struct ");
            this.mTarget.print(context);
            this.mTarget.print("State ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.println(" = {");
            if (map.getFSM().hasEntryActions()) {
                this.mTarget.print("    ");
                actions = state.getEntryActions();
                if (actions != null && !actions.isEmpty()) {
                    this.mTarget.print(mapName);
                    this.mTarget.print("_");
                    this.mTarget.print(stateName);
                    this.mTarget.println("_Entry,");
                } else {
                    this.mTarget.println("NULL, /* Entry */");
                }
            }
            if (map.getFSM().hasExitActions()) {
                this.mTarget.print("    ");
                actions = state.getExitActions();
                if (actions != null && !actions.isEmpty()) {
                    this.mTarget.print(mapName);
                    this.mTarget.print("_");
                    this.mTarget.print(stateName);
                    this.mTarget.println("_Exit,");
                } else {
                    this.mTarget.println("NULL, /* Exit */");
                }
            }
            for (SmcTransition trans : map.getFSM().getTransitions()) {
                if (trans.isDefaultTransition()) continue;
                this.mTarget.print("    ");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(stateName);
                this.mTarget.print("_");
                this.mTarget.print(trans.getName());
                this.mTarget.println(",");
            }
            this.mTarget.print("    ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.println("_Default,");
            this.mTarget.print("    ");
            this.mTarget.print(SmcMap.getNextStateId());
            if (this.mDebugLevel >= 0) {
                this.mTarget.print(", \"");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(stateName);
                this.mTarget.print("\"");
            }
            this.mTarget.println("\n};");
        }
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String instanceName = state.getInstanceName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            fsmClassName = packageName + "_" + fsmClassName;
            mapName = packageName + "_" + mapName;
        }
        this.mContext = context;
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print("void ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(instanceName);
            this.mTarget.print("_Entry(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm)");
            this.mTarget.println("{");
            this.mTarget.print("    struct ");
            this.mTarget.print(context);
            this.mTarget.println(" *ctxt = getOwner(fsm);");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("}");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print("void ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(instanceName);
            this.mTarget.print("_Exit(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm)");
            this.mTarget.println("{");
            this.mTarget.print("    struct ");
            this.mTarget.print(context);
            this.mTarget.println(" *ctxt = getOwner(fsm);");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("}");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcGuard guard;
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getInstanceName();
        String transName = transition.getName();
        SmcGuard nullGuard = null;
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            fsmClassName = packageName + "_" + fsmClassName;
            mapName = packageName + "_" + mapName;
        }
        this.mTarget.print("static void ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.print("_");
        this.mTarget.print(transName);
        this.mTarget.print("(struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" *const fsm");
        for (SmcParameter parameter : transition.getParameters()) {
            this.mTarget.print(", ");
            parameter.accept(this);
        }
        this.mTarget.println(")");
        this.mTarget.println("{");
        if (transition.hasCtxtReference()) {
            this.mTarget.print("    struct ");
            this.mTarget.print(context);
            this.mTarget.println(" *ctxt = getOwner(fsm);");
        }
        this.mGuardCount = guards.size();
        if (this.mGuardCount == 1 && (guard = guards.get(0)).hasActions() && this.isLoopback(guard.getTransType(), guard.getEndState())) {
            this.mTarget.print("    const struct ");
            this.mTarget.print(context);
            this.mTarget.println("State* EndStateName = getState(fsm);");
        }
        this.mTarget.println();
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if (getDebugFlag(fsm) != 0) {");
            this.mTarget.print("        TRACE(\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.println(")\\n\");");
            this.mTarget.println("    }");
        }
        this.mGuardIndex = 0;
        while (git.hasNext()) {
            guard = git.next();
            if (!guard.hasCondition()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.println("    }");
            }
            this.mTarget.println("    else {");
            this.mTarget.print("        ");
            if (!stateName.equals("DefaultState")) {
                this.mTarget.print(mapName);
                this.mTarget.print("_DefaultState_");
            } else {
                this.mTarget.print(context);
                this.mTarget.print("State_");
            }
            this.mTarget.print(transName);
            this.mTarget.print("(fsm");
            for (SmcParameter param : transition.getParameters()) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        SmcParameter param;
        String sep;
        Iterator<SmcElement> pit;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getInstanceName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            fsmClassName = packageName + "_" + fsmClassName;
            mapName = packageName + "_" + mapName;
        }
        this.mContext = context;
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equalsIgnoreCase("nil")) {
            endStateName = this.scopeStateName(endStateName, map.getName());
            endStateName = packageName != null && packageName.length() > 0 ? "&" + packageName + "_" + endStateName : "&" + endStateName;
        }
        stateName = "&" + this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        pushStateName = packageName != null && packageName.length() > 0 ? "&" + packageName + "_" + pushStateName : "&" + pushStateName;
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else {");
            }
        } else if (condition == null || condition.isEmpty()) {
            indent2 = this.mIndent + "    ";
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
            indent2 = this.mIndent + "        ";
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "EndStateName";
                if (this.mGuardCount > 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.print("const struct ");
                    this.mTarget.print(context);
                    this.mTarget.print("State* ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(" = getState(fsm);");
                    this.mTarget.println();
                }
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (map.getFSM().hasExitActions() && (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag)) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(\"BEFORE EXIT     : ");
                this.mTarget.println("EXIT_STATE(fsm, getState(fsm))\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("EXIT_STATE(fsm, getState(fsm));");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(\"AFTER EXIT      : ");
                this.mTarget.println("EXIT_STATE(fsm, getState(fsm))\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(indent2);
            this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
            this.mTarget.print(indent2);
            this.mTarget.print("    TRACE(\"ENTER TRANSITION: ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                param = (SmcParameter)pit.next();
                this.mTarget.print(sep);
                this.mTarget.print(param.getName());
                sep = ", ";
            }
            this.mTarget.println(")\\n\");");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("/* No actions. */");
            }
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("clearState(fsm);");
            String indent4 = this.mIndent;
            this.mIndent = indent2;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
        }
        String indent3 = indent2;
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(indent2);
            this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
            this.mTarget.print(indent2);
            this.mTarget.print("    TRACE(\"EXIT TRANSITION : ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                param = (SmcParameter)pit.next();
                this.mTarget.print(sep);
                this.mTarget.print(param.getName());
                sep = ", ";
            }
            this.mTarget.println(")\\n\");");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("setState(fsm, ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || !actions.isEmpty()) {
                this.mTarget.print(indent3);
                this.mTarget.print("setState(fsm, ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (map.getFSM().hasEntryActions() && !loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    TRACE(\"BEFORE ENTRY    : ");
                    this.mTarget.println("ENTRY_STATE(fsm, getState(fsm))\\n\");");
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                }
                this.mTarget.print(indent3);
                this.mTarget.println("ENTRY_STATE(fsm, getState(fsm));");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    TRACE(\"AFTER ENTRY     : ");
                    this.mTarget.println("ENTRY_STATE(fsm, getState(fsm))\\n\");");
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("pushState(fsm, ");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("popState(fsm);");
        }
        if (map.getFSM().hasEntryActions() && (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH)) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(\"BEFORE ENTRY    : ");
                this.mTarget.println("ENTRY_STATE(fsm, getState(fsm))\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("ENTRY_STATE(fsm, getState(fsm));");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (getDebugFlag(fsm) != 0) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(\"AFTER ENTRY     : ");
                this.mTarget.println("ENTRY_STATE(fsm, getState(fsm))\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equalsIgnoreCase("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_");
            this.mTarget.print(endStateName);
            this.mTarget.print("(fsm");
            if (popArgs.length() > 0) {
                this.mTarget.print(", ");
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("emptyStateStack(fsm);");
        } else {
            this.mTarget.print(this.mContext);
            this.mTarget.print("_");
            this.mTarget.print(name);
            this.mTarget.print("(ctxt");
            for (String arg : action.getArguments()) {
                if (arg.isEmpty()) continue;
                this.mTarget.print(", ");
                this.mTarget.print(arg);
            }
            this.mTarget.println(");");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(" ");
        this.mTarget.print(parameter.getName());
    }

    @Override
    protected String scopeStateName(String stateName, String mapName) {
        StringWriter retval = new StringWriter();
        int index = stateName.indexOf("::");
        if (index < 0) {
            retval.write(mapName);
            retval.write("_");
            retval.write(stateName);
        } else {
            retval.write(stateName.substring(0, index));
            retval.write(95);
            retval.write(stateName.substring(index + 2));
        }
        return retval.toString();
    }
}

