/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import statemap.DebugOutputType;

public abstract class AbstractFSMContext
implements Serializable {
    public static final String STATE_PROPERTY = "State";
    protected static final String NOT_SET = "";
    private static final long serialVersionUID = 459520L;
    protected transient String mName = "FSMContext";
    protected transient String mTransition = "";
    protected transient DebugOutputType mDebugOutputType = DebugOutputType.NO_DEBUG_OUTPUT;
    protected transient PrintStream mDebugStream = null;
    protected transient Logger mDebugLogger = null;
    protected transient Level mDebugLogLevel = Level.OFF;
    protected transient PropertyChangeSupport mListeners = null;

    protected AbstractFSMContext() {
    }

    protected abstract String previousStateName();

    public final String getName() {
        return this.mName;
    }

    public final String getTransition() {
        return this.mTransition;
    }

    public final DebugOutputType getDebugOutputType() {
        return this.mDebugOutputType;
    }

    public final boolean getDebugFlag() {
        return this.mDebugOutputType != DebugOutputType.NO_DEBUG_OUTPUT;
    }

    public final PrintStream getDebugStream() {
        return this.mDebugStream;
    }

    public final Logger getDebugLogger() {
        return this.mDebugLogger;
    }

    public final Level getDebugLogLevel() {
        return this.mDebugLogLevel;
    }

    public final void setName(String name) {
        if (name != null && name.length() > 0 && !name.equals(this.mName)) {
            this.mName = name;
        }
    }

    public final void setDebugFlag(boolean flag) {
        if (!flag) {
            this.mDebugOutputType = DebugOutputType.NO_DEBUG_OUTPUT;
        } else if (this.mDebugOutputType == DebugOutputType.NO_DEBUG_OUTPUT) {
            if (this.mDebugLogger != null) {
                this.mDebugOutputType = DebugOutputType.JAVA_LOGGING;
            } else if (this.mDebugStream != null) {
                this.mDebugOutputType = DebugOutputType.PRINT_STREAM;
            } else {
                this.mDebugOutputType = DebugOutputType.PRINT_STREAM;
                this.mDebugStream = System.err;
            }
        }
    }

    public final void setDebugStream(PrintStream stream) {
        if (stream == null) {
            if (this.mDebugOutputType == DebugOutputType.PRINT_STREAM) {
                this.mDebugOutputType = DebugOutputType.NO_DEBUG_OUTPUT;
            }
            this.mDebugStream = null;
        } else {
            this.mDebugOutputType = DebugOutputType.PRINT_STREAM;
            this.mDebugStream = stream;
        }
    }

    public final void setDebugLogger(Logger logger) {
        if (logger == null) {
            if (this.mDebugOutputType == DebugOutputType.JAVA_LOGGING) {
                this.mDebugOutputType = DebugOutputType.NO_DEBUG_OUTPUT;
            }
            this.mDebugLogger = null;
        } else {
            this.mDebugOutputType = DebugOutputType.JAVA_LOGGING;
            this.mDebugLogger = logger;
        }
    }

    public final void setDebugLoggerLevel(Level logLevel) {
        this.mDebugLogLevel = logLevel == null ? Level.OFF : logLevel;
    }

    protected final void propertyChange(Object previousState, Object nextState) {
        if (this.mListeners != null) {
            this.mListeners.firePropertyChange(STATE_PROPERTY, previousState, nextState);
        }
    }

    public final void setPropertyChangeUpdate(boolean flag) {
        if (!flag) {
            this.mListeners = null;
        } else {
            if (this.mListeners != null) {
                throw new IllegalStateException("state property change update already enabled");
            }
            this.mListeners = new PropertyChangeSupport(this);
        }
    }

    public final void addStateChangeListener(PropertyChangeListener l) {
        if (this.mListeners == null) {
            throw new IllegalStateException("State property change update not enabled");
        }
        this.mListeners.addPropertyChangeListener(STATE_PROPERTY, l);
    }

    public final void removeStateChangeListener(PropertyChangeListener l) {
        if (this.mListeners != null) {
            this.mListeners.removePropertyChangeListener(STATE_PROPERTY, l);
        }
    }

    protected final void debugOutput(String message) {
        switch (this.mDebugOutputType) {
            case JAVA_LOGGING: {
                if (!this.mDebugLogger.isLoggable(this.mDebugLogLevel)) break;
                this.mDebugLogger.log(this.mDebugLogLevel, message);
                break;
            }
            case PRINT_STREAM: {
                this.mDebugStream.println(message);
                break;
            }
        }
    }

    protected final void debugOutput(Throwable tex) {
        String message = String.format("Exception in %s.%s transition.", this.previousStateName(), this.mTransition);
        switch (this.mDebugOutputType) {
            case JAVA_LOGGING: {
                if (!this.mDebugLogger.isLoggable(this.mDebugLogLevel)) break;
                this.mDebugLogger.log(this.mDebugLogLevel, message, tex);
                break;
            }
            case PRINT_STREAM: {
                this.mDebugStream.println(message);
                tex.printStackTrace(this.mDebugStream);
                break;
            }
        }
    }
}

