/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcScalaGenerator
extends SmcCodeGenerator {
    public SmcScalaGenerator(SmcOptions options) {
        super(options, TargetLanguage.SCALA.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String separator;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("// ex: set ro:");
        this.mTarget.println("// DO NOT EDIT.");
        this.mTarget.println("// generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("// from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println();
            this.mTarget.println(rawSource);
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.println();
            this.mTarget.print("package ");
            this.mTarget.println(packageName);
        }
        this.mTarget.println();
        if (this.mSyncFlag) {
            this.mTarget.println("import scala.concurrent");
            this.mTarget.println();
        }
        for (String imp : fsm.getImports()) {
            this.mTarget.print("import ");
            this.mTarget.println(imp);
        }
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(owner: ");
        this.mTarget.print(context);
        this.mTarget.print(") extends statemap.FSMContext[");
        this.mTarget.print(context);
        this.mTarget.println("State] {");
        this.mTarget.println();
        this.mTarget.print("    private val _owner: ");
        this.mTarget.print(context);
        this.mTarget.println(" = owner");
        this.mTarget.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print("    setState(");
        this.mTarget.print(javaState);
        this.mTarget.println(")");
        this.mTarget.println();
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print("    def ");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(");
            List<SmcParameter> params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.print("): Unit = ");
            if (this.mSyncFlag) {
                this.mTarget.print("synchronized ");
            }
            this.mTarget.println("{");
            this.mTarget.print("        _transition = \"");
            this.mTarget.print(trans.getName());
            this.mTarget.println("\"");
            this.mTarget.print("        getState().");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(", ");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println(")");
            this.mTarget.println("        _transition = \"\"");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    override def enterStartState(): Unit = {");
        this.mTarget.println("        getState().Entry(this)");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    def getOwner(): ");
        this.mTarget.print(context);
        this.mTarget.println(" = _owner");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print("    def getStates(): List[");
            this.mTarget.print(context);
            this.mTarget.println("State] = List(");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print(separator);
                    this.mTarget.print("        ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    separator = ",\n";
                }
            }
            this.mTarget.println();
            this.mTarget.println("    )");
            this.mTarget.println();
            this.mTarget.println("    def getTransitions(): List[String] = List(");
            separator = "";
            for (SmcTransition trans : transitions) {
                this.mTarget.print(separator);
                this.mTarget.print("        \"");
                this.mTarget.print(trans.getName());
                this.mTarget.print("\"");
                separator = ",\n";
            }
            this.mTarget.println();
            this.mTarget.println("    )");
            this.mTarget.println();
        }
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.print("State(name: String, id: Int)");
        if (this.mSerialFlag) {
            this.mTarget.print(" extends Serializable");
        }
        this.mTarget.println(" {");
        this.mTarget.println("    private val _name = name");
        this.mTarget.println("    private val _id = id");
        this.mTarget.println();
        this.mTarget.println("    def getName(): String = _name");
        this.mTarget.println();
        this.mTarget.println("    override def toString(): String = _name");
        this.mTarget.println();
        this.mTarget.print("    def Entry(context: ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("): Unit = {}");
        this.mTarget.print("    def Exit(context: ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("): Unit = {}");
        this.mTarget.println();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print("    def ");
            this.mTarget.print(transName);
            this.mTarget.print("(context: ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("");
            for (SmcParameter param : trans.getParameters()) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println("): Unit = {");
            this.mTarget.println("        Default(context)");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.print("    def Default(context: ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("): Unit = {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if (context.getDebugFlag())");
            this.mTarget.println("            context.getDebugStream().println(\"TRANSITION   : Default\")");
            this.mTarget.println();
        }
        this.mTarget.println("        throw new statemap.TransitionUndefinedException(");
        this.mTarget.println("                \"State: \" + context.getState()._name +");
        this.mTarget.println("                \", Transition: \" + context.getTransition())");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("}");
        this.mTarget.println();
        for (SmcMap map : maps) {
            map.accept(this);
        }
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.print("private class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(name: String, id: Int) extends ");
        this.mTarget.print(context);
        this.mTarget.println("State(name, id) {");
        this.mIndent = "    ";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print("    def getTransitions(): Map[String, Int] = Map(");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.println(sep);
                this.mTarget.print("        \"");
                this.mTarget.print(transName);
                this.mTarget.print("\" -> ");
                this.mTarget.print(transDefinition);
                sep = ",";
            }
            this.mTarget.println();
            this.mTarget.println("    )");
            this.mTarget.println();
        }
        this.mTarget.println("}");
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("private object ");
        this.mTarget.print(mapName);
        this.mTarget.println(" {");
        for (SmcState state : states) {
            this.mTarget.print("    val ");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = new ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("(\"");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("\", ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(")");
        }
        this.mTarget.print("    val Default = new ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(\"");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default\", -1)");
        this.mTarget.println("}");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print("private class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print("(name: String, id: Int) extends ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default(name, id) {");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print("    override def Entry (context: ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("): Unit = {");
            this.mTarget.println("        val ctxt = context.getOwner()");
            this.mTarget.println();
            String indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print("    override def Exit (context: ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("): Unit = {");
            this.mTarget.print("        val ctxt: ");
            this.mTarget.print(context);
            this.mTarget.println(" = context.getOwner()");
            this.mTarget.println();
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("    }");
        }
        this.mIndent = "    ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print("    override def getTransitions(): Map[String, Int] = Map(");
            String sep = "";
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.println(sep);
                this.mTarget.print("        \"");
                this.mTarget.print(transName);
                this.mTarget.print("\" -> ");
                this.mTarget.print(transDefinition);
                sep = ",";
            }
            this.mTarget.println();
            this.mTarget.println("    )");
            this.mTarget.println();
        }
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String fsmClassName = map.getFSM().getFsmClassName();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("override def ");
        this.mTarget.print(transName);
        this.mTarget.print("(context: ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("");
        for (SmcParameter parameter : parameters) {
            this.mTarget.print(", ");
            parameter.accept(this);
        }
        this.mTarget.println("): Unit = {");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print("val ctxt: ");
            this.mTarget.print(context);
            this.mTarget.println(" = context.getOwner()");
            this.mTarget.println();
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if (context.getDebugFlag())");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        context.getDebugStream().println(");
            this.mTarget.print("\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("\")");
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        super.");
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        } else if (this.mGuardCount > 1) {
            this.mTarget.println();
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        Object parameters;
        String fqEndStateName;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
        }
        if (!hasActions) {
            fqEndStateName = endStateName;
        } else if (loopbackFlag) {
            fqEndStateName = "endState";
            this.mTarget.print(indent2);
            this.mTarget.print("val ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(" = context.getState()");
        } else {
            fqEndStateName = endStateName;
        }
        this.mTarget.println();
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.print("    context.getDebugStream().println(");
                this.mTarget.print("\"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\")");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.getState().Exit(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.print("    context.getDebugStream().println(");
                this.mTarget.print("\"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\")");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if (context.getDebugFlag())");
            this.mTarget.print(indent2);
            this.mTarget.print("    context.getDebugStream().println(");
            this.mTarget.print("\"ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\")");
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("context.clearState()");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println('}');
                this.mTarget.print(indent2);
                this.mTarget.println("finally {");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent3);
            this.mTarget.println("if (context.getDebugFlag())");
            this.mTarget.print(indent3);
            this.mTarget.print("    context.getDebugStream().println(");
            this.mTarget.print("\"EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\")");
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("context.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(")");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.getDebugFlag())");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    context.getDebugStream().println(");
                    this.mTarget.print("\"BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\")");
                }
                this.mTarget.print(indent3);
                this.mTarget.println("context.getState().Entry(context)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.getDebugFlag())");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    context.getDebugStream().println(");
                    this.mTarget.print("\"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\")");
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("context.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("context.popState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent3);
                this.mTarget.print("    context.getDebugStream().println(");
                this.mTarget.print("\"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\")");
            }
            this.mTarget.print(indent3);
            this.mTarget.println("context.getState().Entry(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent3);
                this.mTarget.print("    context.getDebugStream().println(");
                this.mTarget.print("\"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\")");
            }
        }
        if (hasActions && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println('}');
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(")");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.println(arguments.get(0));
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("context.emptyStateStack()");
            } else {
                this.mTarget.print("ctxt.");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getName());
        this.mTarget.print(": ");
        this.mTarget.print(parameter.getType());
    }
}

