/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcRubyGenerator
extends SmcCodeGenerator {
    public SmcRubyGenerator(SmcOptions options) {
        super(options, TargetLanguage.RUBY.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        int packageDepth = 0;
        this.mTarget.println("# ex: set ro:");
        this.mTarget.println("# DO NOT EDIT.");
        this.mTarget.println("# generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("# from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        this.mIndent = "";
        if (packageName != null && packageName.length() > 0) {
            Iterator<SmcElement> tokenizer = new StringTokenizer(packageName, "::");
            while (((StringTokenizer)((Object)tokenizer)).hasMoreTokens()) {
                String token = ((StringTokenizer)((Object)tokenizer)).nextToken();
                ++packageDepth;
                this.mTarget.print(this.mIndent);
                this.mTarget.print("module ");
                this.mTarget.println(token);
                this.mTarget.println();
                this.mIndent = this.mIndent + "    ";
            }
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("require 'statemap'");
        for (String imp : fsm.getImports()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("require '");
            this.mTarget.print(imp);
            this.mTarget.println("'");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State < Statemap::State");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def Entry(fsm) end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def Exit(fsm) end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def method_missing(name, *args)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        fsm = args.shift");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        Default(fsm)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def Default(fsm)");
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if fsm.getDebugFlag then");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            fsm.getDebugStream.write(\"TRANSITION   : Default\\n\")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        end");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        msg = \"\\nState: \" + fsm.getState.getName +");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            \"\\nTransition: \" + fsm.getTransition.to_s + \"\\n\"");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        raise Statemap::TransitionUndefinedException, msg");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("_sm < Statemap::FSMContext");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def initialize(owner)");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        super(");
        this.mTarget.print(startState);
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        @_owner = owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def enterStartState()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        getState.Entry(self)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def method_missing(name, *args)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        @_transition = name");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        getState.send(name, self, *args)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        @_transition = nil");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    def getOwner()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        return @_owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    end");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("    def getStates()");
            this.mTarget.println("        return [");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print("            ");
                    this.mTarget.print(mapName);
                    this.mTarget.print("::");
                    this.mTarget.print(state.getClassName());
                    this.mTarget.println(",");
                }
            }
            this.mTarget.println("        ]");
            this.mTarget.println("    end");
            this.mTarget.println();
            this.mTarget.println("    def getTransitions()");
            this.mTarget.println("        return [");
            List<SmcTransition> transitions = fsm.getTransitions();
            for (SmcTransition trans : transitions) {
                this.mTarget.print("            '");
                this.mTarget.print(trans.getName());
                this.mTarget.println("',");
            }
            this.mTarget.println("        ]");
            this.mTarget.println("    end");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
        if (packageName != null && packageName.length() > 0) {
            for (int i = packageDepth - 1; i >= 0; --i) {
                this.mTarget.println();
                for (int j = 0; j < i; ++j) {
                    this.mTarget.print("    ");
                }
                this.mTarget.println("end");
            }
        }
        this.mTarget.println();
        this.mTarget.println("# Local variables:");
        this.mTarget.println("#  buffer-read-only: t");
        this.mTarget.println("# End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default < ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        String indent2 = this.mIndent;
        this.mIndent = this.mIndent + "    ";
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept(this);
        }
        this.mIndent = indent2;
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    def getTransitions()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print(this.mIndent);
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("module ");
        this.mTarget.println(mapName);
        this.mTarget.println();
        for (SmcState state : states) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("::new('");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("', ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(").freeze");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Default = ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default::new('");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default', -1).freeze");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print(" < ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    def Entry(fsm)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        ctxt = fsm.getOwner");
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    def Exit(fsm)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        ctxt = fsm.getOwner");
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        indent2 = this.mIndent;
        this.mIndent = this.mIndent + "    ";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        this.mIndent = indent2;
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    def getTransitions()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print(this.mIndent);
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("def ");
        this.mTarget.print(transName);
        this.mTarget.print("(fsm");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            this.mTarget.print(param.getName());
        }
        this.mTarget.println(")");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ctxt = fsm.getOwner");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if fsm.getDebugFlag then");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        fsm.getDebugStream.write(\"");
            this.mTarget.print("LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("::");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        String indent2 = this.mIndent;
        this.mIndent = this.mIndent + "    ";
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        this.mIndent = indent2;
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                indent2 = this.mIndent;
                this.mIndent = this.mIndent + "    ";
                nullGuard.accept(this);
                this.mIndent = indent2;
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        super");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        } else if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    end");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("end");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        Object parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && !endStateName.contains("::")) {
            endStateName = mapName + "::" + endStateName;
        }
        if (!stateName.contains("::")) {
            stateName = mapName + "::" + stateName;
        }
        if (pushStateName != null && pushStateName.length() > 0) {
            if (!pushStateName.contains("::")) {
                pushStateName = mapName + "::" + pushStateName;
            } else if (packageName != null && packageName.length() > 0) {
                pushStateName = packageName + "::" + pushStateName;
            }
        }
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "    ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("if ");
                this.mTarget.print(condition);
                this.mTarget.println(" then");
            } else if (condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("elsif ");
                this.mTarget.print(condition);
                this.mTarget.println(" then");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("else");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent;
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if ");
            this.mTarget.print(condition);
            this.mTarget.println(" then");
        }
        if (actions.isEmpty() && endStateName.length() != 0) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = fsm.getState");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.getDebugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.getDebugStream.write(\"");
                this.mTarget.print("BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("    end");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.getState.Exit(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if fsm.getDebugFlag then");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.getDebugStream.write(\"");
                this.mTarget.print("AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("    end");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if fsm.getDebugFlag then");
            this.mTarget.print(indent2);
            this.mTarget.print("    fsm.getDebugStream.write(\"");
            this.mTarget.print("ENTER TRANSITION: ");
            if (packageName != null && packageName.length() > 0) {
                this.mTarget.print(packageName);
                this.mTarget.print("::");
            }
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            if (!parameters.isEmpty()) {
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(((SmcParameter)pit.next()).getName());
                    sep = ", ";
                }
                this.mTarget.print(")");
            }
            this.mTarget.println("\\n\")");
            this.mTarget.print(indent2);
            this.mTarget.println("    end");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.clearState");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("begin");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                if (this.mDebugLevel >= 0) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("rescue RuntimeError => e");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    fsm.getDebugStream.write e");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("ensure");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent3);
            this.mTarget.println("if fsm.getDebugFlag then");
            this.mTarget.print(indent3);
            this.mTarget.print("    fsm.getDebugStream.write(\"");
            this.mTarget.print("EXIT TRANSITION : ");
            if (packageName != null && packageName.length() > 0) {
                this.mTarget.print(packageName);
                this.mTarget.print("::");
            }
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            if (!parameters.isEmpty()) {
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(((SmcParameter)pit.next()).getName());
                    sep = ", ";
                }
                this.mTarget.print(")");
            }
            this.mTarget.println("\\n\")");
            this.mTarget.print(indent3);
            this.mTarget.println("    end");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent3);
                this.mTarget.print("fsm.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(")");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if fsm.getDebugFlag then");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    fsm.getDebugStream.write(\"");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\\n\")");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    end");
                }
                this.mTarget.print(indent3);
                this.mTarget.println("fsm.getState.Entry(fsm)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if fsm.getDebugFlag then");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    fsm.getDebugStream.write(\"");
                    this.mTarget.print("AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(fsm)\\n\")");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    end");
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.popState");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if fsm.getDebugFlag then");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.getDebugStream.write(\"");
                this.mTarget.print("BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("    end");
            }
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.getState.Entry(fsm)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if fsm.getDebugFlag then");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.getDebugStream.write(\"");
                this.mTarget.print("AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(fsm)\\n\")");
                this.mTarget.print(indent2);
                this.mTarget.println("    end");
            }
        }
        if (actions.size() > 0 && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println("end");
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("fsm.");
            this.mTarget.print(endStateName);
            if (popArgs.length() > 0) {
                this.mTarget.print("(");
                this.mTarget.print(popArgs);
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.print(")");
            }
            this.mTarget.println();
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.println(arguments.get(0));
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("fsm.emptyStateStack()");
            } else {
                this.mTarget.print("ctxt.");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }
}

