/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcObjCGenerator
extends SmcCodeGenerator {
    public SmcObjCGenerator(SmcOptions options) {
        super(options, TargetLanguage.OBJECTIVE_C.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String mapName;
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String fqStateName = fsm.getStartState();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String include : fsm.getIncludes()) {
            this.mTarget.print("#import ");
            this.mTarget.println(include);
        }
        this.mTarget.print("#import \"");
        this.mTarget.print(this.mTargetfileBase);
        this.mTarget.format(".%s\"%n", this.mHeaderSuffix);
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Class declarations.");
        for (SmcMap map : fsm.getMaps()) {
            mapName = map.getName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("@implementation ");
            this.mTarget.println(mapName);
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    ");
                this.mTarget.print("static ");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print(" *g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(" = nil;");
            }
            this.mTarget.println();
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("+ (");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print("*)");
                this.mTarget.print(state.getInstanceName());
                this.mTarget.println(";");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("{");
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (!g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print(" = [[");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print(" alloc] initWithName:@\"");
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(state.getClassName());
                this.mTarget.print("\" stateId:");
                this.mTarget.print(SmcMap.getNextStateId());
                this.mTarget.println("];");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    ");
                this.mTarget.print("return g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(";");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("}");
                this.mTarget.println();
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("+ (void) cleanupStates");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("{");
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    ");
                this.mTarget.print("[g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print(" S_RELEASE]; g");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(" = nil;");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
            this.mTarget.println("@end");
        }
        List<SmcTransition> transList = fsm.getTransitions();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@implementation ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Entry:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Exit:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)");
            this.mTarget.print(trans.getName());
            this.mTarget.print(":(");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("*)context");
            for (SmcParameter param : trans.getParameters()) {
                this.mTarget.print(" :");
                param.accept(this);
            }
            this.mTarget.println(";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    [self Default:context];");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Default:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if ( [context debugFlag] )");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        TRACE(@");
            this.mTarget.println("\"TRANSITION   : Default\\n\\r\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    NSAssert( NO, @\"Default transition\" );");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println("@end");
        this.mTarget.println();
        Iterator<SmcMap> mapIt = fsm.getMaps().iterator();
        while (mapIt.hasNext()) {
            mapIt.next().accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@implementation ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("");
        if (fqStateName.contains("::")) {
            fqStateName = this.convertScope(fqStateName);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (id)initWithOwner:(");
        this.printContextType(context);
        this.mTarget.print(")");
        this.mTarget.println("owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print("self = [super initWithState:");
        this.mTarget.print(fqStateName);
        this.mTarget.println("];");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("if (!self)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        ");
        this.mTarget.println("return nil;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("_owner = owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("return self;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (id)initWithOwner:(");
        this.printContextType(context);
        this.mTarget.print(")");
        this.mTarget.println("owner state:(SMCState*)aState;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("self = [super initWithState: aState];");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("if (!self)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        ");
        this.mTarget.println("return nil;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("_owner = owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("return self;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("- (void)dealloc");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        for (SmcMap map : fsm.getMaps()) {
            mapName = map.getName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    [");
            this.mTarget.print(mapName);
            this.mTarget.println(" cleanupStates];");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    [super S_DEALLOC];");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (");
        this.mTarget.print(context);
        this.mTarget.println("State*)state;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print("return (");
        this.mTarget.print(context);
        this.mTarget.println("State*)_state;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (");
        this.printContextType(context);
        this.mTarget.println(")owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.println("return _owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("- (void)enterStartState;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    [[self state] Entry:self];");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)");
            this.mTarget.print(trans.getName());
            List<SmcParameter> params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            String separator = ":";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = " :";
            }
            this.mTarget.println(";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("{");
            if (this.mDebugLevel >= 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    [self setTransition:@\"");
                this.mTarget.print(trans.getName());
                this.mTarget.println("\"];");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    [[self state] ");
            this.mTarget.print(trans.getName());
            this.mTarget.print(":self");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(" :");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println("];");
            if (this.mDebugLevel >= 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    [self setTransition:nil];");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@implementation ");
        this.mTarget.print(map.getName());
        this.mTarget.println("_Default");
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept(this);
            }
        }
        this.mTarget.println("@end");
        for (SmcState state : map.getStates()) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String className = state.getClassName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@implementation ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.println(className);
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)Entry:(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("*)context;");
            this.mTarget.println();
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.printContextType(context);
            this.mTarget.println(" ctxt = [context owner];");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)Exit:(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("*)context;");
            this.mTarget.println();
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.printContextType(context);
            this.mTarget.println(" ctxt = [context owner];");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)");
        this.mTarget.print(transName);
        this.mTarget.print(":(");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("*)context");
        for (SmcParameter param : transition.getParameters()) {
            this.mTarget.print(" :");
            param.accept(this);
        }
        this.mTarget.println(";");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.printContextType(context);
            this.mTarget.println(" ctxt = [context owner];");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if ( [context debugFlag] )");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        TRACE(@\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("::");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\\r\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("         [super ");
            this.mTarget.print(transName);
            this.mTarget.print(":context");
            for (SmcParameter param : transition.getParameters()) {
                this.mTarget.print(" :");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println("];");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator<SmcElement> pit;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && !endStateName.contains("::")) {
            endStateName = mapName + "::" + endStateName;
        }
        if (endStateName.contains("::")) {
            endStateName = this.convertScope(endStateName);
        }
        if (stateName.contains("::")) {
            stateName = this.convertScope(stateName);
        }
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (pushStateName != null && !pushStateName.isEmpty() && !pushStateName.contains("::")) {
            pushStateName = "[" + mapName + " " + pushStateName + "]";
        }
        if (pushStateName != null && pushStateName.contains("::")) {
            pushStateName = this.convertScope(pushStateName);
        }
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.println(this.mIndent);
                this.mTarget.println("    {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            indent2 = this.mIndent + "        ";
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (!actions.isEmpty()) {
            if (loopbackFlag) {
                fqEndStateName = "EndStateName";
                this.mTarget.print(indent2);
                this.mTarget.print(context);
                this.mTarget.print("State* ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = [context state];");
                this.mTarget.println();
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ( [context debugFlag] )");
                this.mTarget.print(indent2);
                this.mTarget.print("{");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(@\"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println("\\n\\r\");");
                this.mTarget.print(indent2);
                this.mTarget.print("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("[[context state] Exit:context];");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ( [context debugFlag] )");
                this.mTarget.print(indent2);
                this.mTarget.print("{");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(@\"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println("\\n\\r\");");
                this.mTarget.print(indent2);
                this.mTarget.print("}");
            }
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(indent2);
            this.mTarget.println("if ( [context debugFlag] )");
            this.mTarget.print(indent2);
            this.mTarget.println("{");
            this.mTarget.print(indent2);
            this.mTarget.print("    TRACE(@\"ENTER TRANSITION: ");
            this.mTarget.print(mapName);
            this.mTarget.print(" ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = " ";
            }
            this.mTarget.println(")\\n\\r\");");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("[context clearState];");
            indent3 = indent2;
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(indent3);
            this.mTarget.println("if ( [context debugFlag] )");
            this.mTarget.print(indent3);
            this.mTarget.println("{");
            this.mTarget.print(indent3);
            this.mTarget.print("    TRACE(@\"EXIT TRANSITION : ");
            this.mTarget.print(mapName);
            this.mTarget.print(" ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = transition.getParameters().iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = " ";
            }
            this.mTarget.println(")\\n\\r\");");
            this.mTarget.print(indent3);
            this.mTarget.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.isEmpty() && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("[context setState:");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println("];");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent3);
                this.mTarget.print("[context setState:");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("];");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if ( [context debugFlag] )");
                    this.mTarget.print(indent3);
                    this.mTarget.print("{");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    TRACE(@\"BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("\\n\\r\");");
                    this.mTarget.print(indent3);
                    this.mTarget.print("}");
                }
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.println("[[context state] Entry:context];");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("if ( [context debugFlag] )");
                    this.mTarget.print(indent3);
                    this.mTarget.print("{");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    TRACE(@\"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("\\n\\r\");");
                    this.mTarget.print(indent3);
                    this.mTarget.print("}");
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("[context pushState:");
            this.mTarget.print(pushStateName);
            this.mTarget.println("];");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("[context popState];");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ( [context debugFlag] )");
                this.mTarget.print(indent2);
                this.mTarget.print("{");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(@\"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("\\n\\r\");");
                this.mTarget.print(indent2);
                this.mTarget.print("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("[[context state] Entry:context];");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ( [context debugFlag] )");
                this.mTarget.print(indent2);
                this.mTarget.print("{");
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(@\"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("\\n\\r\");");
                this.mTarget.print(indent2);
                this.mTarget.print("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            int popLength = popArgs.length();
            this.mTarget.print(indent2);
            this.mTarget.print("[context ");
            this.mTarget.print(endStateName);
            if (popLength > 0) {
                int cur = 0;
                int comma = popArgs.indexOf(44);
                while (comma >= 0) {
                    this.mTarget.print(':');
                    this.mTarget.print(popArgs.substring(cur, comma));
                    cur = comma + 1;
                    comma = popArgs.indexOf(44, cur);
                }
                if (cur < popLength) {
                    this.mTarget.print(':');
                    this.mTarget.print(popArgs.substring(cur));
                }
            }
            this.mTarget.println("];");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        String sep = ":";
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("[context emptyStateStack];");
        } else {
            this.mTarget.print("[ctxt ");
            this.mTarget.print(name);
            for (String arg : action.getArguments()) {
                if (arg.trim().length() <= 0) continue;
                this.mTarget.print(sep);
                this.mTarget.print(arg);
            }
            this.mTarget.println("];");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print("(");
        this.mTarget.print(parameter.getType());
        this.mTarget.print(")");
        this.mTarget.print(parameter.getName());
    }

    private String convertScope(String s) {
        int index = s.indexOf("::");
        return "[" + s.substring(0, index) + " " + s.substring(index + 2) + "]";
    }

    private void printContextType(String context) {
        if (this.mUseProtocolFlag) {
            this.mTarget.print("id<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        } else {
            this.mTarget.print(context);
            this.mTarget.print("*");
        }
    }
}

