/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcJava7Generator
extends SmcCodeGenerator {
    private static final String DEFAULT_NAME = "Default";
    private static final String SYSTEM_DEFAULT = "defaultTransition";
    private static final List<SmcParameter> DEFAULT_PARAMETERS = new ArrayList<SmcParameter>();
    private static final String NIL_STATE = "nil";
    private static final String STATE_ID_SUFFIX = "_STATE_ID";
    private static final String TRANSITION_ID_SUFFIX = "_TRANSITION_ID";
    private static final String ENTRY_NAME = "%s_%s__Entry_";
    private static final String EXIT_NAME = "%s_%s__Exit_";

    public SmcJava7Generator(SmcOptions options) {
        super(options, TargetLanguage.JAVA7.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        this.outputHeader(fsm);
        this.outputImports(fsm);
        this.outputClassDeclaration(fsm);
        this.outputMethods(fsm);
        this.outputData(fsm);
        this.outputFooter();
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        if (defaultState != null) {
            defaultState.accept(this);
        }
        for (SmcState state : map.getStates()) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        String mapName = state.getMap().getName();
        String stateName = state.getClassName();
        List<SmcAction> entryActions = state.getEntryActions();
        List<SmcAction> exitActions = state.getExitActions();
        List<SmcTransition> transitions = state.getTransitions();
        this.mIndent = "    ";
        if (entryActions != null && !entryActions.isEmpty() || exitActions != null && !exitActions.isEmpty()) {
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.print("    // ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println(" State Entry/Exit Actions.");
            this.mTarget.println("    //");
            if (entryActions != null && !entryActions.isEmpty()) {
                this.outputStateActions(mapName, stateName, ENTRY_NAME, entryActions);
            }
            if (exitActions != null && !exitActions.isEmpty()) {
                this.outputStateActions(mapName, stateName, EXIT_NAME, exitActions);
            }
            this.mTarget.println();
            this.mTarget.println("    //");
            this.mTarget.print("    // end of ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println(" State Entry/Exit Actions.");
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.println();
        }
        if (!transitions.isEmpty()) {
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.print("    // ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println(" State Transitions.");
            this.mTarget.println("    //");
            for (SmcTransition transition : transitions) {
                transition.accept(this);
            }
            this.mTarget.println();
            this.mTarget.println("    //");
            this.mTarget.print("    // end of ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println(" State Transitions.");
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.println();
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        String sep = "";
        this.mTarget.println();
        this.mTarget.print("    private void ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.print("_");
        this.mTarget.print(transName);
        this.mTarget.print("(");
        for (SmcParameter parameter : transition.getParameters()) {
            this.mTarget.print(sep);
            parameter.accept(this);
            sep = ", ";
        }
        this.mTarget.println(")");
        this.mTarget.println("    {");
        this.outputTransitionGuards(transition, mapName);
        this.mTarget.println("    }");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcGuard guard) {
        SmcElement.TransType transType = guard.getTransType();
        boolean hasActions = !guard.getActions().isEmpty();
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String endStateName = guard.getEndState();
        String endStateId = "";
        String pushStateId = "";
        String pushStateName = "";
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (transType == SmcElement.TransType.TRANS_SET) {
            endStateId = loopbackFlag ? "stateId" : this.scopeStateName(endStateName, mapName, "_") + STATE_ID_SUFFIX;
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            endStateId = endStateName.endsWith(DEFAULT_NAME) || endStateName.endsWith(NIL_STATE) ? "stateId" : this.scopeStateName(endStateName, mapName, "_") + STATE_ID_SUFFIX;
            pushStateName = guard.getPushState();
            pushStateId = this.scopeStateName(pushStateName, mapName, "_") + STATE_ID_SUFFIX;
        }
        this.outputGuardCondition(guard.getCondition());
        if (transType != SmcElement.TransType.TRANS_PUSH && !loopbackFlag) {
            this.outputStateExit(mapName, stateName);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("try");
        this.mTarget.print(this.mIndent);
        this.mTarget.println('{');
        this.outputGuardBody(guard, transition, mapName, stateName);
        this.mTarget.print(this.mIndent);
        this.mTarget.println('}');
        this.mTarget.print(this.mIndent);
        this.mTarget.println("finally");
        this.mTarget.print(this.mIndent);
        this.mTarget.println('{');
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    setState(sStates[");
            this.mTarget.print(endStateId);
            this.mTarget.println("]);");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    setState(sStates[");
                this.mTarget.print(endStateId);
                this.mTarget.println("]);");
            }
            if (!loopbackFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    enterState();");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    pushState(sStates[");
            this.mTarget.print(pushStateId);
            this.mTarget.println("]);");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    popState();");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println('}');
        this.mTarget.println();
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag) {
            this.outputStateEnter(mapName, endStateName);
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            this.outputStateEnter(mapName, pushStateName);
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.isEmpty() && !endStateName.equals(NIL_STATE)) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            this.mTarget.print(guard.getPopArgs());
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1 || !guard.getCondition().isEmpty()) {
            this.mTarget.print("        }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("    emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("    ctxt.");
            }
            this.mTarget.print(name);
            this.mTarget.print("(");
            Iterator<String> it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(it.next());
                sep = ", ";
            }
            this.mTarget.println(");");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(' ');
        this.mTarget.print(parameter.getName());
    }

    private void outputHeader(SmcFSM fsm) {
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.print("package ");
            this.mTarget.print(packageName);
            this.mTarget.println(";");
            this.mTarget.println();
        }
    }

    private void outputImports(SmcFSM fsm) {
        for (String imp : fsm.getImports()) {
            this.mTarget.print("import ");
            this.mTarget.print(imp);
            this.mTarget.println(";");
        }
        if (this.mSerialFlag) {
            this.mTarget.println("import java.io.IOException;");
            this.mTarget.println("import java.io.ObjectInputStream;");
            this.mTarget.println("import java.io.ObjectOutputStream;");
            this.mTarget.println("import java.io.Serializable;");
        }
        this.mTarget.println("import java.lang.invoke.MethodHandle;");
        this.mTarget.println("import java.lang.invoke.MethodHandles;");
        this.mTarget.println("import java.lang.invoke.MethodHandles.Lookup;");
        this.mTarget.println("import java.lang.invoke.MethodType;");
        if (this.mSerialFlag) {
            this.mTarget.println("import java.util.ArrayDeque;");
            this.mTarget.println("import java.util.Iterator;");
        }
        this.mTarget.println("import statemap.FSMContext7;");
        this.mTarget.println("import statemap.State7;");
        this.mTarget.println("import statemap.TransitionHandle;");
        this.mTarget.println();
    }

    private void outputClassDeclaration(SmcFSM fsm) {
        String fsmClassName = fsm.getFsmClassName();
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("");
        this.mTarget.println("    extends FSMContext7");
        if (this.mSerialFlag) {
            this.mTarget.println("    implements Serializable");
        }
        this.mTarget.println("{");
    }

    private void outputMethods(SmcFSM fsm) {
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.println("// Member methods.");
        this.mTarget.println("//");
        this.mTarget.println();
        this.outputConstructors(fsm);
        if (this.mSerialFlag || this.mReflectFlag) {
            this.outputGet(fsm.getContext());
        }
        this.outputSet(fsm);
        this.outputExecuteAction();
        this.outputTransitionApi(fsm);
        if (this.mSerialFlag) {
            this.outputSerializeMethods(fsm);
        }
        for (SmcMap map : fsm.getMaps()) {
            map.accept(this);
        }
    }

    private void outputConstructors(SmcFSM fsm) {
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        int index = startState.indexOf("::");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Constructors.");
        this.mTarget.println("    //");
        this.mTarget.println();
        String javaState = startState.substring(0, index) + "_" + startState.substring(index + 2) + STATE_ID_SUFFIX;
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(final ");
        this.mTarget.print(context);
        this.mTarget.println(" owner)");
        this.mTarget.println("    {");
        this.mTarget.print("        this (owner, sStates[");
        this.mTarget.print(javaState);
        this.mTarget.println("]);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(final ");
        this.mTarget.print(context);
        this.mTarget.println(" owner, final int initStateId)");
        this.mTarget.println("    {");
        this.mTarget.print("        this (owner, sStates[initStateId]);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print("    ");
        this.mTarget.print(this.mAccessLevel);
        this.mTarget.print(" ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(final ");
        this.mTarget.print(context);
        this.mTarget.println(" owner, final State7 initState)");
        this.mTarget.println("    {");
        this.mTarget.println("        super (initState);");
        this.mTarget.println();
        this.mTarget.println("        ctxt = owner;");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    //");
        this.mTarget.println("    // end of Constructors.");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println();
    }

    private void outputGet(String context) {
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Get Methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.print("    public ");
        this.mTarget.print(context);
        this.mTarget.println(" getOwner()");
        this.mTarget.println("    {");
        this.mTarget.println("        return (ctxt);");
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("    public static State7 getState(final int stateId)");
            this.mTarget.println("        throws ArrayIndexOutOfBoundsException");
            this.mTarget.println("    {");
            this.mTarget.println("        return (sStates[stateId]);");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println("    public static State7[] getStates()");
            this.mTarget.println("    {");
            this.mTarget.println("        return (sStates);");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println("    public static String[] getTransitions()");
            this.mTarget.println("    {");
            this.mTarget.println("        return (TRANSITION_NAMES);");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    //");
        this.mTarget.println("    // end of Get Methods.");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println();
    }

    private void outputSet(SmcFSM fsm) {
        if (this.mSerialFlag) {
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.println("    // Set Methods.");
            this.mTarget.println("    //");
            this.mTarget.println();
            this.mTarget.print("    public void setOwner(");
            this.mTarget.print(fsm.getContext());
            this.mTarget.println(" owner)");
            this.mTarget.println("    {");
            this.mTarget.println("        if (owner == null)");
            this.mTarget.println("        {");
            this.mTarget.println("            throw (new NullPointerException(\"null owner\"));");
            this.mTarget.println("        }");
            this.mTarget.println("        else");
            this.mTarget.println("        {");
            this.mTarget.println("            ctxt = owner;");
            this.mTarget.println("        }");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println("    //");
            this.mTarget.println("    // end of Set Methods.");
            this.mTarget.println("    //-----------------------------------------------------------");
            this.mTarget.println();
        }
    }

    private void outputExecuteAction() {
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // FSMContext7 Abstract Method Override.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("    @Override");
        this.mTarget.println("    protected void executeAction(final MethodHandle mh)");
        this.mTarget.println("    {");
        this.mTarget.println("        try");
        this.mTarget.println("        {");
        this.mTarget.println("            mh.invokeExact(this);");
        this.mTarget.println("        }");
        this.mTarget.println("        catch (Throwable tex)");
        this.mTarget.println("        {");
        this.mTarget.println("            debugOutput(tex);");
        this.mTarget.println();
        this.mTarget.println("            if (RuntimeException.class.isInstance(tex))");
        this.mTarget.println("            {");
        this.mTarget.println("                throw ((RuntimeException) tex);");
        this.mTarget.println("            }");
        this.mTarget.println("        }");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    //");
        this.mTarget.println("    // end of FSMContext7 Abstract Method Override.");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println();
    }

    private void outputTransitionApi(SmcFSM fsm) {
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Transitions.");
        this.mTarget.println("    //");
        this.mTarget.println();
        for (SmcTransition trans : fsm.getTransitions()) {
            String transName = trans.getName();
            if (transName.equals(DEFAULT_NAME)) continue;
            this.mTarget.print("    public ");
            if (this.mSyncFlag) {
                this.mTarget.print("synchronized ");
            }
            this.mTarget.print("void ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            List<SmcParameter> params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(")");
            this.mTarget.println("    {");
            this.mTarget.print("        mTransition = \"");
            this.mTarget.print(transName);
            this.mTarget.println("\";");
            this.mTarget.println("        try");
            this.mTarget.println("        {");
            this.mTarget.println("            final TransitionHandle th =");
            this.mTarget.print("                getState().transition(");
            this.mTarget.print(transName);
            this.mTarget.print(trans.getIdentifier());
            this.mTarget.print(TRANSITION_ID_SUFFIX);
            this.mTarget.println(");");
            this.mTarget.println();
            if (params.isEmpty()) {
                this.mTarget.println("            (th.handle()).invokeExact(this);");
            } else {
                this.mTarget.println("            if (th.isDefault())");
                this.mTarget.println("            {");
                this.mTarget.println("                (th.handle()).invokeExact(this);");
                this.mTarget.println("            }");
                this.mTarget.println("            else");
                this.mTarget.println("            {");
                this.mTarget.print("                (th.handle()).invokeExact(this");
                pit = params.iterator();
                while (pit.hasNext()) {
                    this.mTarget.print(", ");
                    this.mTarget.print(pit.next().getName());
                }
                this.mTarget.println(");");
                this.mTarget.println("            }");
            }
            this.mTarget.println("        }");
            this.mTarget.println("        catch (Throwable tex)");
            this.mTarget.println("        {");
            this.mTarget.println("            debugOutput(tex);");
            this.mTarget.println();
            this.mTarget.println("            if (RuntimeException.class.isInstance(tex))");
            this.mTarget.println("            {");
            this.mTarget.println("                throw ((RuntimeException) tex);");
            this.mTarget.println("            }");
            this.mTarget.println("        }");
            this.mTarget.println("        mTransition = \"\";");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("    //");
        this.mTarget.println("    // end of Transitions.");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println();
    }

    private void outputSerializeMethods(SmcFSM fsm) {
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Serialization Methods.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("    private void writeObject(final ObjectOutputStream ostream)");
        this.mTarget.println("        throws IOException");
        this.mTarget.println("    {");
        this.mTarget.println("        final int size =");
        this.mTarget.println("            (mStateStack == null ? 0 : mStateStack.size());");
        this.mTarget.println("        int i;");
        this.mTarget.println();
        this.mTarget.println("        ostream.writeInt(size);");
        this.mTarget.println();
        this.mTarget.println("        if (size > 0)");
        this.mTarget.println("        {");
        this.mTarget.println("            final Iterator<State7> sit =");
        this.mTarget.println("                mStateStack.iterator();");
        this.mTarget.println();
        this.mTarget.println("            while (sit.hasNext())");
        this.mTarget.println("            {");
        this.mTarget.println("                ostream.writeInt((sit.next()).getId());");
        this.mTarget.println("            }");
        this.mTarget.println("        }");
        this.mTarget.println();
        this.mTarget.println("        ostream.writeInt(mState.getId());");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    private void readObject(final ObjectInputStream istream)");
        this.mTarget.println("        throws IOException");
        this.mTarget.println("    {");
        this.mTarget.println("        final int size = istream.readInt();");
        this.mTarget.println();
        this.mTarget.println("        if (size == 0)");
        this.mTarget.println("        {");
        this.mTarget.println("            mStateStack = null;");
        this.mTarget.println("        }");
        this.mTarget.println("        else");
        this.mTarget.println("        {");
        this.mTarget.println("            int i;");
        this.mTarget.println();
        this.mTarget.println("            mStateStack = new ArrayDeque<>();");
        this.mTarget.println();
        this.mTarget.println("            for (i = 0; i < size; ++i)");
        this.mTarget.println("            {");
        this.mTarget.println("                mStateStack.addLast(sStates[istream.readInt()]);");
        this.mTarget.println("            }");
        this.mTarget.println("        }");
        this.mTarget.println();
        this.mTarget.println("        mState = sStates[istream.readInt()];");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    //");
        this.mTarget.println("    // end of Serialization Methods.");
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println();
    }

    private void outputData(SmcFSM fsm) {
        String context = fsm.getContext();
        this.mTarget.println("//---------------------------------------------------------------");
        this.mTarget.println("// Member data.");
        this.mTarget.println("//");
        this.mTarget.println();
        this.mTarget.print("    transient private ");
        this.mTarget.print(context);
        this.mTarget.println(" ctxt;");
        this.mTarget.println();
        this.mTarget.println("    //-----------------------------------------------------------");
        this.mTarget.println("    // Constants.");
        this.mTarget.println("    //");
        this.mTarget.println();
        this.mTarget.println("    private static final long serialVersionUID = 1L;");
        this.mTarget.println();
        this.outputStateIds(fsm);
        this.outputTransitionIds(fsm);
        this.outputTransitionSignatures(fsm);
        this.outputNames(fsm);
        this.mTarget.println("    private static final State7[] sStates = new State7[STATE_COUNT];");
        this.mTarget.println();
        this.outputClassInit(fsm);
        if (this.mReflectFlag) {
            this.outputMapClasses(fsm);
        }
    }

    private void outputStateIds(SmcFSM fsm) {
        List<SmcMap> maps = fsm.getMaps();
        int stateId = 0;
        for (SmcMap map : maps) {
            String mapName = map.getName();
            for (SmcState state : map.getStates()) {
                String stateIdName = String.format("%s_%s%s", mapName, state.getClassName(), STATE_ID_SUFFIX);
                this.mTarget.print("    ");
                this.mTarget.print(this.mAccessLevel);
                this.mTarget.print(" static final int ");
                this.mTarget.print(stateIdName);
                this.mTarget.print(" = ");
                this.mTarget.print(stateId);
                this.mTarget.println(";");
                ++stateId;
            }
            this.mTarget.println();
        }
        this.mTarget.print("    private static final int STATE_COUNT = ");
        this.mTarget.print(stateId);
        this.mTarget.println(";");
        this.mTarget.println();
    }

    private void outputTransitionIds(SmcFSM fsm) {
        int transId = 1;
        for (SmcTransition trans : fsm.getTransitions()) {
            String transName = trans.getName();
            if (transName.equals(DEFAULT_NAME)) continue;
            String transIdName = String.format("%s%d%s", transName, trans.getIdentifier(), TRANSITION_ID_SUFFIX);
            this.mTarget.print("    private static final int ");
            this.mTarget.print(transIdName);
            this.mTarget.print(" = ");
            this.mTarget.print(transId);
            this.mTarget.println(";");
            ++transId;
        }
        this.mTarget.println();
        this.mTarget.print("    private static final int TRANSITION_COUNT = ");
        this.mTarget.print(transId);
        this.mTarget.println(";");
        this.mTarget.println();
    }

    private void outputTransitionSignatures(SmcFSM fsm) {
        this.mTarget.println("    private static final MethodType[] TRANSITION_TYPES =");
        this.mTarget.println("    {");
        this.mTarget.print("        NO_ARGS_TYPE");
        for (SmcTransition trans : fsm.getTransitions()) {
            String transName = trans.getName();
            if (transName.equals(DEFAULT_NAME)) continue;
            this.mTarget.println(",");
            List<SmcParameter> params = trans.getParameters();
            if (params.isEmpty()) {
                this.mTarget.print("        NO_ARGS_TYPE");
                continue;
            }
            this.mTarget.print("        MethodType.methodType(void.class");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(this.getJavaType(param.getType()));
                this.mTarget.print(".class");
            }
            this.mTarget.print(")");
        }
        this.mTarget.println();
        this.mTarget.println("    };");
        this.mTarget.println();
    }

    private void outputNames(SmcFSM fsm) {
        this.outputMapNames(fsm);
        this.outputStateNames(fsm);
        this.outputStateTransitions(fsm);
        this.outputTransitionNames(fsm);
    }

    private void outputMapNames(SmcFSM fsm) {
        String sep = "";
        this.mTarget.println("    private static final String[] MAP_NAMES =");
        this.mTarget.print("    {");
        for (SmcMap map : fsm.getMaps()) {
            this.mTarget.println(sep);
            this.mTarget.print("        \"");
            this.mTarget.print(map.getName());
            this.mTarget.print("\"");
            sep = ",";
        }
        this.mTarget.println();
        this.mTarget.println("    };");
        this.mTarget.println();
    }

    private void outputStateNames(SmcFSM fsm) {
        String sep0 = "";
        String sep1 = "";
        this.mTarget.println("    private static final String[][] STATE_NAMES =");
        this.mTarget.print("    {");
        for (SmcMap map : fsm.getMaps()) {
            this.mTarget.println(sep0);
            this.mTarget.println("        new String[]");
            this.mTarget.print("        {");
            for (SmcState state : map.getStates()) {
                this.mTarget.println(sep1);
                this.mTarget.print("            \"");
                this.mTarget.print(state.getInstanceName());
                this.mTarget.print("\"");
                sep1 = ",";
            }
            this.mTarget.println();
            this.mTarget.print("        }");
            sep0 = ",\n";
            sep1 = "";
        }
        this.mTarget.println();
        this.mTarget.println("    };");
        this.mTarget.println();
    }

    private void outputStateTransitions(SmcFSM fsm) {
        String sep0 = "";
        String sep1 = "";
        this.mTarget.println("    private static String[][] STATE_TRANSITIONS =");
        this.mTarget.print("    {");
        for (SmcMap map : fsm.getMaps()) {
            for (SmcState state : map.getStates()) {
                this.mTarget.println(sep0);
                this.mTarget.println("        new String[]");
                this.mTarget.print("        {");
                for (SmcTransition trans : state.getTransitions()) {
                    this.mTarget.println(sep1);
                    this.mTarget.print("            \"");
                    this.mTarget.print(trans.getName());
                    this.mTarget.print("\"");
                    sep1 = ",";
                }
                this.mTarget.println();
                this.mTarget.print("        }");
                sep0 = ",\n";
                sep1 = "";
            }
        }
        this.mTarget.println();
        this.mTarget.println("    };");
        this.mTarget.println();
    }

    private void outputTransitionNames(SmcFSM fsm) {
        String sep = ",";
        this.mTarget.println("    private static final String[] TRANSITION_NAMES =");
        this.mTarget.println("    {");
        this.mTarget.print("        \"");
        this.mTarget.print(DEFAULT_NAME);
        this.mTarget.print("\"");
        for (SmcTransition trans : fsm.getTransitions()) {
            String transName = trans.getName();
            if (DEFAULT_NAME.equals(transName)) continue;
            this.mTarget.println(",");
            this.mTarget.print("        \"");
            this.mTarget.print(transName);
            this.mTarget.print("\"");
        }
        this.mTarget.println();
        this.mTarget.println("    };");
        this.mTarget.println();
    }

    private void outputClassInit(SmcFSM fsm) {
        this.mTarget.println("    static");
        this.mTarget.println("    {");
        this.outputLocalVars(fsm);
        this.mTarget.println("        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)");
        this.mTarget.println("        {");
        this.mTarget.println("            mapName = MAP_NAMES[mapIndex];");
        this.mTarget.println("            stateSize = STATE_NAMES[mapIndex].length;");
        this.mTarget.println();
        this.outputClassInitStateLoop();
        this.mTarget.println("        }");
        this.mTarget.println("    }");
    }

    private void outputLocalVars(SmcFSM fsm) {
        this.mTarget.println("        final Lookup lookup = MethodHandles.lookup();");
        this.mTarget.print("        final Class<?> clazz = ");
        this.mTarget.print(fsm.getFsmClassName());
        this.mTarget.println(".class;");
        this.mTarget.println("        final int mapSize = MAP_NAMES.length;");
        this.mTarget.println("        int stateSize;");
        this.mTarget.println("        int mapIndex;");
        this.mTarget.println("        int stateIndex;");
        this.mTarget.println("        int transIndex;");
        this.mTarget.println("        int stateId = 0;");
        this.mTarget.println("        String mapName;");
        this.mTarget.println("        String stateName;");
        this.mTarget.println("        String transName;");
        this.mTarget.println("        String methodName;");
        this.mTarget.println("        MethodType transType;");
        this.mTarget.println("        MethodHandle entryHandle;");
        this.mTarget.println("        MethodHandle exitHandle;");
        this.mTarget.println("        TransitionHandle[] transitions;");
        this.mTarget.println();
    }

    private void outputClassInitStateLoop() {
        this.mTarget.println("            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)");
        this.mTarget.println("            {");
        this.mTarget.println("                stateName = STATE_NAMES[mapIndex][stateIndex];");
        this.mTarget.println("                transitions = new TransitionHandle[TRANSITION_COUNT];");
        this.mTarget.println();
        this.mTarget.println("                methodName = String.format(ENTRY_NAME, mapName, stateName);");
        this.mTarget.println("                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);");
        this.mTarget.println("                methodName = String.format(EXIT_NAME, mapName, stateName);");
        this.mTarget.println("                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);");
        this.mTarget.println();
        this.outputClassInitTransitions();
        this.mTarget.println("                sStates[stateId] =");
        this.mTarget.println("                    new State7(");
        this.mTarget.println("                        String.format(STATE_NAME_FORMAT, mapName, stateName),");
        this.mTarget.println("                        stateId,");
        this.mTarget.println("                        entryHandle,");
        this.mTarget.println("                        exitHandle,");
        this.mTarget.println("                        transitions,");
        this.mTarget.println("                        STATE_TRANSITIONS[stateId]);");
        this.mTarget.println("            }");
    }

    private void outputClassInitTransitions() {
        this.mTarget.println("                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)");
        this.mTarget.println("                {");
        this.mTarget.println("                    transName = TRANSITION_NAMES[transIndex];");
        this.mTarget.println("                    transType = TRANSITION_TYPES[transIndex];");
        this.mTarget.println("                    transitions[transIndex] =");
        this.mTarget.println("                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);");
        this.mTarget.println("                }");
        this.mTarget.println();
    }

    private void outputMapClasses(SmcFSM fsm) {
        for (SmcMap map : fsm.getMaps()) {
            this.mTarget.println();
            this.outputMapClass(map);
        }
    }

    private void outputMapClass(SmcMap map) {
        String mapName = map.getName();
        this.mTarget.print("    public static final class ");
        this.mTarget.println(mapName);
        this.mTarget.println("    {");
        this.mTarget.print("        private ");
        this.mTarget.print(mapName);
        this.mTarget.println("()");
        this.mTarget.println("        {}");
        this.mTarget.println();
        for (SmcState state : map.getStates()) {
            String stateName = state.getClassName();
            this.mTarget.print("        public static final State7 ");
            this.mTarget.print(stateName);
            this.mTarget.print(" = sStates[");
            this.mTarget.format("%s_%s%s", mapName, stateName, STATE_ID_SUFFIX);
            this.mTarget.println("];");
        }
        this.mTarget.println("    }");
    }

    private void outputFooter() {
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    private void outputStateActions(String mapName, String stateName, String nameFormat, List<SmcAction> actions) {
        String methodName = String.format(nameFormat, mapName, stateName);
        this.mTarget.println();
        this.mTarget.print("    private void ");
        this.mTarget.print(methodName);
        this.mTarget.println("()");
        this.mTarget.println("    {");
        for (SmcAction action : actions) {
            action.accept(this);
        }
        this.mTarget.println("    }");
    }

    private void outputTransitionGuards(SmcTransition transition, String mapName) {
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        this.mIndent = "        ";
        if (this.mGuardCount > 1 || this.mGuardCount == 1 && !guards.get(0).getCondition().isEmpty()) {
            this.mIndent = this.mIndent + "    ";
        }
        this.mTarget.println("        final int stateId = mState.getId();");
        this.mTarget.println();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals(NIL_STATE) || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            this.outputElseGuard(transition, mapName);
        }
    }

    private void outputElseGuard(SmcTransition transition, String mapName) {
        String methodName;
        SmcState currState = transition.getState();
        SmcState defaultState = currState.getMap().getDefaultState();
        List<SmcParameter> params = transition.getParameters();
        String sep = "";
        if (defaultState.findTransition(transition.getName(), params) != null) {
            methodName = mapName + "_" + DEFAULT_NAME + "_" + transition.getName();
        } else if (currState.findTransition(DEFAULT_NAME, DEFAULT_PARAMETERS) != null) {
            methodName = mapName + "_" + currState.getClassName() + "_" + DEFAULT_NAME;
            params = DEFAULT_PARAMETERS;
        } else if (defaultState.findTransition(DEFAULT_NAME, DEFAULT_PARAMETERS) != null) {
            methodName = mapName + "_" + DEFAULT_NAME + "_" + DEFAULT_NAME;
            params = DEFAULT_PARAMETERS;
        } else {
            methodName = SYSTEM_DEFAULT;
            params = DEFAULT_PARAMETERS;
        }
        this.mTarget.println();
        this.mTarget.println("        else");
        this.mTarget.println("        {");
        this.mTarget.print("            ");
        this.mTarget.print(methodName);
        this.mTarget.print("(");
        for (SmcParameter param : params) {
            this.mTarget.print(sep);
            this.mTarget.print(param.getName());
            sep = ", ";
        }
        this.mTarget.println(");");
        this.mTarget.println("        }");
        this.mTarget.println();
    }

    private void outputGuardCondition(String condition) {
        if (this.mGuardCount > 1) {
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print("        if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print("        else if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
            } else {
                this.mTarget.println();
                this.mTarget.println("        else");
            }
            this.mTarget.println("        {");
        } else if (condition.length() > 0) {
            this.mTarget.print("        if (");
            this.mTarget.print(condition);
            this.mTarget.println(")");
            this.mTarget.println("        {");
        }
    }

    private void outputStateExit(String mapName, String stateName) {
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("debugOutput(\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("\");");
            this.mTarget.println();
        }
        if (this.mDebugLevel >= 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("debugOutput(\"BEFORE EXIT     : ");
            this.mTarget.print(stateName);
            this.mTarget.println(".exit()\");");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("exitState();");
        this.mTarget.println();
        if (this.mDebugLevel >= 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("debugOutput(\"AFTER EXIT      : ");
            this.mTarget.print(stateName);
            this.mTarget.println(".exit()\");");
            this.mTarget.println();
        }
    }

    private void outputGuardBody(SmcGuard guard, SmcTransition transition, String mapName, String stateName) {
        this.outputTransitionEnter(transition, mapName, stateName);
        this.outputGuardActions(guard);
        this.outputTransitionExit(transition, mapName, stateName);
    }

    private void outputTransitionEnter(SmcTransition trans, String mapName, String stateName) {
        if (this.mDebugLevel >= 0) {
            List<SmcParameter> parameters = trans.getParameters();
            Iterator<SmcParameter> pit = parameters.iterator();
            String sep = "";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    debugOutput(\"ENTER TRANSITION: ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(trans.getName());
            this.mTarget.print('(');
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\");");
            this.mTarget.println();
        }
    }

    private void outputGuardActions(SmcGuard guard) {
        boolean hasActions;
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (!hasActions) {
            if (!guard.getCondition().isEmpty()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    // No actions.");
            }
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    clearState();");
            for (SmcAction action : actions) {
                action.accept(this);
            }
        }
    }

    private void outputTransitionExit(SmcTransition trans, String mapName, String stateName) {
        if (this.mDebugLevel >= 0) {
            List<SmcParameter> parameters = trans.getParameters();
            Iterator<SmcParameter> pit = parameters.iterator();
            String sep = "";
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    debugOutput(\"EXIT TRANSITION : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(trans.getName());
            this.mTarget.print('(');
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\");");
        }
    }

    private void outputStateEnter(String mapName, String stateName) {
        if (this.mDebugLevel >= 1) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("debugOutput(\"BEFORE ENTRY    : ");
            this.mTarget.print(stateName);
            this.mTarget.println(".entry()\");");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("enterState();");
        if (this.mDebugLevel >= 1) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("debugOutput(\"AFTER ENTRY     : ");
            this.mTarget.print(stateName);
            this.mTarget.println(".entry()\");");
        }
    }

    private String getJavaType(String s) {
        int index = s.lastIndexOf(32);
        String retval = s;
        if (index >= 0) {
            retval = s.substring(index + 1);
        }
        if ((index = retval.lastIndexOf(60)) > 0) {
            retval = retval.substring(0, index);
        }
        return retval;
    }
}

