/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcJSGenerator
extends SmcCodeGenerator {
    public SmcJSGenerator(SmcOptions options) {
        super(options, TargetLanguage.JS.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String separator;
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        List<SmcTransition> transitions = fsm.getTransitions();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String imp : fsm.getImports()) {
            this.mTarget.print("require('");
            this.mTarget.print(imp);
            this.mTarget.println("');");
        }
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(context);
        this.mTarget.println("State () {}");
        this.mTarget.print(context);
        this.mTarget.println("State.prototype = new State();");
        this.mTarget.println();
        this.mTarget.println("var _empty = function () {};");
        this.mTarget.print(context);
        this.mTarget.println("State.prototype.Entry = _empty;");
        this.mTarget.print(context);
        this.mTarget.println("State.prototype.Exit = _empty;");
        this.mTarget.println();
        this.mTarget.println("var _default = function (fsm) {");
        this.mTarget.println("    this.Default(fsm);");
        this.mTarget.println("};");
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print(context);
            this.mTarget.print("State.prototype.");
            this.mTarget.print(transName);
            this.mTarget.println(" = _default;");
        }
        this.mTarget.println();
        this.mTarget.print(context);
        this.mTarget.println("State.prototype.Default = function (fsm) {");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if (fsm.debugFlag) {");
            this.mTarget.println("        fsm.debugStream.write(\"TRANSITION      : Default\\n\");");
            this.mTarget.println("    }");
        }
        this.mTarget.println("    var msg = \"Undefined Transition\\nState: \"");
        this.mTarget.println("            + fsm.getState().name");
        this.mTarget.println("            + \"\\nTransition: \"");
        this.mTarget.println("            + fsm.transition");
        this.mTarget.println("            + \"\\n\";");
        this.mTarget.println("    throw new Error(msg);");
        this.mTarget.println("};");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(context);
            this.mTarget.println("State.prototype.getTransitions = function () {");
            this.mTarget.println("    return this.transitions;");
            this.mTarget.println("};");
            this.mTarget.println();
        }
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.println();
        int index = startState.indexOf("::");
        String javaState = index >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print("function ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" (owner) {");
        this.mTarget.print("    FSMContext.call(this, ");
        this.mTarget.print(javaState);
        this.mTarget.println(");");
        this.mTarget.println("    this.owner = owner;");
        this.mTarget.println('}');
        this.mTarget.print(fsmClassName);
        this.mTarget.println(".prototype = new FSMContext();");
        this.mTarget.println("try {");
        this.mTarget.print("    global.");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" = ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(';');
        this.mTarget.println("} catch (ex) {}");
        this.mTarget.println();
        this.mTarget.print(fsmClassName);
        this.mTarget.println(".prototype.enterStartState = function () {");
        this.mTarget.println("    this.getState().Entry(this);");
        this.mTarget.println("};");
        this.mTarget.println();
        for (SmcTransition trans : transitions) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(fsmClassName);
            this.mTarget.print(".prototype.");
            this.mTarget.print(trans.getName());
            this.mTarget.print(" = function (");
            List<SmcParameter> params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(") {");
            this.mTarget.print("    this.transition = '");
            this.mTarget.print(trans.getName());
            this.mTarget.println("';");
            this.mTarget.print("    this.getState().");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(this");
            pit = params.iterator();
            while (pit.hasNext()) {
                this.mTarget.print(", ");
                this.mTarget.print(pit.next().getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("    this.transition = '';");
            this.mTarget.println("};");
            this.mTarget.println();
        }
        if (this.mReflectFlag) {
            this.mTarget.print(fsmClassName);
            this.mTarget.println(".prototype.states = [");
            separator = "";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print(separator);
                    this.mTarget.print("    ");
                    this.mTarget.print(mapName);
                    this.mTarget.print(".");
                    this.mTarget.print(state.getClassName());
                    separator = ",\n";
                }
            }
            this.mTarget.println();
            this.mTarget.println("];");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(".prototype.getStates = function () {");
            this.mTarget.println("    return this.prototype.states;");
            this.mTarget.println("};");
            this.mTarget.println();
            this.mTarget.print(fsmClassName);
            this.mTarget.println(".prototype.transitions = [");
            separator = "";
            for (SmcTransition trans : transitions) {
                this.mTarget.print(separator);
                this.mTarget.print("    '");
                this.mTarget.print(trans.getName());
                this.mTarget.print("'");
                separator = ",\n";
            }
            this.mTarget.println();
            this.mTarget.println("];");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(".prototype.getTransitions = function () {");
            this.mTarget.println("    return this.prototype.transitions;");
            this.mTarget.println("};");
        }
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(mapName);
        this.mTarget.print("_DefaultState");
        this.mTarget.println(" (name, id) {");
        this.mTarget.println("    State.call(this, name, id);");
        this.mTarget.println("}");
        this.mTarget.print(mapName);
        this.mTarget.print("_DefaultState.prototype = new ");
        this.mTarget.print(context);
        this.mTarget.println("State();");
        this.mTarget.println();
        this.mTarget.print("var ");
        this.mTarget.print(mapName);
        this.mTarget.println(" = {};");
        this.mTarget.print(mapName);
        this.mTarget.print(".DefaultState = new ");
        this.mTarget.print(mapName);
        this.mTarget.print("_DefaultState");
        this.mTarget.print("('");
        this.mTarget.print(mapName);
        this.mTarget.print("::DefaultState', ");
        this.mTarget.print(SmcMap.getNextStateId());
        this.mTarget.println(");");
        this.mIndent = "";
        for (SmcTransition trans : definedDefaultTransitions) {
            trans.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            String separator = "";
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.println(".DefaultState.transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = definedDefaultTransitions.contains(transition) ? "2" : "0";
                this.mTarget.print(separator);
                this.mTarget.print("    '");
                this.mTarget.print(transName);
                this.mTarget.print("': ");
                this.mTarget.print(transDefinition);
                separator = ",\n";
            }
            this.mTarget.println();
            this.mTarget.println("};");
        }
        for (SmcState state : states) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.println();
        this.mTarget.print("function ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.println(" (name, id) {");
        this.mTarget.println("    State.call(this, name, id);");
        this.mTarget.println("}");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print(".prototype = ");
        this.mTarget.print(mapName);
        this.mTarget.println(".DefaultState;");
        this.mTarget.println();
        this.mTarget.print(mapName);
        this.mTarget.print('.');
        this.mTarget.print(stateName);
        this.mTarget.print(" = new ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print("('");
        this.mTarget.print(mapName);
        this.mTarget.print("::");
        this.mTarget.print(stateName);
        this.mTarget.print("', ");
        this.mTarget.print(SmcMap.getNextStateId());
        this.mTarget.println(");");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println(".Entry = function (fsm) {");
            this.mTarget.println("    var ctxt = fsm.owner;");
            this.mIndent = "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("};");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println(".Exit = function (fsm) {");
            this.mTarget.println("    var ctxt = fsm.owner;");
            this.mIndent = "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("};");
        }
        this.mIndent = "";
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            String separator = "";
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println(".transitions = {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                String transDefinition = stateTransitions.contains(transition) ? "1" : (defaultTransitions.contains(transition) ? "2" : "0");
                this.mTarget.print(separator);
                this.mTarget.print("    '");
                this.mTarget.print(transName);
                this.mTarget.print("': ");
                this.mTarget.print(transDefinition);
                separator = ",\n";
            }
            this.mTarget.println();
            this.mTarget.println("};");
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String instanceName = state.getInstanceName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        SmcGuard nullGuard = null;
        Iterator<SmcGuard> git = guards.iterator();
        this.mTarget.println();
        this.mTarget.print(mapName);
        this.mTarget.print('.');
        this.mTarget.print(instanceName);
        this.mTarget.print('.');
        this.mTarget.print(transName);
        this.mTarget.print(" = function (fsm");
        for (SmcParameter parameter : parameters) {
            this.mTarget.print(", ");
            parameter.accept(this);
        }
        this.mTarget.println(") {");
        if (transition.hasCtxtReference()) {
            this.mTarget.println("    var ctxt = fsm.owner;");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("    if (fsm.debugFlag) {");
            this.mTarget.print("        fsm.debugStream.write(\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\");");
            this.mTarget.println("    }");
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.println("    else {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print(mapName);
            this.mTarget.print(".DefaultState.");
            if (!instanceName.equals("DefaultState")) {
                this.mTarget.print(transName);
                this.mTarget.print("(fsm");
                for (SmcParameter param : parameters) {
                    this.mTarget.print(", ");
                    this.mTarget.print(param.getName());
                }
            } else {
                this.mTarget.print("Default(fsm");
            }
            this.mTarget.println(");");
            this.mTarget.println("    }");
        } else if (this.mGuardCount > 1) {
            this.mTarget.println();
        }
        this.mTarget.println("};");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator pit;
        String indent4;
        Object parameters;
        String fqEndStateName;
        String indent2;
        boolean hasActions;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        boolean bl = hasActions = !actions.isEmpty();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
        }
        if (!hasActions || !loopbackFlag) {
            fqEndStateName = endStateName;
        } else {
            fqEndStateName = "endState";
            this.mTarget.print(indent2);
            this.mTarget.print("var ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(" = fsm.getState();");
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (fsm.debugFlag) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream.write(\"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".exit()\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.getState().Exit(fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (fsm.debugFlag) {");
                this.mTarget.print(indent2);
                this.mTarget.print("    fsm.debugStream.write(\"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".exit()\\n\");");
                this.mTarget.print(indent2);
                this.mTarget.println("    }");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this.mIndent;
            if (!this.mNoCatchFlag) {
                this.mIndent = indent2;
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("if (fsm.debugFlag) {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    fsm.debugStream.write(\"ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\\n\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
            this.mIndent = indent4;
        }
        if (!hasActions) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("fsm.clearState();");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println('}');
                this.mTarget.print(indent2);
                this.mTarget.println("finally {");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            indent4 = this.mIndent;
            this.mIndent = indent3;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("if (fsm.debugFlag) {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    fsm.debugStream.write(\"EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print('.');
            this.mTarget.print(transName);
            this.mTarget.print('(');
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.print(')');
            this.mTarget.println("\\n\");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
            this.mIndent = indent4;
        }
        if (transType == SmcElement.TransType.TRANS_SET && (hasActions || !loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || hasActions) {
                this.mTarget.print(indent3);
                this.mTarget.print("fsm.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (!loopbackFlag) {
                this.mTarget.print(indent3);
                this.mTarget.println("fsm.getState().Entry(fsm);");
            }
            this.mTarget.print(indent3);
            this.mTarget.print("fsm.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (fsm.debugFlag) {");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.debugStream.write(\"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry()\\n\");");
                this.mTarget.print(indent3);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent3);
            this.mTarget.println("fsm.getState().Entry(fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent3);
                this.mTarget.println("if (fsm.debugFlag) {");
                this.mTarget.print(indent3);
                this.mTarget.print("    fsm.debugStream.write(\"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry()\\n\");");
                this.mTarget.print(indent3);
                this.mTarget.println("}");
            }
        }
        if (hasActions && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println('}');
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("fsm.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("ctxt.");
            this.mTarget.print(name);
            this.mTarget.print(" = ");
            this.mTarget.print(arguments.get(0));
            this.mTarget.println(';');
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("fsm.emptyStateStack();");
            } else {
                this.mTarget.print("ctxt.");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(");");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getName());
    }
}

