/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcGuard
extends SmcElement {
    private final SmcTransition mTransition;
    private final String mCondition;
    private SmcElement.TransType mTransType;
    private String mEndState;
    private String mPushState;
    private String mPopArgs;
    private List<SmcAction> mActions;

    public SmcGuard(String cond, int lineNumber, SmcTransition transition) {
        super(transition.getName(), lineNumber);
        this.mTransition = transition;
        this.mCondition = cond;
        this.mEndState = "";
        this.mPushState = "";
        this.mActions = null;
        this.mPopArgs = "";
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(this.mName);
        if (!this.mCondition.isEmpty()) {
            pw.print(" [");
            pw.print(this.mCondition);
            pw.print("]");
        }
        switch (this.mTransType) {
            case TRANS_NOT_SET: {
                pw.print(" not set");
                break;
            }
            case TRANS_SET: 
            case TRANS_PUSH: {
                pw.print(" set");
                break;
            }
            case TRANS_POP: {
                pw.print(" pop");
            }
        }
        pw.print(" ");
        pw.print(this.mEndState);
        if (this.mTransType == SmcElement.TransType.TRANS_PUSH) {
            pw.print("/");
            pw.print(" push(");
            pw.print(this.mPushState);
            pw.print(")");
        }
        pw.println(" {");
        if (!this.mActions.isEmpty()) {
            for (SmcAction action : this.mActions) {
                pw.print("    ");
                pw.print(action);
                pw.println(";");
            }
        }
        pw.print("}");
        return sw.toString();
    }

    public SmcTransition getTransition() {
        return this.mTransition;
    }

    public boolean hasCondition() {
        return this.mCondition != null && !this.mCondition.isEmpty();
    }

    public String getCondition() {
        return this.mCondition;
    }

    public SmcElement.TransType getTransType() {
        return this.mTransType;
    }

    public String getEndState() {
        return this.mEndState;
    }

    public String getPushState() {
        return this.mPushState;
    }

    public String getPopArgs() {
        return this.mPopArgs;
    }

    public boolean hasCtxtReference() {
        boolean retcode = false;
        if (this.mCondition != null && (this.mCondition.contains("ctxt ") || this.mCondition.contains("ctxt.") || this.mCondition.contains("ctxt->") || this.mCondition.contains("ctxt:") || this.mCondition.contains("ctxt,") || this.mCondition.contains("ctxt)")) || this.hasActions() || this.mTransType == SmcElement.TransType.TRANS_POP && this.mPopArgs != null && (this.mPopArgs.contains("ctxt ") || this.mPopArgs.contains("ctxt.") || this.mPopArgs.contains("ctxt->") || this.mPopArgs.contains("ctxt:") || this.mPopArgs.contains("ctxt,") || this.mPopArgs.contains("ctxt)"))) {
            retcode = true;
        }
        return retcode;
    }

    public boolean hasActions() {
        boolean retcode = false;
        if (this.mActions != null && !this.mActions.isEmpty()) {
            Iterator<SmcAction> ait = this.mActions.iterator();
            while (ait.hasNext() && !retcode) {
                SmcAction action = ait.next();
                retcode = !action.isEmptyStateStack();
            }
        }
        return retcode;
    }

    public List<SmcAction> getActions() {
        return this.mActions;
    }

    public void setTransType(SmcElement.TransType transType) {
        this.mTransType = transType;
    }

    public void setEndState(String endState) {
        this.mEndState = endState;
    }

    public void setPushState(String state) {
        this.mPushState = state;
    }

    public void setPopArgs(String args) {
        this.mPopArgs = args;
    }

    public void setActions(List<SmcAction> actions) {
        this.mActions = new ArrayList<SmcAction>(actions);
    }
}

