/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcVisitor;

public final class SmcAction
extends SmcElement
implements Comparable<SmcAction> {
    private static final String EMPTY_STATE_STACK = "emptystatestack";
    private List<String> mArguments;
    private boolean mPropertyFlag;
    private boolean mStaticFlag;

    public SmcAction(String name, int lineNumber) {
        super(name, lineNumber);
        this.mArguments = null;
        this.mPropertyFlag = false;
        this.mStaticFlag = false;
    }

    public SmcAction(String name, int lineNumber, boolean propertyFlag, List<String> arguments) throws IllegalArgumentException {
        super(name, lineNumber);
        if (propertyFlag && (arguments == null || arguments.size() != 1)) {
            throw new IllegalArgumentException("property must have exactly one argument");
        }
        this.mArguments = arguments;
        this.mPropertyFlag = propertyFlag;
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(SmcAction action) {
        int retval = 0;
        if (this != action && (retval = this.mName.compareTo(action.getName())) == 0) {
            Iterator<String> ait1 = this.mArguments.iterator();
            Iterator<String> ait2 = action.mArguments.iterator();
            while (ait1.hasNext() && ait2.hasNext() && retval == 0) {
                String s1 = ait1.next();
                String s2 = ait2.next();
                retval = s1.compareTo(s2);
            }
        }
        return retval;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(40);
        retval.append(this.mName);
        if (this.mPropertyFlag) {
            retval.append(" = ");
            retval.append(this.mArguments.get(0));
        } else {
            retval.append('(');
            Iterator<String> ait = this.mArguments.iterator();
            String sep = "";
            while (ait.hasNext()) {
                retval.append(sep);
                retval.append(ait.next());
                sep = ", ";
            }
            retval.append(')');
        }
        return retval.toString();
    }

    public boolean isProperty() {
        return this.mPropertyFlag;
    }

    public boolean isStatic() {
        return this.mStaticFlag;
    }

    public boolean isEmptyStateStack() {
        return EMPTY_STATE_STACK.equalsIgnoreCase(this.getName());
    }

    public List<String> getArguments() {
        return this.mArguments;
    }

    public void setProperty(boolean flag) {
        this.mPropertyFlag = flag;
    }

    public void setArguments(List<String> args) throws IllegalArgumentException {
        if (this.mPropertyFlag && (args == null || args.size() != 1)) {
            throw new IllegalArgumentException("property must have exactly one argument");
        }
        this.mArguments = new ArrayList<String>(args);
    }
}

