/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcState
extends SmcElement {
    public static final String DEFAULT_STATE = "DefaultState";
    private final SmcMap mMap;
    private final String mClassName;
    private final String mInstanceName;
    private List<SmcAction> mEntryActions;
    private List<SmcAction> mExitActions;
    private final List<SmcTransition> mTransitions;

    public SmcState(String name, int lineNumber, SmcMap map) {
        super(name, lineNumber);
        this.mMap = map;
        this.mInstanceName = name.compareToIgnoreCase("Default") == 0 ? DEFAULT_STATE : name;
        this.mClassName = name;
        this.mEntryActions = null;
        this.mExitActions = null;
        this.mTransitions = new ArrayList<SmcTransition>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.mInstanceName);
        if (this.mEntryActions != null && !this.mEntryActions.isEmpty()) {
            retval.append("\n\tEntry {");
            for (SmcAction action : this.mEntryActions) {
                retval.append(action);
                retval.append('\n');
            }
            retval.append("}");
        }
        if (this.mExitActions != null && !this.mExitActions.isEmpty()) {
            retval.append("\n\tExit {");
            for (SmcAction action : this.mExitActions) {
                retval.append(action);
                retval.append('\n');
            }
            retval.append("}");
        }
        for (SmcTransition transition : this.mTransitions) {
            retval.append("\n");
            retval.append(transition);
        }
        return retval.toString();
    }

    public SmcMap getMap() {
        return this.mMap;
    }

    @Override
    public String getName() {
        return this.mClassName + "." + this.mInstanceName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public boolean isDefaultState() {
        return this.mInstanceName.equals(DEFAULT_STATE);
    }

    public List<SmcAction> getEntryActions() {
        return this.mEntryActions;
    }

    public List<SmcAction> getExitActions() {
        return this.mExitActions;
    }

    public List<SmcTransition> getTransitions() {
        return this.mTransitions;
    }

    public SmcTransition findTransition(String name, List<SmcParameter> parameters) {
        Iterator<SmcTransition> transIt = this.mTransitions.iterator();
        SmcTransition retval = null;
        while (transIt.hasNext() && retval == null) {
            SmcTransition transition = transIt.next();
            if (!name.equals(transition.getName()) || transition.compareTo(name, parameters) != 0) continue;
            retval = transition;
        }
        return retval;
    }

    public SmcGuard findGuard(String name, String condition) {
        for (SmcTransition transition : this.mTransitions) {
            if (!name.equals(transition.getName())) continue;
            for (SmcGuard guard : transition.getGuards()) {
                if (!condition.equals(guard.getCondition())) continue;
                return guard;
            }
        }
        return null;
    }

    public boolean callDefault(String name) {
        for (SmcTransition transition : this.mTransitions) {
            if (!name.equals(transition.getName())) continue;
            for (SmcGuard guard : transition.getGuards()) {
                if (!guard.getCondition().isEmpty()) continue;
                return false;
            }
            return true;
        }
        for (SmcTransition transition : this.mTransitions) {
            if (!transition.getName().equals("Default")) continue;
            return false;
        }
        return true;
    }

    public void setEntryActions(List<SmcAction> actions) {
        this.mEntryActions = new ArrayList<SmcAction>(actions);
    }

    public void setExitActions(List<SmcAction> actions) {
        this.mExitActions = new ArrayList<SmcAction>(actions);
    }

    public void addTransition(SmcTransition transition) {
        if (!this.mTransitions.contains(transition)) {
            this.mTransitions.add(transition);
        }
    }
}

