/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcVisitor;

public final class SmcParameter
extends SmcElement
implements Comparable<SmcParameter> {
    public static final String TCL_VALUE_TYPE = "value";
    public static final String TCL_REFERENCE_TYPE = "reference";
    private String mType;

    public SmcParameter(String name, int lineNumber, String type) {
        super(name, lineNumber);
        this.mType = type;
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(SmcParameter param) throws ClassCastException {
        int retval = this.mName.compareTo(param.mName);
        if (retval == 0) {
            retval = this.mType.compareTo(param.mType);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean retval;
        boolean bl = retval = this == obj;
        if (!retval && obj instanceof SmcParameter) {
            SmcParameter parameter = (SmcParameter)obj;
            retval = this.mName.equals(parameter.mName) && this.mType.equals(parameter.mType);
        }
        return retval;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.mName);
        if (!this.mType.isEmpty()) {
            retval.append(": ");
            retval.append(this.mType);
        }
        return retval.toString();
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String typeName) {
        this.mType = typeName.trim();
    }
}

