/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sido.gen.maven;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.sido.gen.GenerationConfiguration;
import net.sf.sido.gen.GenerationInput;
import net.sf.sido.gen.GenerationTool;
import net.sf.sido.gen.model.GenerationListener;
import net.sf.sido.gen.model.GenerationOutput;
import net.sf.sido.gen.model.Options;
import net.sf.sido.gen.model.support.DirectoryGenerationOutput;
import net.sf.sido.gen.model.support.MapOptions;
import net.sf.sido.gen.support.FileGenerationInput;
import net.sf.sido.gen.support.GenerationConfigurationBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class GenerationMojo
extends AbstractMojo {
    private MavenProject project;
    private String model;
    private File sourceDirectory;
    private File outputDirectory;
    private File registrationDirectory;
    private boolean test = false;
    private Map<String, String> options = Collections.emptyMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set sidolFiles;
        this.log("SiDO generation.", new Object[0]);
        this.log("Model: %s", this.model);
        try {
            Set includedSources;
            SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(Collections.singleton("**/*.sidol"), Collections.emptySet());
            scan.addSourceMapping((SourceMapping)new SuffixMapping(".sidol", Collections.emptySet()));
            sidolFiles = includedSources = scan.getIncludedSources(this.sourceDirectory, null);
        }
        catch (InclusionScanException ex) {
            throw new MojoExecutionException("Cannot get the list of SiDOL files", (Exception)((Object)ex));
        }
        if (sidolFiles.isEmpty()) {
            this.log("No SiDOL file has been found in %s", this.sourceDirectory);
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.log("List of files to include:", new Object[0]);
            for (File sidolFile : sidolFiles) {
                this.log(" * %s", sidolFile.getPath());
            }
        }
        ClassLoader formerClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Set artifacts = this.project.getArtifacts();
            this.log("Adding all artifacts to the plug-in class path:", new Object[0]);
            for (Artifact artifact : artifacts) {
                URL artifactURL = artifact.getFile().toURI().toURL();
                this.log(" * %s [%s]", artifactURL, artifact.getScope());
                urls.add(artifactURL);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot set the classpath for the dependencies", ex);
        }
        URLClassLoader depLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), formerClassLoader){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                GenerationMojo.this.log("[CL] findClass: %s", name);
                return super.findClass(name);
            }

            @Override
            public URL findResource(String name) {
                GenerationMojo.this.log("[CL] findResource: %s", name);
                return super.findResource(name);
            }
        };
        Collection sidolInputs = Collections2.transform((Collection)sidolFiles, (Function)new Function<File, GenerationInput>(){

            public GenerationInput apply(File file) {
                return new FileGenerationInput(file);
            }
        });
        DirectoryGenerationOutput output = new DirectoryGenerationOutput(this.outputDirectory);
        this.log("Former class loader is: %s", formerClassLoader);
        try {
            this.log("Using class loader: %s", depLoader);
            Thread.currentThread().setContextClassLoader(depLoader);
            this.log("Actual class loader set: %s", Thread.currentThread().getContextClassLoader());
            GenerationTool tool = new GenerationTool();
            GenerationConfigurationBuilder configurationBuilder = GenerationConfigurationBuilder.create().modelId(this.model).sources(sidolInputs).output((GenerationOutput)output).options((Options)new MapOptions(this.options));
            if (this.registrationDirectory != null) {
                configurationBuilder.registrationOutput((GenerationOutput)new DirectoryGenerationOutput(this.registrationDirectory));
            }
            GenerationConfiguration configuration = configurationBuilder.build();
            GenerationListener toolListener = new GenerationListener(){

                public void log(String pattern, Object ... params) {
                    GenerationMojo.this.log(pattern, params);
                }
            };
            try {
                tool.generate(configuration, toolListener);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot proceed with generation", (Exception)e);
            }
            if (this.test) {
                this.project.addTestCompileSourceRoot(this.outputDirectory.getPath());
            } else {
                this.project.addCompileSourceRoot(this.outputDirectory.getPath());
            }
            Resource resource = new Resource();
            resource.setDirectory(this.registrationDirectory.getPath());
            resource.setFiltering(false);
            if (this.test) {
                this.project.addTestResource(resource);
            } else {
                this.project.addResource(resource);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(formerClassLoader);
        }
    }

    protected void log(String pattern, Object ... params) {
        this.getLog().info((CharSequence)String.format(pattern, params));
    }
}

