/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.setting;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.InvalidPathException;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.TypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubSettingsProxy
implements Settings,
Comparable<SubSettingsProxy> {
    public static final String SUB_SETTING_NAME = "subSettingName";
    private Settings parent;
    private String baseKey;
    private int index;

    public SubSettingsProxy(Settings parentSettings, String prefix) {
        this(parentSettings, prefix, -1);
    }

    public SubSettingsProxy(Settings parentSettings, String prefix, int i) {
        this.parent = parentSettings;
        this.index = i;
        this.baseKey = this.index >= 0 ? prefix + "_" + this.index + "." : prefix + ".";
    }

    public int getIndex() {
        return this.index;
    }

    public void clear() {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Iterator<String> iter = this.parent.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(this.baseKey)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.parent.removeProperty(key);
        }
    }

    public void copyValues(Settings other) {
        if (other == this.parent) {
            throw new IllegalArgumentException("Cannot copy values from parent");
        }
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<String> iter = other.getKeys();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        for (String key : keys) {
            if (SUB_SETTING_NAME.equals(key)) continue;
            String value = other.getPropertyAsInternalString(key);
            this.setPropertyAsInternalString(key, value);
        }
    }

    public void dump() {
        System.out.println("----- Sub settings: " + this.baseKey + ", index=" + this.index);
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            System.out.println(" * " + key + " = " + this.getPropertyAsInternalString(key));
        }
    }

    private String getFullKey(String key) {
        return this.baseKey + key;
    }

    String getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.getStringProperty(SUB_SETTING_NAME, "?");
    }

    public void setName(String newName) {
        this.setStringProperty(SUB_SETTING_NAME, newName);
    }

    @Override
    public int compareTo(SubSettingsProxy other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.getName().equals(((SubSettingsProxy)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getPropertyAsInternalString(String key) {
        return this.parent.getPropertyAsInternalString(this.getFullKey(key));
    }

    @Override
    public void setPropertyAsInternalString(String key, String value) {
        this.parent.setPropertyAsInternalString(this.getFullKey(key), value);
    }

    @Override
    public <T> T getProperty(String key, TypeHelper<T> helper, T defaultValue) {
        return this.parent.getProperty(this.getFullKey(key), helper, defaultValue);
    }

    @Override
    public <T> void setProperty(String key, TypeHelper<T> helper, T value) {
        this.parent.setProperty(this.getFullKey(key), helper, value);
    }

    @Override
    public String getPropertyFilePath() {
        return this.parent.getPropertyFilePath();
    }

    @Override
    public FilePathUtils getFilePathUtils() {
        return this.parent.getFilePathUtils();
    }

    @Override
    public void load() throws IOException {
        this.parent.load();
    }

    @Override
    public void save() throws IOException {
        this.parent.save();
    }

    @Override
    public void setPropertyFile(File fil) {
        this.parent.setPropertyFile(fil);
    }

    @Override
    public void saveAs(File fil) throws IOException {
        this.parent.saveAs(fil);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.parent.containsProperty(this.getFullKey(key));
    }

    @Override
    public String getStringProperty(String key, String defaultValue) {
        return this.parent.getStringProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setStringProperty(String key, String value) {
        this.parent.setStringProperty(this.getFullKey(key), value);
    }

    @Override
    public String getPasswordProperty(String key, String defaultValue) {
        return this.parent.getPasswordProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setPasswordProperty(String key, String value) {
        this.parent.setPasswordProperty(this.getFullKey(key), value);
    }

    @Override
    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        return this.parent.getStringArrayProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setStringArrayProperty(String key, String[] value) {
        this.parent.setStringArrayProperty(this.getFullKey(key), value);
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        return this.parent.getIntProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setIntProperty(String key, int value) {
        this.parent.setIntProperty(this.getFullKey(key), value);
    }

    @Override
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        return this.parent.getIntegerProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setIntegerProperty(String key, Integer value) {
        this.parent.setIntegerProperty(this.getFullKey(key), value);
    }

    @Override
    public double getDoubleProperty(String key, double defaultValue) {
        return this.parent.getDoubleProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setDoubleProperty(String key, double value) {
        this.parent.setDoubleProperty(this.getFullKey(key), value);
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return this.parent.getBooleanProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        this.parent.setBooleanProperty(this.getFullKey(key), value);
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        return this.parent.getBooleanProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setBooleanProperty(String key, Boolean value) {
        this.parent.setBooleanProperty(this.getFullKey(key), value);
    }

    @Override
    public int[] getIntArrayProperty(String key, int[] defaultValue) {
        return this.parent.getIntArrayProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setIntArrayProperty(String key, int[] value) {
        this.parent.setIntArrayProperty(this.getFullKey(key), value);
    }

    @Override
    public Rectangle getRectangleProperty(String key, Rectangle defaultValue) {
        return this.parent.getRectangleProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setRectangleProperty(String key, Rectangle value) {
        this.parent.setRectangleProperty(this.getFullKey(key), value);
    }

    @Override
    public Dimension getDimensionProperty(String key, Dimension defaultValue) {
        return this.parent.getDimensionProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setDimensionProperty(String key, Dimension value) {
        this.parent.setDimensionProperty(this.getFullKey(key), value);
    }

    @Override
    public Color getColorProperty(String key, Color defaultValue) {
        return this.parent.getColorProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public void setColorProperty(String key, Color value) {
        this.parent.setColorProperty(this.getFullKey(key), value);
    }

    @Override
    public <T extends Enum<T>> T getEnumProperty(String key, T defaultValue) {
        return this.parent.getEnumProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public <T extends Enum<T>> void setEnumProperty(String key, T value) {
        this.parent.setEnumProperty(this.getFullKey(key), value);
    }

    @Override
    public String getFileProperty(String key, String defaultValue) {
        return this.parent.getFileProperty(this.getFullKey(key), defaultValue);
    }

    @Override
    public String getFileProperty(String key, String defaultValue, boolean absolute) {
        return this.parent.getFileProperty(this.getFullKey(key), defaultValue, absolute);
    }

    @Override
    public void setFileProperty(String key, String value) throws InvalidPathException {
        this.parent.setFileProperty(this.getFullKey(key), value);
    }

    @Override
    public void addPropertyChangeListener(String settingKey, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void removePropertyChangeListener(String settingKey, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<String> getKeys() {
        return new SubIterator(this.parent.getKeys());
    }

    @Override
    public void removeProperty(String key) {
        this.parent.removeProperty(this.getFullKey(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubIterator
    implements Iterator<String> {
        private Iterator<String> parentIter;
        private String next;

        SubIterator(Iterator<String> p) {
            this.parentIter = p;
            this.getNext();
        }

        private void getNext() {
            this.next = null;
            String base = SubSettingsProxy.this.getBaseKey();
            while (this.parentIter.hasNext() && this.next == null) {
                String key = this.parentIter.next();
                if (!key.startsWith(base)) continue;
                this.next = key.substring(base.length());
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String n = this.next;
            this.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported from sub-context iterator");
        }
    }
}

