/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.setting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SubSettingsProxy;
import net.sf.sfac.utils.Comparison;

public class SubSettingsList
implements ListModel,
ComboBoxModel {
    private Settings parent;
    private String keyPrefix;
    private List<SubSettingsProxy> subSettings;
    private List<ListDataListener> listeners;
    private Object selected;

    public SubSettingsList(Settings sett, String prefix) {
        this.parent = sett;
        this.keyPrefix = prefix;
        this.subSettings = new ArrayList<SubSettingsProxy>();
        this.initProxies();
    }

    public void synchronizeWithSettings() {
        this.subSettings.clear();
        this.initProxies();
    }

    private void initProxies() {
        for (int index : this.parent.getIntArrayProperty(this.keyPrefix + ".indexes", new int[0])) {
            this.subSettings.add(new SubSettingsProxy(this.parent, this.keyPrefix, index));
        }
        this.fireDataChanged();
    }

    public Settings getSubSettingAt(int i) {
        return this.subSettings.get(i);
    }

    public Settings addSubSetting() {
        return this.addSubSetting(this.subSettings.size(), null);
    }

    public Settings addSubSetting(int indexInList) {
        return this.addSubSetting(indexInList, null);
    }

    public Settings addSubSetting(int indexInList, String subSettingName) {
        int newIndex = this.getMaxIndex() + 1;
        SubSettingsProxy sett = new SubSettingsProxy(this.parent, this.keyPrefix, newIndex);
        this.subSettings.add(indexInList, sett);
        if (Comparison.isDefined(subSettingName)) {
            sett.setName(subSettingName);
        }
        this.sort();
        return sett;
    }

    public void removeSubSettings(Settings subSett) {
        SubSettingsProxy sett = (SubSettingsProxy)subSett;
        sett.clear();
        this.subSettings.remove(sett);
        if (this.selected == sett) {
            this.selected = null;
        }
        this.synchSettingIndexes();
        this.fireDataChanged();
    }

    public void removeSubSettingAt(int i) {
        SubSettingsProxy sett = this.subSettings.get(i);
        sett.clear();
        this.subSettings.remove(i);
        if (this.selected == sett) {
            this.selected = null;
        }
        this.synchSettingIndexes();
        this.fireDataChanged();
    }

    public void clear() {
        Iterator<String> iter = this.parent.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(this.keyPrefix)) continue;
            this.parent.removeProperty(key);
        }
        this.subSettings.clear();
        this.synchSettingIndexes();
        this.fireDataChanged();
    }

    private int getMaxIndex() {
        int max = -1;
        for (SubSettingsProxy sett : this.subSettings) {
            if (max >= sett.getIndex()) continue;
            max = sett.getIndex();
        }
        return max;
    }

    private void synchSettingIndexes() {
        int nbrSett = this.subSettings.size();
        int[] indexes = new int[nbrSett];
        for (int i = 0; i < nbrSett; ++i) {
            SubSettingsProxy sett = this.subSettings.get(i);
            indexes[i] = sett.getIndex();
        }
        this.parent.setIntArrayProperty(this.keyPrefix + ".indexes", indexes);
    }

    public void sort() {
        Collections.sort(this.subSettings);
        this.synchSettingIndexes();
        this.fireDataChanged();
    }

    public Object getElementAt(int index) {
        return this.subSettings.get(index);
    }

    public int getSize() {
        return this.subSettings.size();
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object anItem) {
        this.selected = anItem;
    }

    public void addListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListDataListener>();
        }
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireDataChanged() {
        if (this.listeners != null) {
            ListDataEvent ev = new ListDataEvent(this, 0, 0, this.subSettings.size());
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(ev);
            }
        }
    }

    public void fireSelectionChanged() {
        if (this.listeners != null) {
            ListDataEvent ev = new ListDataEvent(this, 0, -1, -1);
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(ev);
            }
        }
    }
}

