/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.setting;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.FileUtils;
import net.sf.sfac.file.InvalidPathException;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.TypeHelper;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsImpl
implements Settings {
    private static Log log = LogFactory.getLog(SettingsImpl.class);
    public static final TypeHelper<String> STRING_HELPER = new StringHelper();
    public static final TypeHelper<String> PASSWORD_HELPER = new PasswordHelper();
    public static final TypeHelper<String[]> STRING_ARRAY_HELPER = new StringArrayHelper();
    public static final TypeHelper<Integer> INTEGER_HELPER = new IntegerHelper();
    public static final TypeHelper<Boolean> BOOLEAN_HELPER = new BooleanHelper();
    public static final TypeHelper<Double> DOUBLE_HELPER = new DoubleHelper();
    public static final TypeHelper<int[]> INT_ARRAY_HELPER = new IntArrayHelper();
    public static final TypeHelper<Rectangle> RECTANGLE_HELPER = new RectangleHelper();
    public static final TypeHelper<Dimension> DIMENSION_HELPER = new DimensionHelper();
    public static final TypeHelper<Color> COLOR_HELPER = new ColorHelper();
    private static Map<Class<?>, EnumHelper<?>> enumHelpers;
    private final TypeHelper<String> FILE_HELPER = new FileHelper();
    private File propFile;
    private String fileDescription;
    private Properties props;
    private HashMap<String, TypedValueHolder<?>> cache;
    private PropertyChangeSupport changeSupport;
    private FilePathUtils pathConverter;

    public SettingsImpl(File propertyFile, String descr) {
        if (propertyFile == null) {
            throw new IllegalArgumentException("Property file cannot be null");
        }
        this.propFile = propertyFile.getAbsoluteFile();
        this.fileDescription = descr;
        this.props = new OrderedProperties();
        this.cache = new HashMap();
        this.pathConverter = new FilePathUtils(this.propFile.getParentFile());
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public String getPropertyFilePath() {
        return this.propFile.getAbsolutePath();
    }

    public String getDescription() {
        return this.fileDescription;
    }

    public void setDescription(String newDescr) {
        this.fileDescription = newDescr;
    }

    @Override
    public FilePathUtils getFilePathUtils() {
        return this.pathConverter;
    }

    @Override
    public void load() throws IOException {
        this.props.clear();
        this.cache.clear();
        if (this.propFile.exists()) {
            FileInputStream is = new FileInputStream(this.propFile);
            this.props.load(is);
            is.close();
        }
    }

    @Override
    public void save() throws IOException {
        log.info((Object)("Saving settings in file: " + this.propFile));
        this.synchronizeCache();
        FileUtils.ensureParentDirectoryExists(this.propFile);
        FileOutputStream out = new FileOutputStream(this.propFile);
        this.props.store(out, this.fileDescription);
        ((OutputStream)out).close();
    }

    private void synchronizeCache() {
        for (String key : this.cache.keySet()) {
            TypedValueHolder<?> holder = this.cache.get(key);
            String stringValue = holder.getStringValue();
            if (Comparison.isDefined(stringValue)) {
                this.props.setProperty(key, stringValue);
                continue;
            }
            this.props.remove(key);
        }
    }

    @Override
    public void setPropertyFile(File fil) {
        for (String key : this.cache.keySet()) {
            TypedValueHolder<?> holder = this.cache.get(key);
            this.props.setProperty(key, holder.getStringValue());
        }
        this.propFile = fil.getAbsoluteFile();
        this.cache.clear();
        File parentDir = this.propFile.getParentFile();
        this.pathConverter = new FilePathUtils(parentDir);
    }

    @Override
    public void saveAs(File fil) throws IOException {
        this.setPropertyFile(fil);
        FileUtils.ensureParentDirectoryExists(this.propFile);
        FileOutputStream out = new FileOutputStream(this.propFile);
        this.props.store(out, this.fileDescription);
        ((OutputStream)out).close();
    }

    private <T> T getCachedValue(String key, TypeHelper<T> helper) {
        TypedValueHolder<Object> holder = this.cache.get(key);
        if (holder != null) {
            return (T)holder.getValue(helper);
        }
        String propValue = this.props.getProperty(key, null);
        if (propValue != null) {
            if (helper != null) {
                holder = new TypedValueHolder<T>(helper);
                try {
                    T value = helper.stringToObject(propValue);
                    holder.setValue(helper, value);
                    this.cache.put(key, holder);
                    return value;
                }
                catch (Exception e) {
                    log.warn((Object)("Bad property " + key + "='" + propValue + "' for type " + helper), (Throwable)e);
                }
            } else {
                return (T)propValue;
            }
        }
        return null;
    }

    private <T> void setCachedValue(String key, TypeHelper<T> helper, T value) {
        if (value == null) {
            this.removeProperty(key, helper);
        } else {
            T oldValue = this.getCachedValue(key, helper);
            if (!value.equals(oldValue)) {
                TypedValueHolder<Object> holder;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New value set for setting '" + key + "' -> " + value));
                }
                if ((holder = this.cache.get(key)) != null) {
                    holder.setValue(helper, value);
                } else {
                    holder = new TypedValueHolder<T>(helper);
                    holder.setValue(helper, value);
                    this.cache.put(key, holder);
                }
                if (this.changeSupport.hasListeners(key)) {
                    this.changeSupport.firePropertyChange(key, oldValue, value);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Equals value set for setting '" + key + "' -> " + value));
            }
        }
    }

    @Override
    public boolean containsProperty(String key) {
        return this.cache.containsKey(key) || this.props.containsKey(key);
    }

    @Override
    public Iterator<String> getKeys() {
        this.synchronizeCache();
        return this.props.stringPropertyNames().iterator();
    }

    @Override
    public void removeProperty(String key) {
        this.removeProperty(key, null);
    }

    private <T> void removeProperty(String key, TypeHelper<T> helper) {
        T oldValue = this.getCachedValue(key, helper);
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
        if (this.props.containsKey(key)) {
            this.props.remove(key);
        }
        if (oldValue != null && this.changeSupport.hasListeners(key)) {
            this.changeSupport.firePropertyChange(key, oldValue, null);
        }
    }

    @Override
    public String getPropertyAsInternalString(String key) {
        TypedValueHolder<?> holder = this.cache.get(key);
        if (holder != null) {
            return holder.getStringValue();
        }
        return this.props.getProperty(key, null);
    }

    @Override
    public void setPropertyAsInternalString(String key, String value) {
        if (value == null) {
            this.removeProperty(key);
        } else {
            try {
                Object oldValue = this.getCachedValue(key, null);
                if (!value.equals(oldValue)) {
                    TypedValueHolder<?> holder;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("New internal value set for setting '" + key + "' -> " + value));
                    }
                    if ((holder = this.cache.get(key)) != null) {
                        holder.setStringValue(value);
                    } else {
                        this.props.setProperty(key, value);
                    }
                    if (this.changeSupport.hasListeners(key)) {
                        this.changeSupport.firePropertyChange(key, oldValue, value);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Equals internal value set for setting '" + key + "' -> " + value));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid internal value '" + value + "' for key: " + key, e);
            }
        }
    }

    @Override
    public <T> T getProperty(String key, TypeHelper<T> helper, T defaultValue) {
        if (helper == null) {
            throw new IllegalArgumentException("Helper cannot be null");
        }
        T val = this.getCachedValue(key, helper);
        return val == null ? defaultValue : val;
    }

    @Override
    public <T> void setProperty(String key, TypeHelper<T> helper, T value) {
        if (value == null) {
            this.removeProperty(key, helper);
        } else {
            if (helper == null) {
                throw new IllegalArgumentException("Helper cannot be null");
            }
            this.setCachedValue(key, helper, value);
        }
    }

    @Override
    public String getStringProperty(String key, String defaultValue) {
        String val = this.getCachedValue(key, STRING_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setStringProperty(String key, String value) {
        this.setCachedValue(key, STRING_HELPER, value);
    }

    @Override
    public String getPasswordProperty(String key, String defaultValue) {
        String val = this.getCachedValue(key, PASSWORD_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setPasswordProperty(String key, String value) {
        this.setCachedValue(key, PASSWORD_HELPER, value);
    }

    @Override
    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        String[] val = this.getCachedValue(key, STRING_ARRAY_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setStringArrayProperty(String key, String[] value) {
        this.setCachedValue(key, STRING_ARRAY_HELPER, value);
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        Integer val = this.getCachedValue(key, INTEGER_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setIntProperty(String key, int value) {
        this.setCachedValue(key, INTEGER_HELPER, value);
    }

    @Override
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        Integer val = this.getCachedValue(key, INTEGER_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setIntegerProperty(String key, Integer value) {
        this.setCachedValue(key, INTEGER_HELPER, value);
    }

    @Override
    public double getDoubleProperty(String key, double defaultValue) {
        Double val = this.getCachedValue(key, DOUBLE_HELPER);
        return val == null ? defaultValue : (double)val.intValue();
    }

    @Override
    public void setDoubleProperty(String key, double value) {
        this.setCachedValue(key, DOUBLE_HELPER, new Double(value));
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Boolean val = this.getCachedValue(key, BOOLEAN_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        this.setCachedValue(key, BOOLEAN_HELPER, value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        Boolean val = this.getCachedValue(key, BOOLEAN_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setBooleanProperty(String key, Boolean value) {
        this.setCachedValue(key, BOOLEAN_HELPER, value);
    }

    @Override
    public int[] getIntArrayProperty(String key, int[] defaultValue) {
        int[] val = this.getCachedValue(key, INT_ARRAY_HELPER);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting value " + key + "=" + Arrays.toString(val)));
        }
        return val == null ? defaultValue : val;
    }

    @Override
    public void setIntArrayProperty(String key, int[] value) {
        this.setCachedValue(key, INT_ARRAY_HELPER, value);
    }

    @Override
    public Rectangle getRectangleProperty(String key, Rectangle defaultValue) {
        Rectangle val = this.getCachedValue(key, RECTANGLE_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setRectangleProperty(String key, Rectangle value) {
        this.setCachedValue(key, RECTANGLE_HELPER, value);
    }

    @Override
    public Dimension getDimensionProperty(String key, Dimension defaultValue) {
        Dimension val = this.getCachedValue(key, DIMENSION_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setDimensionProperty(String key, Dimension value) {
        this.setCachedValue(key, DIMENSION_HELPER, value);
    }

    @Override
    public Color getColorProperty(String key, Color defaultValue) {
        Color val = this.getCachedValue(key, COLOR_HELPER);
        return val == null ? defaultValue : val;
    }

    @Override
    public void setColorProperty(String key, Color value) {
        this.setCachedValue(key, COLOR_HELPER, value);
    }

    @Override
    public <T extends Enum<T>> T getEnumProperty(String key, T defaultValue) {
        T val = this.getCachedValue(key, this.getEnumHelper(defaultValue));
        return val == null ? defaultValue : val;
    }

    @Override
    public <T extends Enum<T>> void setEnumProperty(String key, T value) {
        this.setCachedValue(key, value == null ? null : this.getEnumHelper(value), value);
    }

    private <T extends Enum<T>> EnumHelper<T> getEnumHelper(T enumValue) {
        EnumHelper<Object> helper;
        if (enumValue == null) {
            throw new IllegalArgumentException("Default values of 'enum' settings cannot be null");
        }
        Class<T> enumClass = enumValue.getDeclaringClass();
        if (enumHelpers == null) {
            enumHelpers = new HashMap();
        }
        if ((helper = enumHelpers.get(enumClass)) == null) {
            helper = new EnumHelper<T>(enumClass);
            enumHelpers.put(enumClass, helper);
        }
        return helper;
    }

    @Override
    public String getFileProperty(String key, String defaultValue) {
        return this.getFileProperty(key, defaultValue, true);
    }

    @Override
    public String getFileProperty(String key, String defaultValue, boolean absolute) {
        String path = absolute ? this.getCachedValue(key, this.FILE_HELPER) : this.props.getProperty(key, null);
        if (path == null) {
            try {
                path = absolute ? this.pathConverter.getAbsoluteFilePath(defaultValue) : this.pathConverter.getRelativeFilePath(defaultValue);
            }
            catch (InvalidPathException ipe) {
                throw new IllegalArgumentException(ipe.getMessage());
            }
        }
        return path;
    }

    @Override
    public void setFileProperty(String key, String value) throws InvalidPathException {
        String absolutePath = this.pathConverter.getAbsoluteFilePath(value);
        String relativePath = this.pathConverter.getRelativeFilePath(value);
        this.setCachedValue(key, this.FILE_HELPER, absolutePath);
        if (value != null) {
            this.props.setProperty(key, relativePath);
        }
    }

    @Override
    public void addPropertyChangeListener(String settingKey, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(settingKey, listener);
    }

    @Override
    public void removePropertyChangeListener(String settingKey, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(settingKey, listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 5669742785337439143L;

        OrderedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Vector<Object> keys = new Vector<Object>(this.keySet());
            Collections.sort(keys);
            return keys.elements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypedValueHolder<T> {
        private TypeHelper<T> helper;
        private T value;

        TypedValueHolder(TypeHelper<T> typHelper) {
            this.helper = typHelper;
        }

        public T getValue(TypeHelper<T> typHelper) {
            if (typHelper != null && typHelper != this.helper) {
                throw new IllegalArgumentException("Wrong Setting type: <" + typHelper + "> type <" + this.helper + "> expected for value '" + this.value + "'");
            }
            return this.value;
        }

        public void setValue(TypeHelper<T> typHelper, T val) {
            if (typHelper != this.helper) {
                throw new IllegalArgumentException("Wrong Setting type: <" + typHelper + "> type <" + this.helper + "> expected for value '" + val + "'");
            }
            this.value = val;
        }

        public void setStringValue(String stringVal) throws Exception {
            this.value = this.helper.stringToObject(stringVal);
        }

        public String getStringValue() {
            return this.helper.objectToString(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileHelper
    extends TypeHelper<String> {
        FileHelper() {
        }

        @Override
        public String stringToObject(String str) throws InvalidPathException {
            return SettingsImpl.this.getFilePathUtils().getAbsoluteFilePath(str);
        }

        @Override
        public String objectToString(String obj) {
            try {
                return SettingsImpl.this.getFilePathUtils().getRelativeFilePath(obj);
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException("Invalid path " + obj, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnumHelper<T extends Enum<T>>
    extends TypeHelper<T> {
        private T[] enumValues;

        public EnumHelper(Class<T> enumClass) {
            this.enumValues = (Enum[])enumClass.getEnumConstants();
        }

        @Override
        public T stringToObject(String str) {
            if (str == null) {
                return null;
            }
            for (T e : this.enumValues) {
                if (!str.equals(((Enum)e).name())) continue;
                return e;
            }
            return null;
        }

        @Override
        public String objectToString(T e) {
            if (e == null) {
                return null;
            }
            return ((Enum)e).name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColorHelper
    extends TypeHelper<Color> {
        ColorHelper() {
        }

        @Override
        public Color stringToObject(String str) throws Exception {
            if (str == null) {
                return null;
            }
            int rgb = Integer.parseInt(str, 16);
            return new Color(rgb);
        }

        @Override
        public String objectToString(Color obj) {
            if (obj == null) {
                return null;
            }
            Color col = obj;
            int rgb = col.getRGB();
            return Integer.toHexString(rgb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DimensionHelper
    extends TypeHelper<Dimension> {
        DimensionHelper() {
        }

        @Override
        public Dimension stringToObject(String str) throws Exception {
            if (str == null) {
                return null;
            }
            int[] arr = INT_ARRAY_HELPER.stringToObject(str);
            return new Dimension(arr[0], arr[1]);
        }

        @Override
        public String objectToString(Dimension obj) {
            if (obj == null) {
                return null;
            }
            Dimension dim = obj;
            int[] value = new int[]{dim.width, dim.height};
            return INT_ARRAY_HELPER.objectToString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RectangleHelper
    extends TypeHelper<Rectangle> {
        RectangleHelper() {
        }

        @Override
        public Rectangle stringToObject(String str) throws Exception {
            if (str == null) {
                return null;
            }
            int[] arr = INT_ARRAY_HELPER.stringToObject(str);
            return new Rectangle(arr[0], arr[1], arr[2], arr[3]);
        }

        @Override
        public String objectToString(Rectangle obj) {
            if (obj == null) {
                return null;
            }
            Rectangle rect = obj;
            int[] value = new int[]{rect.x, rect.y, rect.width, rect.height};
            return INT_ARRAY_HELPER.objectToString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntArrayHelper
    extends TypeHelper<int[]> {
        IntArrayHelper() {
        }

        @Override
        public int[] stringToObject(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(str, ", ");
            int len = st.countTokens();
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = Integer.parseInt(st.nextToken());
            }
            return result;
        }

        @Override
        public String objectToString(int[] value) {
            if (value == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(value[i]);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleHelper
    extends TypeHelper<Double> {
        DoubleHelper() {
        }

        @Override
        public Double stringToObject(String str) {
            return str == null ? null : new Double(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanHelper
    extends TypeHelper<Boolean> {
        BooleanHelper() {
        }

        @Override
        public Boolean stringToObject(String str) {
            return str == null ? null : ("true".equals(str) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerHelper
    extends TypeHelper<Integer> {
        IntegerHelper() {
        }

        @Override
        public Integer stringToObject(String str) {
            return str == null ? null : new Integer(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringArrayHelper
    extends TypeHelper<String[]> {
        StringArrayHelper() {
        }

        @Override
        public String[] stringToObject(String str) {
            if (str == null) {
                return null;
            }
            ArrayList<String> strings = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '|') {
                    strings.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (ch == '~') {
                    if (++i >= len) continue;
                    ch = str.charAt(i);
                    if (ch == '@') {
                        strings.add(null);
                        sb.setLength(0);
                        ++i;
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            strings.add(sb.toString());
            return strings.toArray(new String[strings.size()]);
        }

        @Override
        public String objectToString(String[] strings) {
            if (strings == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            int len = strings.length;
            for (int i = 0; i < len; ++i) {
                String str;
                if (i > 0) {
                    sb.append('|');
                }
                if ((str = strings[i]) == null) {
                    sb.append("~@");
                    continue;
                }
                int strLen = str.length();
                for (int j = 0; j < strLen; ++j) {
                    char ch = str.charAt(j);
                    if (ch == '|') {
                        sb.append("~|");
                        continue;
                    }
                    if (ch == '~') {
                        sb.append("~~");
                        continue;
                    }
                    sb.append(ch);
                }
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PasswordHelper
    extends TypeHelper<String> {
        private static final long SEED = 5671709L;

        PasswordHelper() {
        }

        @Override
        public String stringToObject(String str) {
            if (str == null) {
                return null;
            }
            if (Comparison.isEmpty(str)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int len = str.length();
            if (len % 4 != 0) {
                throw new IllegalStateException("Bad hex-encoded password: " + str);
            }
            int strLen = len / 4;
            long mask = 5671709L;
            for (int i = 0; i < strLen; ++i) {
                mask = mask * 11L / 7L + (long)i;
                String hexStr = str.substring(i * 4, i * 4 + 4);
                int transformed = Integer.parseInt(hexStr, 16);
                char ch = (char)((long)transformed ^ mask);
                sb.append(ch);
            }
            return sb.toString();
        }

        @Override
        public String objectToString(String str) {
            if (str == null) {
                return null;
            }
            if (Comparison.isEmpty(str)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int strLen = str.length();
            long mask = 5671709L;
            for (int i = 0; i < strLen; ++i) {
                mask = mask * 11L / 7L + (long)i;
                char transformed = (char)(str.charAt(i) ^ (char)mask);
                String hexString = Integer.toHexString(transformed);
                int hexLen = hexString.length();
                if (hexLen < 4) {
                    for (int j = 3 - hexLen; j >= 0; --j) {
                        sb.append('0');
                    }
                } else if (hexLen != 4) {
                    throw new InternalError("Bad password conversion!");
                }
                sb.append(hexString);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringHelper
    extends TypeHelper<String> {
        StringHelper() {
        }

        @Override
        public String stringToObject(String str) {
            return str;
        }

        @Override
        public String objectToString(String obj) {
            return obj;
        }
    }
}

