/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.lang;

import java.util.Arrays;
import java.util.Locale;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.lang.MultiLingualText;

public class MultiLingualTextImpl
implements MultiLingualText {
    private String key;
    private Object[] params;

    public MultiLingualTextImpl(String messageKey, Object ... messageParams) {
        this.key = messageKey;
        this.params = messageParams;
        if (this.params != null && this.params.length == 0) {
            this.params = null;
        }
    }

    public String getRawText() {
        return this.params == null ? this.key : this.key + Arrays.toString(this.params);
    }

    public String getText() {
        String text = this.params == null ? LanguageSupport.getLocalizedString(this.key) : LanguageSupport.getLocalizedString(this.key, this.getTranslatedParams());
        return text;
    }

    protected Object[] getTranslatedParams() {
        Object[] translatedParams = null;
        if (this.params != null) {
            int len = this.params.length;
            translatedParams = new Object[len];
            for (int i = 0; i < len; ++i) {
                if (this.params[i] == null) {
                    translatedParams[i] = null;
                    continue;
                }
                if (this.params[i] instanceof MultiLingualText) {
                    MultiLingualText multilingualParam = (MultiLingualText)this.params[i];
                    translatedParams[i] = multilingualParam.getText(LanguageSupport.getCurrentLocale());
                    continue;
                }
                translatedParams[i] = this.params[i];
            }
        }
        return translatedParams;
    }

    public String getText(Locale loc) {
        if (loc == null || loc.equals(LanguageSupport.getCurrentLocale())) {
            return this.getText();
        }
        throw new UnsupportedOperationException("Cannot get text for a locale (" + loc + ") that is not the current locale (" + LanguageSupport.getCurrentLocale() + ")");
    }

    public String getText(String localeId) {
        if (localeId == null || localeId.equals(LanguageSupport.getCurrentLocale().toString())) {
            return this.getText();
        }
        throw new UnsupportedOperationException("Cannot get text for a locale (" + localeId + ") that is not the current locale (" + LanguageSupport.getCurrentLocale() + ")");
    }
}

