/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.sfac.file.FileUtils;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedStringTracker {
    static Log log = LogFactory.getLog(LocalizedStringTracker.class);
    private static final String THIS_PACKAGE_NAME = LocalizedStringTracker.class.getPackage().getName();
    private String reportFileName;
    private String[] bundleNames;
    private Map<String, StringUsageInfo> usage = new TreeMap<String, StringUsageInfo>();

    public LocalizedStringTracker(String newReportFileName) {
        this.reportFileName = newReportFileName;
    }

    public void stringDefined(String bundleName, String key, String value) {
        StringUsageInfo info = this.getInfo(key);
        info.setStringDefined(bundleName);
    }

    public void init(String[] managerBundleNames) {
        this.bundleNames = managerBundleNames;
        this.loadAll();
    }

    public void stringUsed(String bundleName, String key, String value, int nbrParams) {
        StringUsageInfo info = this.getInfo(key);
        info.setStringUsed(bundleName, value, nbrParams);
        this.addCallingPoint(info);
    }

    public void stringNotFound(String key, String defaultValue, int nbrParams) {
        StringUsageInfo info = this.getInfo(key);
        info.setStringNotFound(defaultValue, nbrParams);
        this.addCallingPoint(info);
    }

    private StringUsageInfo getInfo(String key) {
        StringUsageInfo info = this.usage.get(key);
        if (info == null) {
            info = new StringUsageInfo(key);
            this.usage.put(key, info);
        }
        return info;
    }

    public void saveAll() throws IOException {
        String defaultBundleName = this.bundleNames[this.bundleNames.length - 1];
        File fil = new File(this.reportFileName);
        log.info((Object)("Save tracked string info in " + fil));
        FileUtils.ensureParentDirectoryExists(fil);
        BufferedWriter wr = new BufferedWriter(new FileWriter(fil));
        wr.write("# Generated properties based on usage of bundle: ");
        wr.write(defaultBundleName);
        wr.newLine();
        wr.newLine();
        wr.newLine();
        wr.write("# Keys not found");
        wr.newLine();
        wr.write("# -------------------------------------------------------");
        wr.newLine();
        wr.newLine();
        for (String key : this.usage.keySet()) {
            StringUsageInfo info = this.usage.get(key);
            if (info.isDefined()) continue;
            wr.write(info.getComment());
            wr.newLine();
            wr.write(info.getProperty());
            wr.newLine();
        }
        int nbrBundles = this.bundleNames.length;
        for (int i = 0; i < nbrBundles; ++i) {
            wr.newLine();
            wr.newLine();
            String bundleName = this.bundleNames[i];
            wr.write("# Usage of bundle: " + bundleName);
            wr.newLine();
            wr.write("# -------------------------------------------------------");
            wr.newLine();
            wr.newLine();
            for (String key : this.usage.keySet()) {
                StringUsageInfo info = this.usage.get(key);
                if (!info.usedByBundle(bundleName)) continue;
                wr.write(info.getProperty());
                wr.newLine();
            }
        }
        wr.close();
    }

    public void loadAll() {
        File fil = new File(this.reportFileName);
        if (fil.exists()) {
            try {
                String line;
                log.info((Object)("Load tracked string info from " + fil));
                BufferedReader br = new BufferedReader(new FileReader(fil));
                while ((line = br.readLine()) != null) {
                    if (!Comparison.isDefined(line)) continue;
                    if (line.startsWith("#% ")) {
                        this.stringNotFoundReloaded(line);
                        br.readLine();
                        continue;
                    }
                    if (line.startsWith("#")) continue;
                    this.propertyReloaded(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                log.error((Object)("Failed to load existing tracker info from: " + fil), (Throwable)ioe);
            }
        } else {
            log.info((Object)("No existing tracked string info (" + fil + ")"));
        }
    }

    private void addCallingPoint(StringUsageInfo info) {
        StackTraceElement[] stack;
        String callingPoint = null;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (className.startsWith("java.") || className.startsWith(THIS_PACKAGE_NAME) || className.startsWith("net.sf.sfac.gui.framework")) continue;
            callingPoint = element.toString();
            break;
        }
        if (callingPoint != null) {
            info.addCallingPoint(callingPoint);
        }
    }

    private void stringNotFoundReloaded(String comment) {
        String[] tokens = comment.substring(3).split("\\|");
        String key = tokens[0];
        StringUsageInfo info = this.getInfo(key);
        info.setStringNotFoundReloaded(tokens);
    }

    private void propertyReloaded(String line) {
        int equalIndex = line.indexOf(61);
        if (equalIndex > 0) {
            String key = line.substring(0, equalIndex);
            String value = line.substring(equalIndex + 1);
            if (!value.startsWith("NOT USED")) {
                StringUsageInfo info = this.getInfo(key);
                info.setStringUsed(value);
            }
        } else {
            log.error((Object)("Wrong property line in tracker info: " + line));
        }
    }

    static class StringUsageInfo {
        private String[] defBundleNames;
        private String key;
        private String translation;
        private int nbrParams;
        private Set<String> callingPoints = new HashSet<String>();

        public StringUsageInfo(String newKey) {
            this.key = newKey;
        }

        public void setStringNotFoundReloaded(String[] tokens) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parse tokens: " + Arrays.toString(tokens)));
            }
            this.translation = tokens[1];
            this.nbrParams = Integer.parseInt(tokens[2]);
            for (int i = 3; i < tokens.length; ++i) {
                this.callingPoints.add(tokens[i]);
            }
        }

        public void setStringNotFound(String defaultValue, int newNbrParams) {
            this.translation = defaultValue;
            this.nbrParams = newNbrParams;
        }

        public void setStringDefined(String bundleName) {
            if (bundleName == null) {
                throw new IllegalArgumentException("bundleName cannot be null");
            }
            if (this.defBundleNames == null) {
                this.defBundleNames = new String[]{bundleName};
            } else if (!this.usedByBundle(bundleName)) {
                int len = this.defBundleNames.length;
                String[] newNames = new String[len + 1];
                System.arraycopy(this.defBundleNames, 0, newNames, 0, len);
                newNames[len] = bundleName;
                this.defBundleNames = newNames;
            }
        }

        public boolean isDefined() {
            return this.defBundleNames != null;
        }

        public boolean usedByBundle(String bundleName) {
            int len = this.defBundleNames == null ? 0 : this.defBundleNames.length;
            for (int i = 0; i < len; ++i) {
                if (!this.defBundleNames[i].equals(bundleName)) continue;
                return true;
            }
            return false;
        }

        public void setStringUsed(String bundleName, String newTranslation, int newNbrParams) {
            this.setStringDefined(bundleName);
            this.translation = newTranslation;
            this.nbrParams = newNbrParams;
        }

        public void setStringUsed(String newTranslation) {
            this.translation = newTranslation;
        }

        public void addCallingPoint(String callingPoint) {
            this.callingPoints.add(callingPoint);
        }

        private String getSingleLineTranslation() {
            return Comparison.isEmpty(this.translation) ? "?" : this.translation.replaceAll("\n", "\\n");
        }

        public String getComment() {
            StringBuffer sb = new StringBuffer();
            sb.append("#% ");
            sb.append(this.key);
            sb.append('|');
            sb.append(this.getSingleLineTranslation());
            sb.append('|');
            sb.append(this.nbrParams);
            for (String callingPoint : this.callingPoints) {
                sb.append('|');
                sb.append(callingPoint);
            }
            return sb.toString();
        }

        public String getProperty() {
            String status = this.defBundleNames == null ? (this.translation == null ? "???" : "?" + this.translation) : (this.translation == null ? "NOT USED" : this.getSingleLineTranslation());
            if (this.nbrParams > 0) {
                status = status + " [" + this.nbrParams + "]";
            }
            if (this.defBundleNames != null && this.defBundleNames.length > 1) {
                status = status + " DUPLICATE(" + Arrays.toString(this.defBundleNames) + ")";
            }
            return this.key + "=" + status;
        }
    }
}

