/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.sfac.file.LineReader;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineReaderFilteringHtml
extends LineReader {
    private static Log log = LogFactory.getLog(LineReaderFilteringHtml.class);
    private static final Map<String, String> ENTITIES = new HashMap<String, String>();
    private List<String> lineBuffer = new ArrayList<String>();
    private boolean eof = false;
    private boolean keepNewLine = false;

    public LineReaderFilteringHtml(BufferedReader reader) throws IOException {
        super(reader);
    }

    public LineReaderFilteringHtml(Class<?> loader, String resourceName) throws IOException {
        super(loader, resourceName);
    }

    public LineReaderFilteringHtml(File src) throws IOException {
        super(src);
    }

    public LineReaderFilteringHtml(URL src) throws IOException {
        super(src);
    }

    @Override
    protected String readLineImpl() throws IOException {
        String line = null;
        this.fillBuffer();
        if (this.lineBuffer.size() > 0) {
            line = this.lineBuffer.remove(0);
        }
        return line;
    }

    private void fillBuffer() throws IOException {
        StringBuffer currentBuffer = null;
        int currentIndex = 0;
        while (!this.eof && this.lineBuffer.size() < 2) {
            String line = super.readLineImpl();
            if (line != null) {
                if (currentBuffer == null) {
                    currentIndex = this.lineBuffer.size() - 1;
                    if (currentIndex < 0) {
                        currentIndex = 0;
                        this.lineBuffer.add("");
                        currentBuffer = new StringBuffer();
                    } else {
                        currentBuffer = new StringBuffer(this.lineBuffer.get(currentIndex));
                    }
                }
                currentIndex = this.addLine(line, this.lineBuffer, currentBuffer, currentIndex);
                continue;
            }
            this.eof = true;
        }
        if (currentBuffer != null) {
            this.lineBuffer.set(currentIndex, currentBuffer.toString());
        }
    }

    private int addLine(String line, List<String> lineBuffer2, StringBuffer currentBuffer, int currentIndex) {
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            char ch = line.charAt(i);
            if (ch <= ' ') {
                currentBuffer.append(' ');
                continue;
            }
            if (ch == '<') {
                String tag = this.getTag(line, i + 1, len);
                if (this.isParagraphTag(tag)) {
                    currentIndex = this.newLine(currentBuffer, currentIndex);
                    currentIndex = this.newLine(currentBuffer, currentIndex);
                } else if (this.isNewLineTag(tag)) {
                    currentIndex = this.newLine(currentBuffer, currentIndex);
                } else if (this.isKeepNewLineStartTag(tag)) {
                    this.keepNewLine = true;
                } else if (this.isKeepNewLineEndTag(tag)) {
                    this.keepNewLine = false;
                }
                i += tag.length() + 1;
                continue;
            }
            if (ch == '&') {
                String entity = this.getEntity(line, i + 1, len);
                String mappedEntity = ENTITIES.get(entity);
                if (mappedEntity == null) {
                    log.warn((Object)("Unknown entity &" + entity + "; in '" + this.getSourceName() + "' at line " + this.getLineIndex()));
                    currentBuffer.append(entity);
                    i += entity.length();
                    continue;
                }
                currentBuffer.append(mappedEntity);
                i += entity.length() + 1;
                continue;
            }
            currentBuffer.append(ch);
        }
        if (this.keepNewLine) {
            currentIndex = this.newLine(currentBuffer, currentIndex);
        }
        return currentIndex;
    }

    private boolean isKeepNewLineStartTag(String tag) {
        return Comparison.startsWithIgnoreCase(tag, "pre");
    }

    private boolean isKeepNewLineEndTag(String tag) {
        if (Comparison.startsWithIgnoreCase(tag, "/pre")) {
            return true;
        }
        if (Comparison.startsWithIgnoreCase(tag, "body")) {
            return true;
        }
        return Comparison.startsWithIgnoreCase(tag, "html");
    }

    private int newLine(StringBuffer currentBuffer, int currentIndex) {
        this.lineBuffer.set(currentIndex, currentBuffer.toString().trim());
        this.lineBuffer.add("");
        currentBuffer.setLength(0);
        return ++currentIndex;
    }

    private boolean isNewLineTag(String tag) {
        if (Comparison.startsWithIgnoreCase(tag, "br")) {
            return true;
        }
        if (Comparison.startsWithIgnoreCase(tag, "body")) {
            return true;
        }
        if (Comparison.startsWithIgnoreCase(tag, "/h1")) {
            return true;
        }
        if (Comparison.startsWithIgnoreCase(tag, "/h2")) {
            return true;
        }
        return Comparison.startsWithIgnoreCase(tag, "/title");
    }

    private boolean isParagraphTag(String tag) {
        if (tag.equalsIgnoreCase("p")) {
            return true;
        }
        return Comparison.startsWithIgnoreCase(tag, "p ");
    }

    private String getTag(String line, int i, int len) {
        char ch;
        StringBuffer sb = new StringBuffer();
        for (int j = i; j < len && (ch = line.charAt(j)) != '>'; ++j) {
            sb.append(ch);
        }
        return sb.toString();
    }

    private String getEntity(String line, int i, int len) {
        StringBuffer sb = new StringBuffer();
        for (int j = i; j < len; ++j) {
            if (j - i > 8) {
                return "";
            }
            char ch = line.charAt(j);
            if (ch == ';') break;
            sb.append(ch);
        }
        return sb.toString();
    }

    static {
        ENTITIES.put("gt", ">");
        ENTITIES.put("lt", "<");
        ENTITIES.put("apos", "'");
        ENTITIES.put("quot", "\"");
        ENTITIES.put("eacute", "\ufffd");
        ENTITIES.put("egrave", "\ufffd");
        ENTITIES.put("ecirc", "\ufffd");
        ENTITIES.put("agrave", "\ufffd");
        ENTITIES.put("acirc", "\ufffd");
        ENTITIES.put("icirc", "\ufffd");
        ENTITIES.put("ugrave", "\ufffd");
        ENTITIES.put("ocirc", "\ufffd");
        ENTITIES.put("nbsp", " ");
        ENTITIES.put("laquo", "\"");
        ENTITIES.put("raquo", "\"");
        ENTITIES.put("ntilde", "\ufffd");
    }
}

