/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.sfac.file.InvalidPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePathUtils {
    private static Log log = LogFactory.getLog(FilePathUtils.class);
    private static char separatorChar = File.separatorChar;
    private boolean ignoreCase;
    private String appBaseDrive;
    private String appBasePath;

    public FilePathUtils(File baseDir) {
        this.ignoreCase = this.checkFileSystemIgnoreCase();
        try {
            this.appBasePath = baseDir.getCanonicalPath();
            this.appBaseDrive = FilePathUtils.getDrive(this.appBasePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The base directory '" + baseDir + "' is invalid !", e);
        }
    }

    public FilePathUtils(String basePath, boolean ignoreCaseInPaths) {
        this.ignoreCase = ignoreCaseInPaths;
        separatorChar = (char)(basePath.indexOf(92) >= 0 ? 92 : 47);
        try {
            this.appBaseDrive = FilePathUtils.getDrive(basePath);
            this.appBasePath = this.canonicalize(basePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The base directory '" + basePath + "' is invalid !", e);
        }
    }

    public char getSparatorChar() {
        return separatorChar;
    }

    private boolean checkFileSystemIgnoreCase() {
        boolean fileSystemIgnoresCase = true;
        boolean checked = false;
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            File fil = new File(tempDir);
            String filePath = fil.getAbsolutePath();
            String uppercaseFilePath = filePath.toUpperCase();
            String lowercaseFilePath = filePath.toLowerCase();
            if (!lowercaseFilePath.equals(uppercaseFilePath)) {
                File uppercaseFile = new File(uppercaseFilePath);
                File lowercaseFile = new File(lowercaseFilePath);
                fileSystemIgnoresCase = uppercaseFile.exists() && lowercaseFile.exists();
                checked = true;
            }
            if (!checked) {
                log.warn((Object)"Cannot check if file system is case-senstive (assume it is not)");
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot check if file system is case-senstive (assume it is not)", (Throwable)e);
        }
        return fileSystemIgnoresCase;
    }

    public String getBasePath() {
        return this.appBasePath;
    }

    public String getAbsoluteFilePath(String filePath) throws InvalidPathException {
        String result;
        if (filePath == null) {
            return null;
        }
        if (FilePathUtils.isWhite(filePath) || FilePathUtils.isThisPath(filePath)) {
            return this.appBasePath;
        }
        if (!FilePathUtils.isAbsolute(filePath)) {
            filePath = FilePathUtils.concatPaths(this.appBasePath, filePath);
        }
        if (this.appBaseDrive != null && FilePathUtils.getDrive(filePath) == null) {
            filePath = this.appBaseDrive + filePath;
        }
        if ((result = this.canonicalize(filePath)).startsWith("..")) {
            throw new InvalidPathException("Too many '..' in path '" + filePath + "'");
        }
        return result;
    }

    public String canonicalize(String originalPath) throws InvalidPathException {
        if (originalPath == null) {
            return null;
        }
        boolean startWithSlash = FilePathUtils.startsWithSlash(originalPath);
        if (startWithSlash && this.appBaseDrive != null) {
            originalPath = this.appBaseDrive + originalPath;
            startWithSlash = false;
        }
        List<String> tokens = this.tokenize(originalPath);
        this.canonicalize(tokens);
        if (startWithSlash && tokens.size() > 0 && tokens.get(0).equals("..")) {
            throw new InvalidPathException("Too many '..' in path '" + originalPath + "'");
        }
        return this.buildPath(tokens, startWithSlash);
    }

    private void canonicalize(List<String> tokens) throws InvalidPathException {
        int len = tokens.size();
        for (int i = 0; i < len; ++i) {
            String token = tokens.get(i);
            if (token.equals(".")) {
                tokens.remove(i);
                --i;
                --len;
                continue;
            }
            if (token.equals("..")) {
                if (i <= 0) continue;
                String previousToken = tokens.get(i - 1);
                if (previousToken.indexOf(58) >= 0) {
                    throw new InvalidPathException("Too many '..' in path conflicting with drive letter '" + previousToken + "\\'");
                }
                if (previousToken.equals("..")) continue;
                tokens.remove(i);
                tokens.remove(i - 1);
                i -= 2;
                len -= 2;
                continue;
            }
            this.checkPathItem(token, i);
        }
    }

    private String buildPath(List<String> tokens, boolean startWithSlash) {
        int len = tokens.size();
        if (len == 0) {
            return startWithSlash ? String.valueOf(separatorChar) : ".";
        }
        StringBuilder sb = new StringBuilder();
        if (startWithSlash) {
            sb.append(separatorChar);
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separatorChar);
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    private List<String> tokenize(String path) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (ch == '/' || ch == '\\') {
                if (sb.length() <= 0) continue;
                tokens.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        return tokens;
    }

    private void checkPathItem(String str, int pos) throws InvalidPathException {
        int len = str.length();
        if (len == 0) {
            throw new InvalidPathException("Empty path item");
        }
        block4: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case ':': {
                    if (len == 2 && i == 1 && pos == 0) continue block4;
                }
                case '\"': 
                case '*': 
                case '/': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    throw new InvalidPathException("Illegal character '" + str.charAt(i) + "' in path item '" + str + "'");
                }
            }
        }
    }

    public String getRelativeFilePath(String filePath) throws InvalidPathException {
        List<String> relativeTokens;
        int diffIndex;
        if (filePath == null) {
            return null;
        }
        if (FilePathUtils.isWhite(filePath) || FilePathUtils.isThisPath(filePath)) {
            return ".";
        }
        if (!FilePathUtils.isAbsolute(filePath) && !FilePathUtils.startsWithSlash(filePath)) {
            return this.canonicalize(filePath);
        }
        List<String> baseTokens = this.tokenize(this.appBasePath);
        List<String> pathTokens = this.tokenize(filePath);
        int len = Math.min(baseTokens.size(), pathTokens.size());
        for (diffIndex = 0; diffIndex < len && this.equalsCheckCase(baseTokens.get(diffIndex), pathTokens.get(diffIndex)); ++diffIndex) {
        }
        boolean startWithSlash = false;
        if (diffIndex == 0) {
            relativeTokens = pathTokens;
            startWithSlash = this.appBaseDrive == null;
        } else {
            int i;
            relativeTokens = new ArrayList<String>();
            for (i = 0; i < baseTokens.size() - diffIndex; ++i) {
                relativeTokens.add("..");
            }
            for (i = diffIndex; i < pathTokens.size(); ++i) {
                relativeTokens.add(pathTokens.get(i));
            }
        }
        this.canonicalize(relativeTokens);
        if (startWithSlash && relativeTokens.size() > 0 && relativeTokens.get(0).equals("..")) {
            throw new InvalidPathException("Too many '..' in path '" + filePath + "'");
        }
        return this.buildPath(relativeTokens, startWithSlash);
    }

    private static boolean startsWithSeparator(String str) {
        return str.startsWith("/") || str.startsWith("\\");
    }

    private static boolean endsWithSeparator(String str) {
        return str.endsWith("/") || str.endsWith("\\");
    }

    private static boolean isThisPath(String str) {
        return "./".equals(str) || ".\\".equals(str) || ".".equals(str);
    }

    public static boolean isAbsolute(String filePath) {
        if (filePath == null) {
            return false;
        }
        if (separatorChar == '\\') {
            return filePath.indexOf(58) > 0;
        }
        return FilePathUtils.startsWithSeparator(filePath);
    }

    public static boolean startsWithSlash(String filePath) {
        if (filePath == null) {
            return false;
        }
        int len = filePath.length();
        if (len < 1) {
            return false;
        }
        return separatorChar == filePath.charAt(0);
    }

    public static String getDrive(String filePath) {
        if (filePath == null) {
            return null;
        }
        int colonIndex = filePath.indexOf(58);
        return colonIndex > 0 ? filePath.substring(0, colonIndex + 1) : null;
    }

    public static String concatPaths(String firstPath, String secondPath) {
        if (FilePathUtils.isWhite(secondPath)) {
            return firstPath;
        }
        if (FilePathUtils.isAbsolute(secondPath)) {
            return secondPath;
        }
        if (FilePathUtils.isWhite(firstPath) || FilePathUtils.isThisPath(firstPath)) {
            return secondPath;
        }
        if (FilePathUtils.endsWithSeparator(firstPath)) {
            return firstPath + secondPath;
        }
        return firstPath + File.separator + secondPath;
    }

    private boolean equalsCheckCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        if (this.ignoreCase) {
            return str1.equalsIgnoreCase(str2);
        }
        return str1.equals(str2);
    }

    private static boolean isWhite(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        if (fileName.lastIndexOf(47) > lastDotIndex) {
            return null;
        }
        if (fileName.lastIndexOf(92) > lastDotIndex) {
            return null;
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static String getDirectoryPath(String filePath) {
        int lastBackSlashIndex;
        if (filePath == null) {
            return null;
        }
        int lastSlashIndex = filePath.lastIndexOf(47);
        int index = Math.max(lastSlashIndex, lastBackSlashIndex = filePath.lastIndexOf(92));
        if (index >= 0) {
            return filePath.substring(0, index);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        int lastBackSlashIndex;
        if (filePath == null) {
            return null;
        }
        int lastSlashIndex = filePath.lastIndexOf(47);
        int index = Math.max(lastSlashIndex, lastBackSlashIndex = filePath.lastIndexOf(92));
        if (index >= 0) {
            return filePath.substring(index + 1);
        }
        return filePath;
    }
}

