/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import net.sf.sfac.file.FileType;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileChooserHelper {
    private static Log log = LogFactory.getLog(FileChooserHelper.class);
    private static final String DEFAULT_CHOOSER_DIRECTORY = "chooser.default.directory";
    private String id;
    private Settings setts;
    private JFileChooser chooser;
    private File preSelectedFile;
    private boolean useAllFilter;
    private FileType[] acceptedTypes;
    private String dialogTitleKey;
    private String dialogChooseKey;
    private String chooserDirectoryKey;

    public FileChooserHelper(String helperId, Settings settngs) {
        this.id = helperId;
        this.setts = settngs;
        this.chooser = new JFileChooser();
        this.dialogTitleKey = this.id + "_TITLE";
        this.dialogChooseKey = this.id + "_CHOOSE";
        this.chooserDirectoryKey = this.id + ".default.directory";
    }

    public int getFileSelectionMode() {
        return this.chooser.getFileSelectionMode();
    }

    public void setFileSelectionMode(int enabled) {
        this.chooser.setFileSelectionMode(enabled);
    }

    public void setDialogTitle(String title) {
        this.dialogTitleKey = title;
    }

    public String getDialogTitle() {
        return this.dialogTitleKey;
    }

    public void setPreSelectedFile(File f) {
        this.preSelectedFile = f;
    }

    public File getPreSelectedFile() {
        return this.preSelectedFile;
    }

    public void setAcceptedFileTypes(boolean useAll, FileType ... types) {
        this.useAllFilter = useAll;
        this.acceptedTypes = types;
    }

    public File selectSingleFile(Component parent) {
        File selected = null;
        this.chooser.setMultiSelectionEnabled(false);
        this.setupChooserSelection();
        if (this.chooser.showOpenDialog(parent) == 0) {
            selected = this.chooser.getSelectedFile();
            this.storeDefaultDirectorySetting();
        }
        return selected;
    }

    public File[] selectMultipleFiles(Component parent) {
        File[] selected = null;
        this.chooser.setMultiSelectionEnabled(true);
        this.setupChooserSelection();
        if (this.chooser.showOpenDialog(parent) == 0) {
            selected = this.chooser.getSelectedFiles();
            this.storeDefaultDirectorySetting();
        }
        return selected;
    }

    private void setupChooserSelection() {
        this.chooser.setDialogTitle(LanguageSupport.getOptionalLocalizedString(this.dialogTitleKey, "File selection"));
        this.chooser.setApproveButtonText(LanguageSupport.getOptionalLocalizedString(this.dialogChooseKey, "Select"));
        if (this.preSelectedFile == null) {
            String initialDirectory = this.setts.getFileProperty(this.chooserDirectoryKey, null);
            if (initialDirectory == null) {
                initialDirectory = this.setts.getFileProperty(DEFAULT_CHOOSER_DIRECTORY, null);
            }
            if (initialDirectory != null) {
                this.chooser.setCurrentDirectory(new File(initialDirectory));
            }
        } else {
            this.chooser.setSelectedFile(this.preSelectedFile);
        }
        if (this.acceptedTypes != null && this.acceptedTypes.length > 0) {
            this.addChoosableFileFilters();
        }
    }

    private void storeDefaultDirectorySetting() {
        String selectedPath = null;
        try {
            selectedPath = this.chooser.getCurrentDirectory().getAbsolutePath();
            this.setts.setFileProperty(this.chooserDirectoryKey, selectedPath);
            this.setts.setFileProperty(DEFAULT_CHOOSER_DIRECTORY, selectedPath);
        }
        catch (Exception e) {
            log.error((Object)("Cannot persist chooser current directory: " + selectedPath), (Throwable)e);
        }
    }

    private void addChoosableFileFilters() {
        if (this.useAllFilter) {
            this.chooser.setAcceptAllFileFilterUsed(false);
            this.chooser.addChoosableFileFilter(FileType.FILE_TYPE_ALL.getFileChooserFilter());
        }
        int len = this.acceptedTypes == null ? 0 : this.acceptedTypes.length;
        for (int i = len - 1; i >= 0; --i) {
            this.chooser.addChoosableFileFilter(this.acceptedTypes[i].getFileChooserFilter());
        }
    }
}

