/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.editor;

import java.util.List;
import java.util.Locale;
import net.sf.sfac.editor.ValidationMessage;
import net.sf.sfac.editor.ValidationMessageImpl;
import net.sf.sfac.editor.ValidationReport;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.lang.MultiLingualText;
import net.sf.sfac.lang.MultiLingualTextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionValidationReport
implements ValidationReport {
    @Override
    public ValidationMessage.Level getGlobalValidationLevel() {
        return ValidationMessage.Level.OK;
    }

    @Override
    public void addValidationMessage(ValidationMessage validationMsg) {
        if (validationMsg.getLevel() == ValidationMessage.Level.ERROR) {
            throw new ValidationException(validationMsg);
        }
    }

    @Override
    public void addMandatoryError(String fieldPath, String fieldName) {
        MultiLingualTextImpl translatedName = new MultiLingualTextImpl(fieldName, new Object[0]);
        this.addError(fieldPath, "MANDATORY_FIELD", translatedName);
    }

    @Override
    public void addError(String fieldPath, String key, Object ... params) {
        String path = fieldPath;
        this.addValidationMessage(new ValidationMessageImpl(ValidationMessage.Level.ERROR, path, key, params));
    }

    @Override
    public void addWarning(String fieldPath, String key, Object ... params) {
    }

    @Override
    public void addInfo(String fieldPath, String key, Object ... params) {
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        return null;
    }

    @Override
    public ValidationReport getContextReport(String fieldPath) {
        return this;
    }

    @Override
    public void removeValidationMessage(ValidationMessage validationMsg) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getName());
    }

    @Override
    public void removeAllValidationMessages() {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getName());
    }

    static class ValidationException
    extends RuntimeException
    implements MultiLingualText {
        private static final long serialVersionUID = 1171045898175437661L;
        ValidationMessage message;

        public ValidationException(ValidationMessage msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message.getText(LanguageSupport.getCurrentLocale());
        }

        public ValidationMessage getValidationMessage() {
            return this.message;
        }

        public String getText() {
            return this.message.getText();
        }

        public String getText(Locale loc) {
            return this.message.getText(loc);
        }

        public String getText(String localeId) {
            return this.message.getText(localeId);
        }
    }
}

