/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.utils;


import java.util.HashSet;
import java.util.Set;


/**
 * Global singleton object able to bring almost every object of an application.
 * 
 * @author Olivier Berlanger
 */
public final class ObjectBroker {

    private static ObjectBroker instance = new ObjectBroker();
    private Set<ObjectBrokerProvider> providers;


    public static ObjectBroker getInstance() {
        return instance;
    }


    private ObjectBroker() {
        providers = new HashSet<ObjectBrokerProvider>();
    }


    public static void addProvider(ObjectBrokerProvider provider) {
        instance.providers.add(provider);
    }


    public Object getObject(String objectId) {
        for (ObjectBrokerProvider provider : providers) {
            Object o = provider.getObject(objectId);
            if (o != null) return o;
        }
        return null;
    }

}
