/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.lang;


import java.util.Locale;


/**
 * Interface for object holding a text translatable in several locales.
 * 
 * @author Olivier Berlanger
 */
public interface MultiLingualText {

    /**
     * Get the value of the text for the default locale.
     * 
     * @return the value of the text for the default locale.
     */
    public String getText();


    /**
     * Get the value of the text for the specified locale. <br>
     * If a specific value for the given locale is not available, this method tries to find the most appropriate translation with
     * the usual <code>ResourceBundle</code> mechanism.
     * 
     * @return the value of the text for the specified locale.
     */
    public String getText(Locale loc);


    /**
     * Get the value of the text for the specified locale. <br>
     * If a specific value for the given locale is not available, this method tries to find the most appropriate translation with
     * the usual <code>ResourceBundle</code> mechanism.
     * 
     * @param localeId
     *            the ID of the locale (language_country_variant)
     * @return the value of the text for the specified locale.
     */
    public String getText(String localeId);

}
