/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.lang;


import java.util.Locale;


/**
 * A runtime exception implementing the MultiLingualText interface.
 * 
 * @author Olivier Berlanger
 */
public class MultiLingualRuntimeException extends RuntimeException implements MultiLingualText {

    private static final long serialVersionUID = 1217600414955360776L;

    private MultiLingualTextImpl text;


    public MultiLingualRuntimeException(String messageKey, Object... messageParams) {
        text = new MultiLingualTextImpl(messageKey, messageParams);
    }


    public MultiLingualRuntimeException(Throwable cause, String messageKey, Object... messageParams) {
        super(cause);
        text = new MultiLingualTextImpl(messageKey, messageParams);
    }


    public String getMessage() {
        return text.getText();
    }


    public String getText() {
        return text.getText();
    }


    public String getText(Locale loc) {
        return text.getText(loc);
    }


    public String getText(String localeId) {
        return text.getText(localeId);
    }

}
