/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.lang;


import java.text.MessageFormat;
import java.util.Locale;


/**
 * A doing-nothing implementation of the LanguageSupport abstract class. <br>
 * It will be instantiated by default by the language support when it is used without having been configured.
 */
public class LanguageSupportMock extends LanguageSupport {

    public LanguageSupportMock() {
    }


    @Override
    public LanguageSupport copyInstance() {
        return this;
    }


    @Override
    public String getLocalizedStringImpl(String key) {
        return key;
    }


    @Override
    public String getLocalizedStringImpl(String key, Object... params) {
        int len = (params == null) ? 0 : params.length;
        if (len > 0) {
            if (key.indexOf('{') >= 0) {
                return MessageFormat.format(key, params);
            } else {
                StringBuilder sb = new StringBuilder(key);
                sb.append("[");
                for (int i = 0; i < len; i++) {
                    if (i > 0) sb.append(",");
                    sb.append(params[i]);
                }
                sb.append("]");
                return sb.toString();
            }
        } else {
            return key;
        }
    }


    @Override
    public String getOptionalLocalizedStringImpl(String key, String defaultValue) {
        return defaultValue;
    }


    @Override
    public void updateLanguageImpl(String newLocaleId) {
    }


    @Override
    public Locale getCurrentLocaleImpl() {
        return Locale.getDefault();
    }


    @Override
    public void addLanguageListenerImpl(LanguageListener lis) {
    }


    @Override
    public void removeLanguageListenerImpl(LanguageListener lis) {
    }

}
