/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.lang;


import java.util.Locale;


/**
 * Multilingual support: listener interface to be notified by the LanguageSupport when the application language (or locale) is
 * changed.
 */
public interface LanguageListener {

    /**
     * Notification that the current application language has changed. Update all the language-dependent text in the actions. This
     * will trigger updates to associated UI components.
     * 
     * @param newLocale
     *            the new locale.
     */
    public void languageChanged(Locale newLocale);

}
