/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


/**
 * Base implementation of the Validator interface. <br>
 * This implementation checks if the edited object implements the Validable interface, and if so, defers validation to it.
 * 
 * @author Olivier Berlanger
 */
public class ValidatorImpl implements Validator {

    private boolean continuousValidation;


    public ValidatorImpl() {
        this(false);
    }


    public ValidatorImpl(boolean continuous) {
        continuousValidation = continuous;
    }


    public boolean supportsContinuousValidation() {
        return continuousValidation;
    }


    public void initContinuousValidationReport(Object editedObject, ValidationReport report) {
        validateValidableObject(editedObject, report);
    }


    public void validateModification(Object editedObject, String fieldPath, Object oldValue, Object newValue,
            ValidationReport report) {
        report.removeAllValidationMessages();
        validateValidableObject(editedObject, report);
    }


    public void validateBeforeCommit(Object editedObject, ValidationReport report) {
        validateValidableObject(editedObject, report);
    }


    /**
     * Validate the given object if it implements the <code>Validable</code> interface.
     */
    private void validateValidableObject(Object editedObject, ValidationReport report) {
        if ((editedObject != null) && (editedObject instanceof Validable)) {
            Validable val = (Validable) editedObject;
            val.validate(report);
        }
    }

}
