/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


/**
 * An interface to be implemented by objects wanting to provide validation of an edited object. <br>
 * The validation can happen at two stages:
 * <ul>
 * <li>Continuous validation: this validation is triggered at any modification event coming from the editor. you will get each time
 * the modification event and you are supposed to validate only the modified field. This validation uses a single validation report
 * that must be updated at each event.
 * <li>Before-commit validation: Should be a throughout validation verifying everything.
 * </ul>
 * 
 * @author Olivier Berlanger
 */
public interface Validator {

    public boolean supportsContinuousValidation();


    public void initContinuousValidationReport(Object editedObject, ValidationReport report);


    public void validateModification(Object editedObject, String fieldPath, Object oldValue, Object newValue,
            ValidationReport report);


    public void validateBeforeCommit(Object editedObject, ValidationReport report);

}
