/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


import java.util.ArrayList;
import java.util.List;

import net.sf.sfac.editor.ValidationMessage.Level;
import net.sf.sfac.lang.MultiLingualTextImpl;


public class ValidationReportImpl implements ValidationReport {

    // public static String buildPath(String basePath, String addedPath) {
    // if (Comparison.isEmpty(basePath)) return addedPath;
    // if (Comparison.isEmpty(addedPath)) return basePath;
    // return basePath + "." + addedPath;
    // }

    private List<ValidationMessage> messages;


    public Level getGlobalValidationLevel() {
        Level lev = Level.OK;
        if (messages != null) {
            for (ValidationMessage msg : messages) {
                if (msg.getLevel().greaterThan(lev)) lev = msg.getLevel();
            }
        }
        return lev;
    }


    public void addValidationMessage(ValidationMessage validationMsg) {
        if (messages == null) messages = new ArrayList<ValidationMessage>();
        messages.add(validationMsg);
    }


    public void removeValidationMessage(ValidationMessage validationMsg) {
        if (messages != null) {
            messages.remove(validationMsg);
        }
    }


    public void removeAllValidationMessages() {
        if (messages != null) {
            messages.clear();
        }
    }


    public void addMandatoryError(String fieldPath, String fieldName) {
        MultiLingualTextImpl translatedName = new MultiLingualTextImpl(fieldName);
        addError(fieldPath, "MANDATORY_FIELD", translatedName);
    }


    public void addError(String fieldPath, String key, Object... params) {
        String path = fieldPath;
        addValidationMessage(new ValidationMessageImpl(Level.ERROR, path, key, params));
    }


    public void addWarning(String fieldPath, String key, Object... params) {
        String path = fieldPath;
        addValidationMessage(new ValidationMessageImpl(Level.WARNING, path, key, params));
    }


    public void addInfo(String fieldPath, String key, Object... params) {
        String path = fieldPath;
        addValidationMessage(new ValidationMessageImpl(Level.INFO, path, key, params));
    }


    public List<ValidationMessage> getValidationMessages() {
        return messages;
    }


    public ValidationReport getContextReport(String fieldPath) {
        return this;
    }

}
