/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


import java.util.List;

import net.sf.sfac.editor.ValidationMessage.Level;


public interface ValidationReport {

    public Level getGlobalValidationLevel();


    public List<ValidationMessage> getValidationMessages();


    public void addValidationMessage(ValidationMessage validationMsg);


    public void removeValidationMessage(ValidationMessage validationMsg);


    public void removeAllValidationMessages();


    public void addMandatoryError(String fieldPath, String fieldName);


    public void addError(String fieldPath, String key, Object... params);


    public void addWarning(String fieldPath, String key, Object... params);


    public void addInfo(String fieldPath, String key, Object... params);


    public ValidationReport getContextReport(String fieldPath);

}
