/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


import net.sf.sfac.lang.MultiLingualTextImpl;


public class ValidationMessageImpl extends MultiLingualTextImpl implements ValidationMessage {

    private Level lev;
    private String fieldPath;


    public ValidationMessageImpl(Level theLevel, String theFieldPath, String key, Object... params) {
        super(key, params);
        lev = theLevel;
        fieldPath = theFieldPath;
    }


    public Level getLevel() {
        return lev;
    }


    public String getFieldPath() {
        return fieldPath;
    }

}
