/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


import net.sf.sfac.lang.MultiLingualText;


public interface ValidationMessage extends MultiLingualText {

    public static enum Level {
        OK, INFO, WARNING, ERROR;

        public boolean greaterThan(Level other) {
            return ordinal() > other.ordinal();
        }
    }


    public Level getLevel();


    public String getFieldPath();

}
