/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


/**
 * An interface to be implemented by objects able to validate themselves. <br>
 * This validable can perform only the part of validations not needing a wider context. For example mandatory fields, field length,
 * max values ... but not unicity of ids, cross references, comparing to old values or validation specific to the context action
 * (add, update, remove).
 * 
 * @author Olivier Berlanger
 */
public interface Validable {

    /**
     * Validate this object. <br>
     * Any problem (info/warning/error) is added in the given ValidationReport. If this object contains <code>Validable</code>
     * sub-objects, it can forward the validation call to them. In this case, the path must be correctly updated.
     * 
     * @param report
     *            the ValidationReport where to add any info/warning/error raised by the validation.
     */
    public void validate(ValidationReport report);

}
