/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.utils;

import java.net.URL;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceUtils {
    public static String getFullResourceName(Class<?> baseClass, String resourceName) {
        String packageName = baseClass.getPackage().getName();
        String basePath = packageName.replace('.', '/');
        return "/" + basePath + "/" + resourceName;
    }

    public static ImageIcon getImageIcon(Class<?> baseClass, String resourceName) {
        ImageIcon icon;
        URL imageURL = baseClass.getResource(resourceName);
        if (imageURL == null) {
            throw new IllegalArgumentException("Image not found in classpath: " + ResourceUtils.getFullResourceName(baseClass, resourceName));
        }
        try {
            icon = new ImageIcon(imageURL);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid image in URL: " + ResourceUtils.getFullResourceName(baseClass, resourceName) + " -> exception: " + e);
        }
        return icon;
    }
}

