/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    private static Log log = LogFactory.getLog(ReflectionUtils.class);

    public static String getFieldName(Method setterOrGetter) {
        String methodName = setterOrGetter.getName();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
    }

    public static Method getGetter(Class<?> baseClass, String fieldName, Class<?> fieldType) {
        return ReflectionUtils.getGetter(baseClass, fieldName, fieldType, true);
    }

    public static Method getGetter(Class<?> baseClass, String fieldName, Class<?> fieldType, boolean mandatory) {
        Method getter = null;
        String upperSuffix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String getterName = "get" + upperSuffix;
        try {
            getter = baseClass.getMethod(getterName, null);
        }
        catch (Exception e) {
            if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
                getterName = "is" + upperSuffix;
                try {
                    getter = baseClass.getMethod(getterName, null);
                }
                catch (Exception ee) {
                    String msg = "No method get" + upperSuffix + "() or " + getterName + "() found on " + baseClass;
                    if (mandatory) {
                        throw new IllegalArgumentException(msg, e);
                    }
                    log.info((Object)msg);
                }
            }
            String msg = "No getter method " + getterName + "() found on " + baseClass;
            if (mandatory) {
                throw new IllegalArgumentException(msg, e);
            }
            log.info((Object)("No gettet method " + getterName + "() found on " + baseClass));
        }
        return getter;
    }

    public static Method getSetter(Class<?> enclosingClass, String fieldName, Class<?> fieldType) {
        return ReflectionUtils.getSetter(enclosingClass, fieldName, fieldType, true);
    }

    public static Method getSetter(Class<?> enclosingClass, String fieldName, Class<?> fieldType, boolean mandatory) {
        Method setr = null;
        String setterName = null;
        try {
            setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            setr = enclosingClass.getMethod(setterName, fieldType);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "No setter method " + setterName + "(" + fieldType.getSimpleName() + ") found on " + enclosingClass;
            if (mandatory) {
                throw new IllegalArgumentException(msg, nsme);
            }
            log.info((Object)msg);
        }
        return setr;
    }

    public static Method getMethod(Class<?> enclosingClass, String prefix, String fieldName, String suffix, Class<?> ... params) {
        return ReflectionUtils.getMethod(enclosingClass, prefix, fieldName, suffix, true, params);
    }

    public static Method getMethod(Class<?> enclosingClass, String prefix, String fieldName, String suffix, boolean mandatory, Class<?> ... params) {
        Method mthd = null;
        String methodName = null;
        try {
            StringBuffer sb = new StringBuffer();
            if (!Comparison.isEmpty(prefix)) {
                sb.append(prefix);
            }
            sb.append(Character.toUpperCase(fieldName.charAt(0)));
            sb.append(fieldName.substring(1));
            if (!Comparison.isEmpty(suffix)) {
                sb.append(suffix);
            }
            methodName = sb.toString();
            mthd = enclosingClass.getMethod(methodName, params);
        }
        catch (NoSuchMethodException nsme) {
            String paramString = params == null || params.length == 0 ? "" : Arrays.toString(params);
            String msg = "No method " + methodName + "(" + paramString + ") found on " + enclosingClass;
            if (mandatory) {
                throw new IllegalArgumentException(msg, nsme);
            }
            log.info((Object)msg);
        }
        return mthd;
    }
}

