/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.utils;

import java.text.Collator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparison {
    public static boolean stringEquals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        String str1 = obj1 == null ? "" : obj1.toString().trim();
        String str2 = obj2 == null ? "" : obj2.toString().trim();
        return str1.equals(str2);
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static <T extends Comparable<T>> int compareTo(T obj1, T obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return 1;
        }
        if (obj2 == null) {
            return -1;
        }
        return obj1.compareTo(obj2);
    }

    public static int compareStrings(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (Comparison.isEmpty(str1)) {
            return Comparison.isEmpty(str2) ? 0 : 1;
        }
        if (Comparison.isEmpty(str2)) {
            return -1;
        }
        return Collator.getInstance(Locale.FRENCH).compare(str1, str2);
    }

    public static <T extends Enum<T>> int compareTo(T obj1, T obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return 1;
        }
        if (obj2 == null) {
            return -1;
        }
        return obj1.ordinal() < obj2.ordinal() ? -1 : 1;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(List<?> lst) {
        return lst == null || lst.size() == 0;
    }

    public static boolean isDefined(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return true;
        }
        return false;
    }

    public static boolean isDefined(List<?> lst) {
        return lst != null && lst.size() > 0;
    }

    public static boolean startsWithIgnoreCase(String checkedString, String start) {
        if (Comparison.isEmpty(start)) {
            throw new NullPointerException("Matching start string cannot be null or empty");
        }
        if (Comparison.isEmpty(checkedString)) {
            return false;
        }
        int startLen = start.length();
        return checkedString.regionMatches(true, 0, start, 0, startLen);
    }
}

