/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.string;

import java.io.IOException;
import java.io.Reader;
import net.sf.sfac.string.CharIterator;
import net.sf.sfac.string.StringUtils;

public class ReaderCharIterator
implements CharIterator {
    private Reader data;
    private boolean finished;
    private boolean lastWhite;
    private long count;

    public ReaderCharIterator(Reader rdr) {
        this.setData(rdr);
    }

    public void setData(Reader rdr) {
        this.data = rdr;
        this.finished = false;
        this.lastWhite = true;
        this.count = 0L;
    }

    public String getNormalizedString() {
        char ch;
        StringBuffer sb = new StringBuffer();
        while ((ch = this.nextNormalizedChar()) != '\u0000') {
            sb.append(ch);
        }
        return sb.toString();
    }

    public char nextChar() {
        ++this.count;
        if (this.finished) {
            return '\u0000';
        }
        try {
            int ch = this.data.read();
            if (ch < 0) {
                this.finished = true;
                return '\u0000';
            }
            if (ch == 0) {
                return '\u0001';
            }
            return (char)ch;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to read next character", ioe);
        }
    }

    public char nextNormalizedChar() {
        ++this.count;
        if (this.finished) {
            return '\u0000';
        }
        int ch = 0;
        boolean continueRead = true;
        while (continueRead) {
            ch = this.nextChar();
            if ((ch = StringUtils.removeDiacritic((char)ch)) == 0) {
                this.finished = true;
                continueRead = false;
                continue;
            }
            if (Character.isLetter((char)ch)) {
                ch = Character.toLowerCase((char)ch);
                this.lastWhite = false;
                continueRead = false;
                continue;
            }
            if (Character.isDigit((char)ch)) {
                this.lastWhite = false;
                continueRead = false;
                continue;
            }
            if (this.lastWhite) continue;
            ch = 32;
            this.lastWhite = true;
            continueRead = false;
        }
        return (char)ch;
    }

    public long getProcessedCharCount() {
        return this.count;
    }

    public void reset() {
        try {
            this.finished = false;
            this.lastWhite = true;
            this.data.reset();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to reset reader", ioe);
        }
    }
}

