/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.sfac.lang.MultiLingualText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLingualDirectText
implements MultiLingualText {
    private static final String DEFAULT_TEXT_KEY = "default";
    private Map<String, String> translations = new HashMap<String, String>();

    public MultiLingualDirectText(String defaultText) {
        this.translations.put(DEFAULT_TEXT_KEY, defaultText);
    }

    public void add(String localeId, String text) {
        if (localeId == null) {
            localeId = DEFAULT_TEXT_KEY;
        }
        this.translations.put(localeId, text);
    }

    public void remove(String localeId) {
        if (localeId == null) {
            throw new IllegalArgumentException("Locale id cannot be null");
        }
        this.translations.remove(localeId);
    }

    @Override
    public String getText() {
        return this.getText(Locale.getDefault());
    }

    @Override
    public String getText(Locale loc) {
        String text = null;
        if (loc != null) {
            text = this.translations.get(loc.toString());
            if (text == null) {
                text = this.translations.get("" + loc.getLanguage() + "_" + loc.getCountry());
            }
            if (text == null && loc.getLanguage() != null) {
                text = this.translations.get(loc.getLanguage());
            }
        }
        if (text == null) {
            text = this.translations.get(DEFAULT_TEXT_KEY);
        }
        return text;
    }

    @Override
    public String getText(String localeId) {
        String text = null;
        if (localeId != null) {
            text = this.translations.get(localeId);
        }
        if (text == null) {
            text = this.translations.get(DEFAULT_TEXT_KEY);
        }
        return text;
    }

    public Iterator<String> getAvailableLocaleIds() {
        return this.translations.keySet().iterator();
    }
}

