/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.lang;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.lang.LocalizedStringTracker;
import net.sf.sfac.lang.MultiLingualText;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LanguageSupportImpl
extends LanguageSupport
implements Cloneable {
    private static Log log = LogFactory.getLog(LanguageSupportImpl.class);
    private Locale currentLocale;
    private List<LanguageListener> listeners;
    private String[] bundleNames;
    private ResourceBundle[] bundles;
    private LocalizedStringTracker tracker;

    public LanguageSupportImpl(String bundleName, String startLocaleId) {
        String[] stringArray;
        if (bundleName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = bundleName;
        }
        this(stringArray, startLocaleId);
    }

    public LanguageSupportImpl(String[] allBundleNames, String startLocaleId) {
        if (allBundleNames == null || allBundleNames.length == 0) {
            throw new IllegalArgumentException("You must at least define one bundle");
        }
        if (startLocaleId == null) {
            throw new IllegalArgumentException("The start locale ID cannot be null");
        }
        this.bundleNames = allBundleNames;
        this.bundles = new ResourceBundle[0];
        log.info((Object)("Create " + this + " for bundles: " + Arrays.toString(allBundleNames)));
        this.updateLanguageImpl(startLocaleId);
    }

    public LanguageSupport copyInstance() {
        try {
            LanguageSupportImpl cloned = (LanguageSupportImpl)super.clone();
            cloned.listeners = null;
            cloned.bundles = new ResourceBundle[0];
            cloned.currentLocale = null;
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("Sould never happen");
        }
    }

    public void setTracker(LocalizedStringTracker newTracker) {
        this.tracker = newTracker;
        if (this.tracker != null) {
            for (int i = 0; i < this.bundles.length; ++i) {
                Enumeration<String> keys = this.bundles[i].getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    this.tracker.stringDefined(this.bundleNames[i], key, this.bundles[i].getString(key));
                }
            }
            this.tracker.init(this.bundleNames);
        }
    }

    public void saveTrackedInfo() {
        if (this.tracker != null) {
            try {
                this.tracker.saveAll();
            }
            catch (Exception e) {
                log.error((Object)"Unable to save LocalizedStringTracker info", (Throwable)e);
            }
        }
    }

    public void addResourceBundle(String bundleName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add resource bundle: '" + bundleName + "'"));
        }
        int len = this.bundleNames.length;
        String[] newNames = new String[len + 1];
        System.arraycopy(this.bundleNames, 0, newNames, 0, len);
        newNames[len] = bundleName;
        this.bundleNames = newNames;
        LanguageSupportImpl.updateLanguage(this.currentLocale.toString());
    }

    public String getLocalizedStringImpl(String key) {
        return this.getLocalizedStringInternal(key, key, null);
    }

    public String getLocalizedStringImpl(String key, Object ... params) {
        return this.getLocalizedStringInternal(key, key, params);
    }

    public String getOptionalLocalizedStringImpl(String key, String defaultValue) {
        return this.getLocalizedStringInternal(key, defaultValue, null);
    }

    private String getLocalizedStringInternal(String key, String defaultValue, Object[] params) {
        if (Comparison.isEmpty(key)) {
            return "";
        }
        String message = null;
        for (int i = this.bundles.length - 1; i >= 0; --i) {
            try {
                message = this.bundles[i].getString(key);
                if (this.tracker == null) break;
                this.tracker.stringUsed(this.bundleNames[i], key, message, params == null ? 0 : params.length);
                break;
            }
            catch (MissingResourceException mre) {
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Internal string localization exception: ", (Throwable)e);
            }
        }
        if (message == null) {
            message = defaultValue;
            if (this.tracker != null) {
                this.tracker.stringNotFound(key, defaultValue, params == null ? 0 : params.length);
            }
            log.warn((Object)("Language item not found: " + key));
        }
        return params == null ? message : this.format(message, params);
    }

    private String format(String message, Object[] params) {
        int nbrObject = params.length;
        Object[] translatedParams = new Object[nbrObject];
        for (int i = 0; i < nbrObject; ++i) {
            translatedParams[i] = params[i] == null ? "" : (params[i] instanceof MultiLingualText ? ((MultiLingualText)params[i]).getText(this.currentLocale) : params[i]);
        }
        return MessageFormat.format(message, translatedParams);
    }

    public void updateLanguageImpl(String newLocaleId) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Call of updateLanguage for new locale: " + newLocaleId + " (currentLocale = " + this.currentLocale + ")"));
            }
            if (this.bundleNames.length != this.bundles.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adapt bundle array length " + this.bundles.length + " -> " + this.bundleNames.length));
                }
                this.bundles = new ResourceBundle[this.bundleNames.length];
                this.currentLocale = null;
            }
            try {
                Locale newLocale;
                Locale locale = newLocale = newLocaleId == null ? Locale.getDefault() : LanguageSupportImpl.getLocale(newLocaleId);
                if (this.currentLocale != null && this.currentLocale.equals(newLocale)) break block7;
                log.info((Object)("Change application locale: " + this.currentLocale + " --> " + newLocale));
                try {
                    Locale.setDefault(newLocale);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to update default locale to: " + newLocale), (Throwable)e);
                }
                this.loadResources(newLocale);
                this.currentLocale = newLocale;
                this.fireLanguageChanged();
            }
            catch (Exception e) {
                log.error((Object)("Locale resource loading error for locale: '" + newLocaleId + "'"), (Throwable)e);
            }
        }
    }

    protected void loadResources(Locale newLocale) {
        int len = this.bundleNames.length;
        for (int i = 0; i < len; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  * Load bundle " + this.bundleNames[i] + "_" + newLocale + " (classloader = " + this.getClass().getClassLoader() + ")"));
            }
            this.bundles[i] = ResourceBundle.getBundle(this.bundleNames[i], newLocale, this.getClass().getClassLoader());
        }
    }

    public Locale getCurrentLocaleImpl() {
        return this.currentLocale;
    }

    private static Locale getLocale(String localeId) {
        String language = "";
        String country = "";
        String variant = "";
        int firstUnderscore = localeId.indexOf(95);
        if (firstUnderscore < 0) {
            language = localeId;
        } else {
            language = localeId.substring(0, firstUnderscore);
            int secondUnderscore = localeId.indexOf(95, firstUnderscore + 1);
            if (secondUnderscore < 0) {
                country = localeId.substring(firstUnderscore + 1);
            } else {
                country = localeId.substring(firstUnderscore + 1, secondUnderscore);
                variant = localeId.substring(secondUnderscore + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public void addLanguageListenerImpl(LanguageListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<LanguageListener>();
        }
        this.listeners.add(lis);
    }

    public void removeLanguageListenerImpl(LanguageListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    private void fireLanguageChanged() {
        int len;
        int n = len = this.listeners == null ? 0 : this.listeners.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fire Locale changed to '" + this.currentLocale + "' to " + len + " listeners"));
        }
        for (int i = 0; i < len; ++i) {
            LanguageListener lis = this.listeners.get(i);
            lis.languageChanged(this.currentLocale);
        }
    }
}

