/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineReader {
    private BufferedReader br;
    private String sourceName;
    private int lineIndex;
    private String line;

    public LineReader(File src) throws IOException {
        this.sourceName = src.getAbsolutePath();
        this.setup(new BufferedReader(new FileReader(src)));
    }

    public LineReader(URL src) throws IOException {
        this.sourceName = src.toExternalForm();
        this.setup(new BufferedReader(new InputStreamReader(src.openStream())));
    }

    public LineReader(Class<?> loader, String resourceName) throws IOException {
        URL resourceURL = loader.getResource(resourceName);
        this.sourceName = resourceURL.toExternalForm();
        this.setup(new BufferedReader(new InputStreamReader(resourceURL.openStream())));
    }

    public LineReader(BufferedReader reader) throws IOException {
        this.sourceName = "input stream";
        this.setup(reader);
    }

    private void setup(BufferedReader reader) {
        this.br = reader;
        this.lineIndex = 0;
    }

    public String peekLine() throws IOException {
        if (this.lineIndex <= 0) {
            this.line = this.readLineImpl();
        }
        return this.line;
    }

    public String peekNextLine() throws IOException {
        this.readLine();
        return this.line;
    }

    public String readLine() throws IOException {
        String returnedLine = this.line;
        this.line = this.readLineImpl();
        return returnedLine;
    }

    protected String readLineImpl() throws IOException {
        ++this.lineIndex;
        return this.br.readLine();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public void close() throws IOException {
        this.br.close();
    }
}

